/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.slack;

import java.io.IOException;
import java.io.InterruptedIOException;
import okhttp3.HttpUrl;
import okhttp3.slack.OAuthSession;
import okhttp3.slack.OAuthSessionFactory;
import okhttp3.slack.RtmSession;
import okhttp3.slack.SlackApi;
import okio.Timeout;

public final class SlackClient {
    private final SlackApi slackApi;
    private OAuthSessionFactory sessionFactory;
    private OAuthSession session;

    public SlackClient(SlackApi slackApi) {
        this.slackApi = slackApi;
    }

    public void requestOauthSession(String scopes, String team) throws Exception {
        if (this.sessionFactory == null) {
            this.sessionFactory = new OAuthSessionFactory(this.slackApi);
            this.sessionFactory.start();
        }
        HttpUrl authorizeUrl = this.sessionFactory.newAuthorizeUrl(scopes, team, session -> {
            this.initOauthSession(session);
            System.out.printf("session granted: %s\n", session);
        });
        System.out.printf("open this URL in a browser: %s\n", authorizeUrl);
    }

    public synchronized void initOauthSession(OAuthSession session) {
        this.session = session;
        this.notifyAll();
    }

    public synchronized void awaitAccessToken(Timeout timeout) throws InterruptedIOException {
        while (this.session == null) {
            timeout.waitUntilNotified((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRtm() throws IOException {
        String accessToken;
        SlackClient slackClient = this;
        synchronized (slackClient) {
            accessToken = this.session.access_token;
        }
        RtmSession rtmSession = new RtmSession(this.slackApi);
        rtmSession.open(accessToken);
    }

    public static void main(String ... args) throws Exception {
        String clientId = "0000000000.00000000000";
        String clientSecret = "00000000000000000000000000000000";
        int port = 53203;
        SlackApi slackApi = new SlackApi(clientId, clientSecret, port);
        SlackClient client = new SlackClient(slackApi);
        String scopes = "channels:history channels:read channels:write chat:write:bot chat:write:user dnd:read dnd:write emoji:read files:read files:write:user groups:history groups:read groups:write im:history im:read im:write mpim:history mpim:read mpim:write pins:read pins:write reactions:read reactions:write search:read stars:read stars:write team:read usergroups:read usergroups:write users:read users:write identify";
        client.requestOauthSession(scopes, null);
        client.awaitAccessToken(Timeout.NONE);
        client.startRtm();
    }
}

