//[okio](../../index.md)/[okio](../index.md)/[BufferedSource](index.md)/[readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md)



# readHexadecimalUnsignedLong  
[common]  
Content  
abstract fun [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  
More info  


Reads a long form this source in hexadecimal form (i.e., as a string in base 16). This will iterate until a non-hexadecimal character is found.

Buffer buffer = new Buffer()  
    .writeUtf8("ffff CAFEBABE 10");  
  
assertEquals(65535L, buffer.readHexadecimalUnsignedLong());  
assertEquals(' ', buffer.readByte());  
assertEquals(0xcafebabeL, buffer.readHexadecimalUnsignedLong());  
assertEquals(' ', buffer.readByte());  
assertEquals(0x10L, buffer.readHexadecimalUnsignedLong());

#### Throws  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/BufferedSource/readHexadecimalUnsignedLong/#/PointingToDeclaration/"></a>[kotlin.NumberFormatException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number-format-exception/index.html)| <a name="okio/BufferedSource/readHexadecimalUnsignedLong/#/PointingToDeclaration/"></a><br><br>if the found hexadecimal does not fit into a long or hexadecimal was not found.<br><br>
  
|  Name|  Summary| 
|---|---|
  


[jvm]  
Content  
abstract fun [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  
More info  


#### Throws  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/BufferedSource/readHexadecimalUnsignedLong/#/PointingToDeclaration/"></a>[kotlin.NumberFormatException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number-format-exception/index.html)| <a name="okio/BufferedSource/readHexadecimalUnsignedLong/#/PointingToDeclaration/"></a><br><br>if the found hexadecimal does not fit into a long or hexadecimal was not found.<br><br>
  
|  Name|  Summary| 
|---|---|
  



