//[okio](../../index.md)/[okio](../index.md)/[Filesystem](index.md)



# Filesystem  
 [common] abstract class [Filesystem](index.md)

Read and write access to a hierarchical collection of files, addressed by [paths](../-path/index.md). This is a natural interface to the [current computer's local filesystem](-companion/-s-y-s-t-e-m.md).





Not Just the Local Filesystem

 -----------------------------



Other implementations are possible:

<ul><li>FakeFilesystem is an in-memory filesystem suitable for testing. Note that this class is     included in the okio-testing artifact.</li><li>A ZIP filesystem could provide access to the contents of a .zip file.</li><li>A remote filesystem could access files over the network.</li><li>A [decorating filesystem](../-forwarding-filesystem/index.md) could apply monitoring, encryption,     compression, or filtering to another filesystem implementation.</li></ul>

For improved capability and testability, consider structuring your classes to dependency inject a Filesystem rather than using [SYSTEM](-companion/-s-y-s-t-e-m.md) directly.





Limited API

 -----------



This interface is limited in which filesystem features it supports. Applications that need rich filesystem features should use another API, possibly alongside this API.



This class cannot create special file types like hard links, symlinks, pipes, or mounts. Reading or writing these files works as if they were regular files.



It cannot read or write file access control features like the UNIX chmod and Windows access control lists. It does honor these controls and will fail with an [IOException](../-i-o-exception/index.md) if privileges are insufficient!



It cannot lock files, or query which files are locked.



It cannot watch the filesystem for changes.





Multiplatform

 -------------



This class supports a matrix of Kotlin platforms (JVM, Kotlin/Native, Kotlin/JS) and operating systems (Linux, macOS, and Windows). It attempts to balance working similarly across platforms with being consistent with the local operating system.



This is a blocking API which limits its applicability on concurrent Node.js services. File operations will block the event loop (and all JavaScript execution!) until they complete.



It supports the path schemes of both Windows (like C:\Users) and UNIX (like /home). Note that path resolution rules differ by platform.





Differences vs. Java IO APIs

 ----------------------------



The java.io.File class is Java's original filesystem API. The delete and renameTo methods return false if the operation failed. The list method returns null if the file isn't a directory or could not be listed. This class always throws IOExceptions when operations don't succeed.



The java.nio.Path and java.nio.Files classes are the entry points of Java's new filesystem API. Each Path instance is scoped to a particular filesystem, though that is often implicit because the Paths.get() function automatically uses the default (ie. system) filesystem. In Okio's API paths are just identifiers; you must use a specific Filesystem object to do I/O with.

   


## Constructors  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Filesystem/Filesystem/#/PointingToDeclaration/"></a>[Filesystem](-filesystem.md)| <a name="okio/Filesystem/Filesystem/#/PointingToDeclaration/"></a> [common] fun [Filesystem](-filesystem.md)()   <br>


## Types  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Filesystem.Companion///PointingToDeclaration/"></a>[Companion](-companion/index.md)| <a name="okio/Filesystem.Companion///PointingToDeclaration/"></a>[common]  <br>Content  <br>object [Companion](-companion/index.md)  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Filesystem/appendingSink/#okio.Path/PointingToDeclaration/"></a>[appendingSink](appending-sink.md)| <a name="okio/Filesystem/appendingSink/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [appendingSink](appending-sink.md)(file: [Path](../-path/index.md)): [Sink](../-sink/index.md)  <br>More info  <br>Returns a sink that appends bytes to the end of file, creating it if it doesn't already exist.  <br><br><br>
| <a name="okio/Filesystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a>[atomicMove](atomic-move.md)| <a name="okio/Filesystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [atomicMove](atomic-move.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md))  <br>More info  <br>Moves source to target in-place if the underlying file system supports it.  <br><br><br>
| <a name="okio/Filesystem/canonicalize/#okio.Path/PointingToDeclaration/"></a>[canonicalize](canonicalize.md)| <a name="okio/Filesystem/canonicalize/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [canonicalize](canonicalize.md)(path: [Path](../-path/index.md)): [Path](../-path/index.md)  <br>More info  <br>Resolves path against the current working directory and symlinks in this filesystem.  <br><br><br>
| <a name="okio/Filesystem/copy/#okio.Path#okio.Path/PointingToDeclaration/"></a>[copy](copy.md)| <a name="okio/Filesystem/copy/#okio.Path#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [copy](copy.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md))  <br>More info  <br>Copies all of the bytes from the file at source to the file at target.  <br><br><br>
| <a name="okio/Filesystem/createDirectories/#okio.Path/PointingToDeclaration/"></a>[createDirectories](create-directories.md)| <a name="okio/Filesystem/createDirectories/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [createDirectories](create-directories.md)(dir: [Path](../-path/index.md))  <br>More info  <br>Creates a directory at the path identified by dir, and any enclosing parent path directories, recursively.  <br><br><br>
| <a name="okio/Filesystem/createDirectory/#okio.Path/PointingToDeclaration/"></a>[createDirectory](create-directory.md)| <a name="okio/Filesystem/createDirectory/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [createDirectory](create-directory.md)(dir: [Path](../-path/index.md))  <br>More info  <br>Creates a directory at the path identified by dir.  <br><br><br>
| <a name="okio/Filesystem/delete/#okio.Path/PointingToDeclaration/"></a>[delete](delete.md)| <a name="okio/Filesystem/delete/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [delete](delete.md)(path: [Path](../-path/index.md))  <br>More info  <br>Deletes the file or directory at path.  <br><br><br>
| <a name="okio/Filesystem/deleteRecursively/#okio.Path/PointingToDeclaration/"></a>[deleteRecursively](delete-recursively.md)| <a name="okio/Filesystem/deleteRecursively/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [deleteRecursively](delete-recursively.md)(fileOrDirectory: [Path](../-path/index.md))  <br>More info  <br>Recursively deletes all children of fileOrDirectory if it is a directory, then deletes fileOrDirectory itself.  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-792583948)| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[common]  <br>Content  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-792583948)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/Filesystem/exists/#okio.Path/PointingToDeclaration/"></a>[exists](exists.md)| <a name="okio/Filesystem/exists/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [exists](exists.md)(path: [Path](../-path/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>Returns true if path identifies an object on this filesystem.  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-792583948)| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-792583948)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/Filesystem/list/#okio.Path/PointingToDeclaration/"></a>[list](list.md)| <a name="okio/Filesystem/list/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [list](list.md)(dir: [Path](../-path/index.md)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<[Path](../-path/index.md)>  <br>More info  <br>Returns the children of the directory identified by dir.  <br><br><br>
| <a name="okio/Filesystem/metadata/#okio.Path/PointingToDeclaration/"></a>[metadata](metadata.md)| <a name="okio/Filesystem/metadata/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [metadata](metadata.md)(path: [Path](../-path/index.md)): [FileMetadata](../-file-metadata/index.md)  <br>More info  <br>Returns metadata of the file, directory, or object identified by path.  <br><br><br>
| <a name="okio/Filesystem/metadataOrNull/#okio.Path/PointingToDeclaration/"></a>[metadataOrNull](metadata-or-null.md)| <a name="okio/Filesystem/metadataOrNull/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [metadataOrNull](metadata-or-null.md)(path: [Path](../-path/index.md)): [FileMetadata](../-file-metadata/index.md)?  <br>More info  <br>Returns metadata of the file, directory, or object identified by path.  <br><br><br>
| <a name="okio/Filesystem/sink/#okio.Path/PointingToDeclaration/"></a>[sink](sink.md)| <a name="okio/Filesystem/sink/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [sink](sink.md)(file: [Path](../-path/index.md)): [Sink](../-sink/index.md)  <br>More info  <br>Returns a sink that writes bytes to file from beginning to end.  <br><br><br>
| <a name="okio/Filesystem/source/#okio.Path/PointingToDeclaration/"></a>[source](source.md)| <a name="okio/Filesystem/source/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [source](source.md)(file: [Path](../-path/index.md)): [Source](../-source/index.md)  <br>More info  <br>Returns a source that reads the bytes of file from beginning to end.  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-792583948)| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-792583948)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>


## Inheritors  
  
|  Name| 
|---|
| <a name="okio/ForwardingFilesystem///PointingToDeclaration/"></a>[ForwardingFilesystem](../-forwarding-filesystem/index.md)

