/*
 * Decompiled with CFR 0.152.
 */
package okio.fakefilesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import okio.Buffer;
import okio.ByteString;
import okio.ExperimentalFileSystem;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Path;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio.fakefilesystem.-Time;
import okio.fakefilesystem.FakeFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0004/012B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\u0006\u0010\u001e\u001a\u00020\u0019J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0005H\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010 \u001a\u00020\u0005H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u00112\u0006\u0010(\u001a\u00020\u0005H\u0002J\u0012\u0010)\u001a\u00020*2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020,2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010-\u001a\u00020.H\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n8G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00138G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lokio/fakefilesystem/FakeFileSystem;", "Lokio/FileSystem;", "windowsLimitations", "", "workingDirectory", "Lokio/Path;", "clock", "Lkotlinx/datetime/Clock;", "(ZLokio/Path;Lkotlinx/datetime/Clock;)V", "allPaths", "", "()Ljava/util/Set;", "elements", "", "Lokio/fakefilesystem/FakeFileSystem$Element;", "openFiles", "", "Lokio/fakefilesystem/FakeFileSystem$OpenFile;", "openPaths", "", "()Ljava/util/List;", "appendingSink", "Lokio/Sink;", "file", "atomicMove", "", "source", "target", "canonicalize", "path", "checkNoOpenFiles", "createDirectory", "dir", "delete", "list", "metadataOrNull", "Lokio/FileMetadata;", "newSink", "append", "openFileOrNull", "canonicalPath", "requireDirectory", "Lokio/fakefilesystem/FakeFileSystem$Element$Directory;", "sink", "Lokio/Source;", "toString", "", "Element", "FakeFileSink", "FakeFileSource", "OpenFile", "okio-fakefilesystem"})
@ExperimentalFileSystem
public final class FakeFileSystem
extends FileSystem {
    private final Map<Path, Element> elements;
    private final List<OpenFile> openFiles;
    private final boolean windowsLimitations;
    private final Path workingDirectory;
    @JvmField
    @NotNull
    public final Clock clock;

    @JvmName(name="allPaths")
    @NotNull
    public final Set<Path> allPaths() {
        boolean bl = false;
        List result = new ArrayList();
        for (Path path : this.elements.keySet()) {
            if (path.isRoot()) continue;
            Collection collection = result;
            boolean bl2 = false;
            collection.add(path);
        }
        CollectionsKt.sort((List)result);
        return CollectionsKt.toSet((Iterable)result);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="openPaths")
    @NotNull
    public final List<Path> openPaths() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.openFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OpenFile openFile = (OpenFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = it.getCanonicalPath();
            collection.add(path);
        }
        return (List)destination$iv$iv;
    }

    public final void checkNoOpenFiles() {
        OpenFile openFile = (OpenFile)CollectionsKt.firstOrNull(this.openFiles);
        if (openFile == null) {
            return;
        }
        OpenFile firstOpenFile = openFile;
        throw (Throwable)new IllegalStateException(StringsKt.trimMargin$default((String)("\n      |expected 0 open files, but found:\n      |    " + CollectionsKt.joinToString$default((Iterable)this.openFiles, (CharSequence)"\n    ", null, null, (int)0, null, (Function1)checkNoOpenFiles.1.INSTANCE, (int)30, null) + "\n      "), null, (int)1, null), firstOpenFile.getBacktrace());
    }

    @NotNull
    public Path canonicalize(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path canonicalPath = this.workingDirectory.resolve(path);
        Map<Path, Element> map = this.elements;
        boolean bl = false;
        Map<Path, Element> map2 = map;
        boolean bl2 = false;
        if (!map2.containsKey(canonicalPath)) {
            throw (Throwable)new FileNotFoundException("no such file: " + path);
        }
        return canonicalPath;
    }

    @Nullable
    public FileMetadata metadataOrNull(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path canonicalPath = this.workingDirectory.resolve(path);
        Element element = this.elements.get(canonicalPath);
        if (element == null && path.isRoot()) {
            element = new Element.Directory(this.clock.now());
            this.elements.put(path, element);
        }
        Element element2 = element;
        return element2 != null ? element2.getMetadata() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Path> list(@NotNull Path dir) {
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Path canonicalPath = this.workingDirectory.resolve(dir);
        Element.Directory element = this.requireDirectory(canonicalPath);
        Element.access$default(element, this.clock.now(), false, 2, null);
        Iterable iterable = this.elements.keySet();
        boolean bl = false;
        Collection destination$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            Path it = (Path)element$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)it.parent(), (Object)canonicalPath)) continue;
            destination$iv.add(element$iv);
        }
        List paths = (List)destination$iv;
        CollectionsKt.sort((List)paths);
        return paths;
    }

    @NotNull
    public Source source(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path canonicalPath = this.workingDirectory.resolve(file);
        Element element = this.elements.get(canonicalPath);
        if (element == null) {
            throw (Throwable)new FileNotFoundException("no such file: " + file);
        }
        Element element2 = element;
        if (!(element2 instanceof Element.File)) {
            throw (Throwable)new IOException("not a file: " + file);
        }
        OpenFile openFile = new OpenFile(canonicalPath, new Exception("file opened for reading here"));
        Collection collection = this.openFiles;
        boolean bl = false;
        collection.add(openFile);
        Element.access$default(element2, this.clock.now(), false, 2, null);
        return new FakeFileSource(openFile, new Buffer().write(((Element.File)element2).getData()));
    }

    @NotNull
    public Sink sink(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.newSink(file, false);
    }

    @NotNull
    public Sink appendingSink(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.newSink(file, true);
    }

    private final Sink newSink(Path file, boolean append) {
        Path canonicalPath = this.workingDirectory.resolve(file);
        Instant now = this.clock.now();
        Element existing = this.elements.get(canonicalPath);
        if (existing instanceof Element.Directory) {
            throw (Throwable)new IOException("destination is a directory: " + file);
        }
        Element.Directory parent = this.requireDirectory(canonicalPath.parent());
        parent.access(now, true);
        OpenFile openFile = new OpenFile(canonicalPath, new Exception("file opened for writing here"));
        Collection collection = this.openFiles;
        boolean bl = false;
        collection.add(openFile);
        Element element = existing;
        if (element == null || (element = element.getCreatedAt()) == null) {
            element = now;
        }
        Element.File regularFile = new Element.File((Instant)element);
        FakeFileSink result = new FakeFileSink(openFile, regularFile);
        if (append && existing instanceof Element.File) {
            result.getBuffer().write(((Element.File)existing).getData());
            regularFile.setData(((Element.File)existing).getData());
        }
        this.elements.put(canonicalPath, regularFile);
        regularFile.access(now, true);
        return result;
    }

    public void createDirectory(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Path canonicalPath = this.workingDirectory.resolve(dir);
        if (this.elements.get(canonicalPath) != null) {
            throw (Throwable)new IOException("already exists: " + dir);
        }
        this.requireDirectory(canonicalPath.parent());
        this.elements.put(canonicalPath, new Element.Directory(this.clock.now()));
    }

    public void atomicMove(@NotNull Path source, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Path canonicalSource = this.workingDirectory.resolve(source);
        Path canonicalTarget = this.workingDirectory.resolve(target);
        Element targetElement = this.elements.get(canonicalTarget);
        Element sourceElement = this.elements.get(canonicalSource);
        if (targetElement instanceof Element.Directory) {
            throw (Throwable)new IOException("target is a directory: " + target);
        }
        this.requireDirectory(canonicalTarget.parent());
        if (this.windowsLimitations) {
            OpenFile openFile = this.openFileOrNull(canonicalSource);
            if (openFile != null) {
                OpenFile openFile2 = openFile;
                boolean bl = false;
                boolean bl2 = false;
                OpenFile it = openFile2;
                boolean bl3 = false;
                throw (Throwable)new IOException("source is open " + source, it.getBacktrace());
            }
            OpenFile openFile3 = this.openFileOrNull(canonicalTarget);
            if (openFile3 != null) {
                OpenFile openFile4 = openFile3;
                boolean bl = false;
                boolean bl4 = false;
                OpenFile it = openFile4;
                boolean bl5 = false;
                throw (Throwable)new IOException("target is open " + target, it.getBacktrace());
            }
        } else if (sourceElement instanceof Element.Directory && targetElement instanceof Element.File) {
            throw (Throwable)new IOException("source is a directory and target is a file");
        }
        Element element = this.elements.remove(canonicalSource);
        if (element == null) {
            throw (Throwable)new FileNotFoundException("source doesn't exist: " + source);
        }
        Element removed = element;
        this.elements.put(canonicalTarget, removed);
    }

    public void delete(@NotNull Path path) {
        boolean bl;
        Path canonicalPath;
        block7: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            canonicalPath = this.workingDirectory.resolve(path);
            Iterable $this$any$iv = this.elements.keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Path it = (Path)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.parent(), (Object)canonicalPath)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            throw (Throwable)new IOException("non-empty directory");
        }
        if (this.windowsLimitations) {
            OpenFile openFile = this.openFileOrNull(canonicalPath);
            if (openFile != null) {
                OpenFile openFile2 = openFile;
                boolean bl3 = false;
                boolean bl4 = false;
                OpenFile it = openFile2;
                boolean bl5 = false;
                throw (Throwable)new IOException("file is open " + path, it.getBacktrace());
            }
        }
        if (this.elements.remove(canonicalPath) == null) {
            throw (Throwable)new FileNotFoundException("no such file: " + path);
        }
    }

    private final Element.Directory requireDirectory(Path path) {
        if (path == null) {
            throw (Throwable)new IOException("directory does not exist");
        }
        Element element = this.elements.get(path);
        if (element instanceof Element.Directory) {
            return (Element.Directory)element;
        }
        if (path.isRoot()) {
            Element.Directory root = new Element.Directory(this.clock.now());
            this.elements.put(path, root);
            return root;
        }
        if (element == null) {
            throw (Throwable)new FileNotFoundException("no such directory: " + path);
        }
        throw (Throwable)new IOException("not a directory: " + path);
    }

    private final OpenFile openFileOrNull(Path canonicalPath) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.openFiles;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                OpenFile it = (OpenFile)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCanonicalPath(), (Object)canonicalPath)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public String toString() {
        return "FakeFileSystem";
    }

    public FakeFileSystem(boolean windowsLimitations, @NotNull Path workingDirectory, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.windowsLimitations = windowsLimitations;
        this.workingDirectory = workingDirectory;
        this.clock = clock;
        boolean bl = this.workingDirectory.isAbsolute();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "expected an absolute path but was " + this.workingDirectory;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = false;
        this.elements = new LinkedHashMap();
        bl = false;
        this.openFiles = new ArrayList();
    }

    public /* synthetic */ FakeFileSystem(boolean bl, Path path, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            Path path2 = path = bl ? Path.Companion.get("F:\\") : Path.Companion.get("/");
        }
        if ((n & 4) != 0) {
            clock = (Clock)Clock.System.INSTANCE;
        }
        this(bl, path, clock);
    }

    public FakeFileSystem() {
        this(false, null, null, 7, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0004\b\t\u0010\u0004R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0006\"\u0004\b\f\u0010\u0004R\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0002\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lokio/fakefilesystem/FakeFileSystem$Element;", "", "createdAt", "Lkotlinx/datetime/Instant;", "(Lkotlinx/datetime/Instant;)V", "getCreatedAt", "()Lkotlinx/datetime/Instant;", "lastAccessedAt", "getLastAccessedAt", "setLastAccessedAt", "lastModifiedAt", "getLastModifiedAt", "setLastModifiedAt", "metadata", "Lokio/FileMetadata;", "getMetadata", "()Lokio/FileMetadata;", "access", "", "now", "modified", "", "Directory", "File", "Lokio/fakefilesystem/FakeFileSystem$Element$File;", "Lokio/fakefilesystem/FakeFileSystem$Element$Directory;", "okio-fakefilesystem"})
    private static abstract class Element {
        @NotNull
        private Instant lastModifiedAt;
        @NotNull
        private Instant lastAccessedAt;
        @NotNull
        private final Instant createdAt;

        @NotNull
        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.lastModifiedAt = instant;
        }

        @NotNull
        public final Instant getLastAccessedAt() {
            return this.lastAccessedAt;
        }

        public final void setLastAccessedAt(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.lastAccessedAt = instant;
        }

        public final void access(@NotNull Instant now, boolean modified) {
            Intrinsics.checkNotNullParameter((Object)now, (String)"now");
            this.lastAccessedAt = now;
            if (modified) {
                this.lastModifiedAt = now;
            }
        }

        public static /* synthetic */ void access$default(Element element, Instant instant, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: access");
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            element.access(instant, bl);
        }

        @NotNull
        public abstract FileMetadata getMetadata();

        @NotNull
        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        private Element(Instant createdAt) {
            this.lastModifiedAt = this.createdAt = createdAt;
            this.lastAccessedAt = this.createdAt;
        }

        public /* synthetic */ Element(Instant createdAt, DefaultConstructorMarker $constructor_marker) {
            this(createdAt);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lokio/fakefilesystem/FakeFileSystem$Element$File;", "Lokio/fakefilesystem/FakeFileSystem$Element;", "createdAt", "Lkotlinx/datetime/Instant;", "(Lkotlinx/datetime/Instant;)V", "data", "Lokio/ByteString;", "getData", "()Lokio/ByteString;", "setData", "(Lokio/ByteString;)V", "metadata", "Lokio/FileMetadata;", "getMetadata", "()Lokio/FileMetadata;", "okio-fakefilesystem"})
        public static final class File
        extends Element {
            @NotNull
            private ByteString data;

            @NotNull
            public final ByteString getData() {
                return this.data;
            }

            public final void setData(@NotNull ByteString byteString) {
                Intrinsics.checkNotNullParameter((Object)byteString, (String)"<set-?>");
                this.data = byteString;
            }

            @Override
            @NotNull
            public FileMetadata getMetadata() {
                return -Time.newFileMetadata$default(true, false, Long.valueOf(this.data.size()), this.getCreatedAt(), this.getLastModifiedAt(), this.getLastAccessedAt(), 2, null);
            }

            public File(@NotNull Instant createdAt) {
                Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
                super(createdAt, null);
                this.data = ByteString.EMPTY;
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lokio/fakefilesystem/FakeFileSystem$Element$Directory;", "Lokio/fakefilesystem/FakeFileSystem$Element;", "createdAt", "Lkotlinx/datetime/Instant;", "(Lkotlinx/datetime/Instant;)V", "metadata", "Lokio/FileMetadata;", "getMetadata", "()Lokio/FileMetadata;", "okio-fakefilesystem"})
        public static final class Directory
        extends Element {
            @Override
            @NotNull
            public FileMetadata getMetadata() {
                return -Time.newFileMetadata$default(false, true, null, this.getCreatedAt(), this.getLastModifiedAt(), this.getLastAccessedAt(), 5, null);
            }

            public Directory(@NotNull Instant createdAt) {
                Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
                super(createdAt, null);
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lokio/fakefilesystem/FakeFileSystem$OpenFile;", "", "canonicalPath", "Lokio/Path;", "backtrace", "", "(Lokio/Path;Ljava/lang/Throwable;)V", "getBacktrace", "()Ljava/lang/Throwable;", "getCanonicalPath", "()Lokio/Path;", "okio-fakefilesystem"})
    private static final class OpenFile {
        @NotNull
        private final Path canonicalPath;
        @NotNull
        private final Throwable backtrace;

        @NotNull
        public final Path getCanonicalPath() {
            return this.canonicalPath;
        }

        @NotNull
        public final Throwable getBacktrace() {
            return this.backtrace;
        }

        public OpenFile(@NotNull Path canonicalPath, @NotNull Throwable backtrace) {
            Intrinsics.checkNotNullParameter((Object)canonicalPath, (String)"canonicalPath");
            Intrinsics.checkNotNullParameter((Object)backtrace, (String)"backtrace");
            this.canonicalPath = canonicalPath;
            this.backtrace = backtrace;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lokio/fakefilesystem/FakeFileSystem$FakeFileSource;", "Lokio/Source;", "openFile", "Lokio/fakefilesystem/FakeFileSystem$OpenFile;", "buffer", "Lokio/Buffer;", "(Lokio/fakefilesystem/FakeFileSystem;Lokio/fakefilesystem/FakeFileSystem$OpenFile;Lokio/Buffer;)V", "closed", "", "close", "", "read", "", "sink", "byteCount", "timeout", "Lokio/Timeout;", "toString", "", "okio-fakefilesystem"})
    private final class FakeFileSource
    implements Source {
        private boolean closed;
        private final OpenFile openFile;
        private final Buffer buffer;

        public long read(@NotNull Buffer sink, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            boolean bl = !this.closed;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return this.buffer.read(sink, byteCount);
        }

        @NotNull
        public Timeout timeout() {
            return Timeout.NONE;
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Collection collection = FakeFileSystem.this.openFiles;
            OpenFile openFile = this.openFile;
            boolean bl = false;
            collection.remove(openFile);
        }

        @NotNull
        public String toString() {
            return "source(" + this.openFile.getCanonicalPath() + ')';
        }

        public FakeFileSource(@NotNull OpenFile openFile, Buffer buffer) {
            Intrinsics.checkNotNullParameter((Object)openFile, (String)"openFile");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.openFile = openFile;
            this.buffer = buffer;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lokio/fakefilesystem/FakeFileSystem$FakeFileSink;", "Lokio/Sink;", "openFile", "Lokio/fakefilesystem/FakeFileSystem$OpenFile;", "file", "Lokio/fakefilesystem/FakeFileSystem$Element$File;", "(Lokio/fakefilesystem/FakeFileSystem;Lokio/fakefilesystem/FakeFileSystem$OpenFile;Lokio/fakefilesystem/FakeFileSystem$Element$File;)V", "buffer", "Lokio/Buffer;", "getBuffer", "()Lokio/Buffer;", "closed", "", "close", "", "flush", "timeout", "Lokio/Timeout;", "toString", "", "write", "source", "byteCount", "", "okio-fakefilesystem"})
    private final class FakeFileSink
    implements Sink {
        @NotNull
        private final Buffer buffer;
        private boolean closed;
        private final OpenFile openFile;
        private final Element.File file;

        @NotNull
        public final Buffer getBuffer() {
            return this.buffer;
        }

        public void write(@NotNull Buffer source, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            boolean bl = !this.closed;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.buffer.write(source, byteCount);
        }

        public void flush() {
            boolean bl = !this.closed;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.file.setData(this.buffer.snapshot());
            this.file.access(FakeFileSystem.this.clock.now(), true);
        }

        @NotNull
        public Timeout timeout() {
            return Timeout.NONE;
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.file.setData(this.buffer.snapshot());
            this.file.access(FakeFileSystem.this.clock.now(), true);
            Collection collection = FakeFileSystem.this.openFiles;
            OpenFile openFile = this.openFile;
            boolean bl = false;
            collection.remove(openFile);
        }

        @NotNull
        public String toString() {
            return "sink(" + this.openFile.getCanonicalPath() + ')';
        }

        public FakeFileSink(@NotNull OpenFile openFile, Element.File file) {
            Intrinsics.checkNotNullParameter((Object)openFile, (String)"openFile");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.openFile = openFile;
            this.file = file;
            this.buffer = new Buffer();
        }
    }
}

