//[okio](../../index.md)/[okio](../index.md)/[Pipe](index.md)



# Pipe  
 [jvm] class [Pipe](index.md)(**maxBufferSize**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))

A source and a sink that are attached. The sink's output is the source's input. Typically each is accessed by its own thread: a producer thread writes data to the sink and a consumer thread reads data from the source.



This class uses a buffer to decouple source and sink. This buffer has a user-specified maximum size. When a producer thread outruns its consumer the buffer fills up and eventually writes to the sink will block until the consumer has caught up. Symmetrically, if a consumer outruns its producer reads block until there is data to be read. Limits on the amount of time spent waiting for the other party can be configured with [timeouts](../-timeout/index.md) on the source and the sink.



When the sink is closed, source reads will continue to complete normally until the buffer has been exhausted. At that point reads will return -1, indicating the end of the stream. But if the source is closed first, writes to the sink will immediately fail with an [IOException](../-i-o-exception/index.md).



A pipe may be canceled to immediately fail writes to the sink and reads from the source.

   


## Constructors  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Pipe/Pipe/#kotlin.Long/PointingToDeclaration/"></a>[Pipe](-pipe.md)| <a name="okio/Pipe/Pipe/#kotlin.Long/PointingToDeclaration/"></a> [jvm] fun [Pipe](-pipe.md)(maxBufferSize: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))   <br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Pipe/cancel/#/PointingToDeclaration/"></a>[cancel](cancel.md)| <a name="okio/Pipe/cancel/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [cancel](cancel.md)()  <br>More info  <br>Fail any in-flight and future operations.  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/Pipe/fold/#okio.Sink/PointingToDeclaration/"></a>[fold](fold.md)| <a name="okio/Pipe/fold/#okio.Sink/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [fold](fold.md)(sink: [Sink](../-sink/index.md))  <br>More info  <br>Writes any buffered contents of this pipe to sink, then replace this pipe's source with sink.  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Pipe/sink/#/PointingToDeclaration/"></a>[sink](sink.md)| <a name="okio/Pipe/sink/#/PointingToDeclaration/"></a> [jvm] val [sink](sink.md): [Sink](../-sink/index.md)   <br>
| <a name="okio/Pipe/source/#/PointingToDeclaration/"></a>[source](source.md)| <a name="okio/Pipe/source/#/PointingToDeclaration/"></a> [jvm] val [source](source.md): [Source](../-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F-43762623)   <br>

