//[okio](../../index.md)/[okio](../index.md)/[Source](index.md)



# Source  
 [common] interface [Source](index.md) : [Closeable](../-closeable/index.md)

Supplies a stream of bytes. Use this interface to read data from wherever it's located: from the network, storage, or a buffer in memory. Sources may be layered to transform supplied data, such as to decompress, decrypt, or remove protocol framing.



Most applications shouldn't operate on a source directly, but rather on a [BufferedSource](../-buffered-source/index.md) which is both more efficient and more convenient. Use [buffer](../buffer.md) to wrap any source with a buffer.



Sources are easy to test: just use a [Buffer](../-buffer/index.md) in your tests, and fill it with the data your application is to read.



###  Comparison with InputStream  


This interface is functionally equivalent to java.io.InputStream.



InputStream requires multiple layers when consumed data is heterogeneous: a DataInputStream for primitive values, a BufferedInputStream for buffering, and InputStreamReader for strings. This library uses BufferedSource for all of the above.



Source avoids the impossible-to-implement java.io.InputStream.available method. Instead callers specify how many bytes they [require](../-buffered-source/require.md).



Source omits the unsafe-to-compose java.io.InputStream.mark state that's tracked by InputStream; instead, callers just buffer what they need.



When implementing a source, you don't need to worry about the java.io.InputStream.read method that is awkward to implement efficiently and returns one of 257 possible values.



And source has a stronger skip method: [BufferedSource.skip](../-buffered-source/skip.md) won't return prematurely.



###  Interop with InputStream  


Use source to adapt an InputStream to a source. Use BufferedSource.inputStream to adapt a source to an InputStream.

   


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Source/close/#/PointingToDeclaration/"></a>[close](close.md)| <a name="okio/Source/close/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract override fun [close](close.md)()  <br>More info  <br>Closes this source and releases the resources held by this source.  <br><br><br>
| <a name="okio/Source/cursor/#/PointingToDeclaration/"></a>[cursor](cursor.md)| <a name="okio/Source/cursor/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [cursor](cursor.md)(): [Cursor](../-cursor/index.md)?  <br>More info  <br>Returns a cursor to access the position and size of this source if it supports random access.  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F393492223)| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[common]  <br>Content  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F393492223)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F393492223)| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F393492223)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/Source/read/#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>[read](read.md)| <a name="okio/Source/read/#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [read](read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Removes at least 1, and up to byteCount bytes from this and appends them to sink.  <br><br><br>
| <a name="okio/Source/timeout/#/PointingToDeclaration/"></a>[timeout](timeout.md)| <a name="okio/Source/timeout/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)  <br>More info  <br>Returns the timeout for this source.  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F393492223)| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F393492223)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>


## Inheritors  
  
|  Name| 
|---|
| <a name="okio/BufferedSource///PointingToDeclaration/"></a>[BufferedSource](../-buffered-source/index.md)
| <a name="okio/HashingSource///PointingToDeclaration/"></a>[HashingSource](../-hashing-source/index.md)
| <a name="okio/CipherSource///PointingToDeclaration/"></a>[CipherSource](../-cipher-source/index.md)
| <a name="okio/ForwardingSource///PointingToDeclaration/"></a>[ForwardingSource](../-forwarding-source/index.md)
| <a name="okio/GzipSource///PointingToDeclaration/"></a>[GzipSource](../-gzip-source/index.md)
| <a name="okio/InflaterSource///PointingToDeclaration/"></a>[InflaterSource](../-inflater-source/index.md)


## Extensions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio//buffer/okio.Source#/PointingToDeclaration/"></a>[buffer](../buffer.md)| <a name="okio//buffer/okio.Source#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [Source](index.md).[buffer](../buffer.md)(): [BufferedSource](../-buffered-source/index.md)  <br>More info  <br>Returns a new source that buffers reads from source.  <br><br><br>
| <a name="okio//cipherSource/okio.Source#javax.crypto.Cipher/PointingToDeclaration/"></a>[cipherSource](../cipher-source.md)| <a name="okio//cipherSource/okio.Source#javax.crypto.Cipher/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [Source](index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F991926376).[cipherSource](../cipher-source.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSource](../-cipher-source/index.md)  <br>More info  <br>Returns a source that uses cipher to encrypt or decrypt this.  <br><br><br>
| <a name="okio//gzip/okio.Source#/PointingToDeclaration/"></a>[gzip](../gzip.md)| <a name="okio//gzip/okio.Source#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>inline fun [Source](index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F991926376).[gzip](../gzip.md)(): [GzipSource](../-gzip-source/index.md)  <br>More info  <br>Returns a [GzipSource](../-gzip-source/index.md) that gzip-decompresses this [Source](index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F991926376) while reading.  <br><br><br>
| <a name="okio//hashingSource/okio.Source#javax.crypto.Mac/PointingToDeclaration/"></a>[hashingSource](../hashing-source.md)| <a name="okio//hashingSource/okio.Source#javax.crypto.Mac/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [Source](index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F991926376).[hashingSource](../hashing-source.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSource](../-hashing-source/index.md)  <br>More info  <br>Returns a source that uses mac to hash this.  <br><br><br>[jvm]  <br>Content  <br>fun [Source](index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F991926376).[hashingSource](../hashing-source.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSource](../-hashing-source/index.md)  <br>More info  <br>Returns a source that uses digest to hash this.  <br><br><br>
| <a name="okio//inflate/okio.Source#java.util.zip.Inflater/PointingToDeclaration/"></a>[inflate](../inflate.md)| <a name="okio//inflate/okio.Source#java.util.zip.Inflater/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>inline fun [Source](index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F991926376).[inflate](../inflate.md)(inflater: [Inflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html) = Inflater()): [InflaterSource](../-inflater-source/index.md)  <br>More info  <br>Returns an [InflaterSource](../-inflater-source/index.md) that DEFLATE-decompresses this [Source](index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F991926376) while reading.  <br><br><br>

