//[okio](../../index.md)/[okio](../index.md)/[Buffer](index.md)/[emit](emit.md)



# emit  
[common]  
Content  
open override fun [emit](emit.md)(): [Buffer](index.md)  
More info  


Writes all buffered data to the underlying sink, if one exists. Like [flush](index.md#%5Bokio%2FBuffer%2Fflush%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1050665461), but weaker. Call this before this buffered sink goes out of scope so that its data can reach its destination.

BufferedSink b0 = new Buffer();  
BufferedSink b1 = Okio.buffer(b0);  
BufferedSink b2 = Okio.buffer(b1);  
  
b2.writeUtf8("hello");  
assertEquals(5, b2.buffer().size());  
assertEquals(0, b1.buffer().size());  
assertEquals(0, b0.buffer().size());  
  
b2.emit();  
assertEquals(0, b2.buffer().size());  
assertEquals(5, b1.buffer().size());  
assertEquals(0, b0.buffer().size());  
  
b1.emit();  
assertEquals(0, b2.buffer().size());  
assertEquals(0, b1.buffer().size());  
assertEquals(5, b0.buffer().size());  


[jvm]  
Content  
open override fun [emit](emit.md)(): [Buffer](index.md)  
More info  
  



