//[okio](../../index.md)/[okio](../index.md)/[Timeout](index.md)



# Timeout  
 [common] open class [Timeout](index.md)

A policy on how much time to spend on a task before giving up. When a task times out, it is left in an unspecified state and should be abandoned. For example, if reading from a source times out, that source should be closed and the read should be retried later. If writing to a sink times out, the same rules apply: close the sink and retry later.



###  Timeouts and Deadlines  


This class offers two complementary controls to define a timeout policy.



**Timeouts** specify the maximum time to wait for a single operation to complete. Timeouts are typically used to detect problems like network partitions. For example, if a remote peer doesn't return *any* data for ten seconds, we may assume that the peer is unavailable.



**Deadlines** specify the maximum time to spend on a job, composed of one or more operations. Use deadlines to set an upper bound on the time invested on a job. For example, a battery-conscious app may limit how much time it spends pre-loading content.

   
 [jvm] open class [Timeout](index.md)   


## Types  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Timeout.Companion///PointingToDeclaration/"></a>[Companion](-companion/index.md)| <a name="okio/Timeout.Companion///PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common, jvm]  <br>object [Companion](-companion/index.md)  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Timeout/clearDeadline/#/PointingToDeclaration/"></a>[clearDeadline](clear-deadline.md)| <a name="okio/Timeout/clearDeadline/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [clearDeadline](clear-deadline.md)(): [Timeout](index.md)  <br>More info  <br>Clears the deadline.  <br><br><br>
| <a name="okio/Timeout/clearTimeout/#/PointingToDeclaration/"></a>[clearTimeout](clear-timeout.md)| <a name="okio/Timeout/clearTimeout/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [clearTimeout](clear-timeout.md)(): [Timeout](index.md)  <br>More info  <br>Clears the timeout.  <br><br><br>
| <a name="okio/Timeout/deadline/#kotlin.Long#java.util.concurrent.TimeUnit/PointingToDeclaration/"></a>[deadline](deadline.md)| <a name="okio/Timeout/deadline/#kotlin.Long#java.util.concurrent.TimeUnit/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [deadline](deadline.md)(duration: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](index.md)  <br>More info  <br>Set a deadline of now plus duration time.  <br><br><br>
| <a name="okio/Timeout/deadlineNanoTime/#/PointingToDeclaration/"></a>[deadlineNanoTime](deadline-nano-time.md)| <a name="okio/Timeout/deadlineNanoTime/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [deadlineNanoTime](deadline-nano-time.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached.  <br><br><br>[jvm]  <br>Content  <br>open fun [deadlineNanoTime](deadline-nano-time.md)(deadlineNanoTime: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Timeout](index.md)  <br>More info  <br>Sets the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached.  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>equals| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open operator fun [equals](-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1050665461)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>[jvm]  <br>open operator fun [equals](-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-393734708)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/Timeout/hasDeadline/#/PointingToDeclaration/"></a>[hasDeadline](has-deadline.md)| <a name="okio/Timeout/hasDeadline/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [hasDeadline](has-deadline.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>Returns true if a deadline is enabled.  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>hashCode| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open fun [hashCode](-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1050665461)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>[jvm]  <br>open fun [hashCode](-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-393734708)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/Timeout/intersectWith/#okio.Timeout#kotlin.Function0[kotlin.Unit]/PointingToDeclaration/"></a>[intersectWith](intersect-with.md)| <a name="okio/Timeout/intersectWith/#okio.Timeout#kotlin.Function0[kotlin.Unit]/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>inline fun [intersectWith](intersect-with.md)(other: [Timeout](index.md), block: () -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>More info  <br>Applies the minimum intersection between this timeout and other, run block, then finally rollback this timeout's values.  <br><br><br>
| <a name="okio/Timeout/throwIfReached/#/PointingToDeclaration/"></a>[throwIfReached](throw-if-reached.md)| <a name="okio/Timeout/throwIfReached/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [throwIfReached](throw-if-reached.md)()  <br>More info  <br>Throws an [InterruptedIOException](https://docs.oracle.com/javase/8/docs/api/java/io/InterruptedIOException.html) if the deadline has been reached or if the current thread has been interrupted.  <br><br><br>
| <a name="okio/Timeout/timeout/#kotlin.Long#java.util.concurrent.TimeUnit/PointingToDeclaration/"></a>[timeout](timeout.md)| <a name="okio/Timeout/timeout/#kotlin.Long#java.util.concurrent.TimeUnit/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [timeout](timeout.md)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](index.md)  <br>More info  <br>Wait at most timeout time before aborting an operation.  <br><br><br>
| <a name="okio/Timeout/timeoutNanos/#/PointingToDeclaration/"></a>[timeoutNanos](timeout-nanos.md)| <a name="okio/Timeout/timeoutNanos/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [timeoutNanos](timeout-nanos.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the timeout in nanoseconds, or 0 for no timeout.  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>toString| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open fun [toString](-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1050665461)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>[jvm]  <br>open fun [toString](-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-393734708)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| <a name="okio/Timeout/waitUntilNotified/#kotlin.Any/PointingToDeclaration/"></a>[waitUntilNotified](wait-until-notified.md)| <a name="okio/Timeout/waitUntilNotified/#kotlin.Any/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [waitUntilNotified](wait-until-notified.md)(monitor: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br>More info  <br>Waits on monitor until it is notified.  <br><br><br>


## Inheritors  
  
|  Name| 
|---|
| <a name="okio/AsyncTimeout///PointingToDeclaration/"></a>[AsyncTimeout](../-async-timeout/index.md)
| <a name="okio/ForwardingTimeout///PointingToDeclaration/"></a>[ForwardingTimeout](../-forwarding-timeout/index.md)

