//[okio](../../index.md)/[okio](../index.md)/[AsyncTimeout](index.md)



# AsyncTimeout  
 [jvm] open class [AsyncTimeout](index.md) : [Timeout](../-timeout/index.md)

This timeout uses a background thread to take action exactly when the timeout occurs. Use this to implement timeouts where they aren't supported natively, such as to sockets that are blocked on writing.



Subclasses should override timedOut to take action when a timeout occurs. This method will be invoked by the shared watchdog thread so it should not do any long-running operations. Otherwise we risk starving other timeouts from being triggered.



Use [sink](sink.md) and [source](source.md) to apply this timeout to a stream. The returned value will apply the timeout to each operation on the wrapped stream.



Callers should call [enter](enter.md) before doing work that is subject to timeouts, and [exit](exit.md) afterwards. The return value of [exit](exit.md) indicates whether a timeout was triggered. Note that the call to timedOut is asynchronous, and may be called after [exit](exit.md).

   


## Constructors  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/AsyncTimeout/AsyncTimeout/#/PointingToDeclaration/"></a>[AsyncTimeout](-async-timeout.md)| <a name="okio/AsyncTimeout/AsyncTimeout/#/PointingToDeclaration/"></a> [jvm] fun [AsyncTimeout](-async-timeout.md)()   <br>


## Types  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/AsyncTimeout.Companion///PointingToDeclaration/"></a>[Companion](-companion/index.md)| <a name="okio/AsyncTimeout.Companion///PointingToDeclaration/"></a>[jvm]  <br>Content  <br>object [Companion](-companion/index.md)  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Timeout/clearDeadline/#/PointingToDeclaration/"></a>[clearDeadline](../-timeout/clear-deadline.md)| <a name="okio/Timeout/clearDeadline/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [clearDeadline](../-timeout/clear-deadline.md)(): [Timeout](../-timeout/index.md)  <br>More info  <br>Clears the deadline.  <br><br><br>
| <a name="okio/Timeout/clearTimeout/#/PointingToDeclaration/"></a>[clearTimeout](../-timeout/clear-timeout.md)| <a name="okio/Timeout/clearTimeout/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [clearTimeout](../-timeout/clear-timeout.md)(): [Timeout](../-timeout/index.md)  <br>More info  <br>Clears the timeout.  <br><br><br>
| <a name="okio/Timeout/deadline/#kotlin.Long#java.util.concurrent.TimeUnit/PointingToDeclaration/"></a>[deadline](../-timeout/deadline.md)| <a name="okio/Timeout/deadline/#kotlin.Long#java.util.concurrent.TimeUnit/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [deadline](../-timeout/deadline.md)(duration: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](../-timeout/index.md)  <br>More info  <br>Set a deadline of now plus duration time.  <br><br><br>
| <a name="okio/Timeout/deadlineNanoTime/#/PointingToDeclaration/"></a>[deadlineNanoTime](../-timeout/deadline-nano-time.md)| <a name="okio/Timeout/deadlineNanoTime/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [deadlineNanoTime](../-timeout/deadline-nano-time.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached.  <br><br><br>[jvm]  <br>Content  <br>open fun [deadlineNanoTime](../-timeout/deadline-nano-time.md)(deadlineNanoTime: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Timeout](../-timeout/index.md)  <br>More info  <br>Sets the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached.  <br><br><br>
| <a name="okio/AsyncTimeout/enter/#/PointingToDeclaration/"></a>[enter](enter.md)| <a name="okio/AsyncTimeout/enter/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [enter](enter.md)()  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-44270807)| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-44270807)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/AsyncTimeout/exit/#/PointingToDeclaration/"></a>[exit](exit.md)| <a name="okio/AsyncTimeout/exit/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [exit](exit.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>Returns true if the timeout occurred.  <br><br><br>
| <a name="okio/Timeout/hasDeadline/#/PointingToDeclaration/"></a>[hasDeadline](../-timeout/has-deadline.md)| <a name="okio/Timeout/hasDeadline/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [hasDeadline](../-timeout/has-deadline.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>Returns true if a deadline is enabled.  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-44270807)| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-44270807)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/Timeout/intersectWith/#okio.Timeout#kotlin.Function0[kotlin.Unit]/PointingToDeclaration/"></a>[intersectWith](../-timeout/intersect-with.md)| <a name="okio/Timeout/intersectWith/#okio.Timeout#kotlin.Function0[kotlin.Unit]/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>inline fun [intersectWith](../-timeout/intersect-with.md)(other: [Timeout](../-timeout/index.md), block: () -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>More info  <br>Applies the minimum intersection between this timeout and other, run block, then finally rollback this timeout's values.  <br><br><br>
| <a name="okio/AsyncTimeout/sink/#okio.Sink/PointingToDeclaration/"></a>[sink](sink.md)| <a name="okio/AsyncTimeout/sink/#okio.Sink/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [sink](sink.md)(sink: [Sink](../-sink/index.md)): [Sink](../-sink/index.md)  <br>More info  <br>Returns a new sink that delegates to sink, using this to implement timeouts.  <br><br><br>
| <a name="okio/AsyncTimeout/source/#okio.Source/PointingToDeclaration/"></a>[source](source.md)| <a name="okio/AsyncTimeout/source/#okio.Source/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [source](source.md)(source: [Source](../-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F-44270807)): [Source](../-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F-44270807)  <br>More info  <br>Returns a new source that delegates to source, using this to implement timeouts.  <br><br><br>
| <a name="okio/Timeout/throwIfReached/#/PointingToDeclaration/"></a>[throwIfReached](../-timeout/throw-if-reached.md)| <a name="okio/Timeout/throwIfReached/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [throwIfReached](../-timeout/throw-if-reached.md)()  <br>More info  <br>Throws an [InterruptedIOException](https://docs.oracle.com/javase/8/docs/api/java/io/InterruptedIOException.html) if the deadline has been reached or if the current thread has been interrupted.  <br><br><br>
| <a name="okio/Timeout/timeout/#kotlin.Long#java.util.concurrent.TimeUnit/PointingToDeclaration/"></a>[timeout](../-timeout/timeout.md)| <a name="okio/Timeout/timeout/#kotlin.Long#java.util.concurrent.TimeUnit/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [timeout](../-timeout/timeout.md)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](../-timeout/index.md)  <br>More info  <br>Wait at most timeout time before aborting an operation.  <br><br><br>
| <a name="okio/Timeout/timeoutNanos/#/PointingToDeclaration/"></a>[timeoutNanos](../-timeout/timeout-nanos.md)| <a name="okio/Timeout/timeoutNanos/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [timeoutNanos](../-timeout/timeout-nanos.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the timeout in nanoseconds, or 0 for no timeout.  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-44270807)| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-44270807)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| <a name="okio/Timeout/waitUntilNotified/#kotlin.Any/PointingToDeclaration/"></a>[waitUntilNotified](../-timeout/wait-until-notified.md)| <a name="okio/Timeout/waitUntilNotified/#kotlin.Any/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [waitUntilNotified](../-timeout/wait-until-notified.md)(monitor: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br>More info  <br>Waits on monitor until it is notified.  <br><br><br>
| <a name="okio/AsyncTimeout/withTimeout/#kotlin.Function0[TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[withTimeout](with-timeout.md)| <a name="okio/AsyncTimeout/withTimeout/#kotlin.Function0[TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>inline fun <[T](with-timeout.md)> [withTimeout](with-timeout.md)(block: () -> [T](with-timeout.md)): [T](with-timeout.md)  <br>More info  <br>Surrounds block with calls to [enter](enter.md) and [exit](exit.md), throwing an exception from newTimeoutException if a timeout occurred.  <br><br><br>

