//[okio](../../index.md)/[okio](../index.md)/[BufferedSink](index.md)



# BufferedSink  
 [common] interface [BufferedSink](index.md) : [Sink](../-sink/index.md)

A sink that keeps a buffer internally so that callers can do small writes without a performance penalty.

   
 [jvm] interface [BufferedSink](index.md) : [Sink](../-sink/index.md), [WritableByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/WritableByteChannel.html)   


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Sink/close/#/PointingToDeclaration/"></a>[close](../-sink/close.md)| <a name="okio/Sink/close/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract override fun [close](../-sink/close.md)()  <br>More info  <br>Pushes all buffered bytes to their final destination and releases the resources held by this sink.  <br><br><br>[jvm]  <br>Content  <br>abstract override fun [close](../-sink/close.md)()  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSink/emit/#/PointingToDeclaration/"></a>[emit](emit.md)| <a name="okio/BufferedSink/emit/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [emit](emit.md)(): [BufferedSink](index.md)  <br>More info  <br>Writes all buffered data to the underlying sink, if one exists.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [emit](emit.md)(): [BufferedSink](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSink/emitCompleteSegments/#/PointingToDeclaration/"></a>[emitCompleteSegments](emit-complete-segments.md)| <a name="okio/BufferedSink/emitCompleteSegments/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [emitCompleteSegments](emit-complete-segments.md)(): [BufferedSink](index.md)  <br>More info  <br>Writes complete segments to the underlying sink, if one exists.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [emitCompleteSegments](emit-complete-segments.md)(): [BufferedSink](index.md)  <br>More info  <br>  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>equals| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-326430314)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>[jvm]  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/BufferedSink/flush/#/PointingToDeclaration/"></a>[flush](flush.md)| <a name="okio/BufferedSink/flush/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract override fun [flush](flush.md)()  <br>More info  <br>Writes all buffered data to the underlying sink, if one exists.  <br><br><br>[jvm]  <br>Content  <br>abstract override fun [flush](flush.md)()  <br>More info  <br>  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>hashCode| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-326430314)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>[jvm]  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="java.nio.channels/Channel/isOpen/#/PointingToDeclaration/"></a>[isOpen](../-buffered-source/index.md#%5Bjava.nio.channels%2FChannel%2FisOpen%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)| <a name="java.nio.channels/Channel/isOpen/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>abstract fun [isOpen](../-buffered-source/index.md#%5Bjava.nio.channels%2FChannel%2FisOpen%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/BufferedSink/outputStream/#/PointingToDeclaration/"></a>[outputStream](output-stream.md)| <a name="okio/BufferedSink/outputStream/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>abstract fun [outputStream](output-stream.md)(): [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)  <br>More info  <br>Returns an output stream that writes to this sink.  <br><br><br>
| <a name="okio/Sink/timeout/#/PointingToDeclaration/"></a>[timeout](../-sink/timeout.md)| <a name="okio/Sink/timeout/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [timeout](../-sink/timeout.md)(): [Timeout](../-timeout/index.md)  <br>More info  <br>Returns the timeout for this sink.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [timeout](../-sink/timeout.md)(): [Timeout](../-timeout/index.md)  <br>More info  <br>  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>toString| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-326430314)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>[jvm]  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| <a name="java.nio.channels/WritableByteChannel/write/#java.nio.ByteBuffer/PointingToDeclaration/"></a>write| <a name="java.nio.channels/WritableByteChannel/write/#java.nio.ByteBuffer/PointingToDeclaration/"></a>[jvm, common]  <br>Content  <br>[jvm]  <br>abstract fun [write](index.md#%5Bjava.nio.channels%2FWritableByteChannel%2Fwrite%2F%23java.nio.ByteBuffer%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)(p0: [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>[jvm]  <br>abstract fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [BufferedSink](index.md)  <br>[common, jvm]  <br>abstract fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md)): [BufferedSink](index.md)  <br>[jvm]  <br>abstract fun [write](write.md)(source: [Source](../-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)  <br>[jvm]  <br>abstract fun [write](../-sink/write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>[jvm]  <br>abstract fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)  <br>[common, jvm]  <br>abstract fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)  <br><br><br>[common]  <br>Content  <br>abstract fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [BufferedSink](index.md)  <br>abstract fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)  <br>More info  <br>Like OutputStream.  <br><br><br>[common]  <br>Content  <br>abstract fun [write](write.md)(source: [Source](../-source/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)  <br>More info  <br>Removes byteCount bytes from source and appends them to this sink.  <br><br><br>[common]  <br>Content  <br>abstract fun [write](../-sink/write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>More info  <br>Removes byteCount bytes from source and appends them to this.  <br><br><br>
| <a name="okio/BufferedSink/writeAll/#okio.Source/PointingToDeclaration/"></a>[writeAll](write-all.md)| <a name="okio/BufferedSink/writeAll/#okio.Source/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [writeAll](write-all.md)(source: [Source](../-source/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Removes all bytes from source and appends them to this sink.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [writeAll](write-all.md)(source: [Source](../-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSink/writeByte/#kotlin.Int/PointingToDeclaration/"></a>[writeByte](write-byte.md)| <a name="okio/BufferedSink/writeByte/#kotlin.Int/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [writeByte](write-byte.md)(b: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)  <br>More info  <br>Writes a byte to this sink.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [writeByte](write-byte.md)(b: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSink/writeDecimalLong/#kotlin.Long/PointingToDeclaration/"></a>[writeDecimalLong](write-decimal-long.md)| <a name="okio/BufferedSink/writeDecimalLong/#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [writeDecimalLong](write-decimal-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)  <br>More info  <br>Writes a long to this sink in signed decimal form (i.e., as a string in base 10).  <br><br><br>[jvm]  <br>Content  <br>abstract fun [writeDecimalLong](write-decimal-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSink/writeHexadecimalUnsignedLong/#kotlin.Long/PointingToDeclaration/"></a>[writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md)| <a name="okio/BufferedSink/writeHexadecimalUnsignedLong/#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)  <br>More info  <br>Writes a long to this sink in hexadecimal form (i.e., as a string in base 16).  <br><br><br>[jvm]  <br>Content  <br>abstract fun [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSink/writeInt/#kotlin.Int/PointingToDeclaration/"></a>[writeInt](write-int.md)| <a name="okio/BufferedSink/writeInt/#kotlin.Int/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [writeInt](write-int.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)  <br>More info  <br>Writes a big-endian int to this sink using four bytes.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [writeInt](write-int.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSink/writeIntLe/#kotlin.Int/PointingToDeclaration/"></a>[writeIntLe](write-int-le.md)| <a name="okio/BufferedSink/writeIntLe/#kotlin.Int/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [writeIntLe](write-int-le.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)  <br>More info  <br>Writes a little-endian int to this sink using four bytes.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [writeIntLe](write-int-le.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSink/writeLong/#kotlin.Long/PointingToDeclaration/"></a>[writeLong](write-long.md)| <a name="okio/BufferedSink/writeLong/#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [writeLong](write-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)  <br>More info  <br>Writes a big-endian long to this sink using eight bytes.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [writeLong](write-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSink/writeLongLe/#kotlin.Long/PointingToDeclaration/"></a>[writeLongLe](write-long-le.md)| <a name="okio/BufferedSink/writeLongLe/#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [writeLongLe](write-long-le.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)  <br>More info  <br>Writes a little-endian long to this sink using eight bytes.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [writeLongLe](write-long-le.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSink/writeShort/#kotlin.Int/PointingToDeclaration/"></a>[writeShort](write-short.md)| <a name="okio/BufferedSink/writeShort/#kotlin.Int/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [writeShort](write-short.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)  <br>More info  <br>Writes a big-endian short to this sink using two bytes.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [writeShort](write-short.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSink/writeShortLe/#kotlin.Int/PointingToDeclaration/"></a>[writeShortLe](write-short-le.md)| <a name="okio/BufferedSink/writeShortLe/#kotlin.Int/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [writeShortLe](write-short-le.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)  <br>More info  <br>Writes a little-endian short to this sink using two bytes.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [writeShortLe](write-short-le.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSink/writeString/#kotlin.String#java.nio.charset.Charset/PointingToDeclaration/"></a>[writeString](write-string.md)| <a name="okio/BufferedSink/writeString/#kotlin.String#java.nio.charset.Charset/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>abstract fun [writeString](write-string.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [BufferedSink](index.md)  <br>abstract fun [writeString](write-string.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [BufferedSink](index.md)  <br><br><br>
| <a name="okio/BufferedSink/writeUtf8/#kotlin.String/PointingToDeclaration/"></a>[writeUtf8](write-utf8.md)| <a name="okio/BufferedSink/writeUtf8/#kotlin.String/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [BufferedSink](index.md)  <br>More info  <br>Encodes string in UTF-8 and writes it to this sink.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [BufferedSink](index.md)  <br>abstract fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)  <br>More info  <br>  <br><br><br>[common]  <br>Content  <br>abstract fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)  <br>More info  <br>Encodes the characters at beginIndex up to endIndex from string in UTF-8 and writes it to this sink.  <br><br><br>
| <a name="okio/BufferedSink/writeUtf8CodePoint/#kotlin.Int/PointingToDeclaration/"></a>[writeUtf8CodePoint](write-utf8-code-point.md)| <a name="okio/BufferedSink/writeUtf8CodePoint/#kotlin.Int/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [writeUtf8CodePoint](write-utf8-code-point.md)(codePoint: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)  <br>More info  <br>Encodes codePoint in UTF-8 and writes it to this sink.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [writeUtf8CodePoint](write-utf8-code-point.md)(codePoint: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)  <br>More info  <br>  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/BufferedSink/buffer/#/PointingToDeclaration/"></a>[buffer](buffer.md)| <a name="okio/BufferedSink/buffer/#/PointingToDeclaration/"></a> [common] abstract val [buffer](buffer.md): [Buffer](../-buffer/index.md)This sink's internal buffer.   <br> [jvm] abstract val [buffer](buffer.md): [Buffer](../-buffer/index.md)   <br>


## Inheritors  
  
|  Name| 
|---|
| <a name="okio/Buffer///PointingToDeclaration/"></a>[Buffer](../-buffer/index.md)

