//[okio](../../index.md)/[okio](../index.md)/[ResourceFileSystem](index.md)



# ResourceFileSystem  
 [jvm] class [ResourceFileSystem](index.md) : [FileSystem](../-file-system/index.md#%5Bokio%2FFileSystem%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)

A file system exposing Java classpath resources. It is equivalent to the files returned by [ClassLoader.getResource](https://docs.oracle.com/javase/8/docs/api/java/lang/ClassLoader.html#getResource-kotlin.String-).



Both metadata and file listings are best effort, and will work better for local project paths. The file system does not handle merging of multiple paths from difference resources like overlapping .jar files.



ResourceFileSystem excludes .class files from calls to [list](list.md), but can read them in calls to read and [source](source.md).

   


## Types  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/ResourceFileSystem.Companion///PointingToDeclaration/"></a>[Companion](-companion/index.md)| <a name="okio/ResourceFileSystem.Companion///PointingToDeclaration/"></a>[jvm]  <br>Content  <br>object [Companion](-companion/index.md)  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/ResourceFileSystem/appendingSink/#okio.Path/PointingToDeclaration/"></a>[appendingSink](appending-sink.md)| <a name="okio/ResourceFileSystem/appendingSink/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [appendingSink](appending-sink.md)(file: [Path](../-path/index.md)): [Sink](../-sink/index.md)  <br><br><br>
| <a name="okio/ResourceFileSystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a>[atomicMove](atomic-move.md)| <a name="okio/ResourceFileSystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [atomicMove](atomic-move.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md))  <br><br><br>
| <a name="okio/ResourceFileSystem/canonicalize/#okio.Path/PointingToDeclaration/"></a>[canonicalize](canonicalize.md)| <a name="okio/ResourceFileSystem/canonicalize/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [canonicalize](canonicalize.md)(path: [Path](../-path/index.md)): [Path](../-path/index.md)  <br><br><br>
| <a name="okio/FileSystem/copy/#okio.Path#okio.Path/PointingToDeclaration/"></a>[copy](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2Fcopy%2F%23okio.Path%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)| <a name="okio/FileSystem/copy/#okio.Path#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [copy](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2Fcopy%2F%23okio.Path%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)(source: [Path](../-path/index.md), target: [Path](../-path/index.md))  <br><br><br>
| <a name="okio/FileSystem/createDirectories/#okio.Path/PointingToDeclaration/"></a>[createDirectories](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2FcreateDirectories%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)| <a name="okio/FileSystem/createDirectories/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [createDirectories](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2FcreateDirectories%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)(dir: [Path](../-path/index.md))  <br><br><br>
| <a name="okio/ResourceFileSystem/createDirectory/#okio.Path/PointingToDeclaration/"></a>[createDirectory](create-directory.md)| <a name="okio/ResourceFileSystem/createDirectory/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [createDirectory](create-directory.md)(dir: [Path](../-path/index.md))  <br><br><br>
| <a name="okio/ResourceFileSystem/delete/#okio.Path/PointingToDeclaration/"></a>[delete](delete.md)| <a name="okio/ResourceFileSystem/delete/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [delete](delete.md)(path: [Path](../-path/index.md))  <br><br><br>
| <a name="okio/FileSystem/deleteRecursively/#okio.Path/PointingToDeclaration/"></a>[deleteRecursively](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2FdeleteRecursively%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)| <a name="okio/FileSystem/deleteRecursively/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [deleteRecursively](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2FdeleteRecursively%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)(fileOrDirectory: [Path](../-path/index.md))  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/FileSystem/exists/#okio.Path/PointingToDeclaration/"></a>[exists](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2Fexists%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)| <a name="okio/FileSystem/exists/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [exists](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2Fexists%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)(path: [Path](../-path/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/ResourceFileSystem/list/#okio.Path/PointingToDeclaration/"></a>[list](list.md)| <a name="okio/ResourceFileSystem/list/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [list](list.md)(dir: [Path](../-path/index.md)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<[Path](../-path/index.md)>  <br><br><br>
| <a name="okio/FileSystem/metadata/#okio.Path/PointingToDeclaration/"></a>[metadata](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2Fmetadata%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)| <a name="okio/FileSystem/metadata/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [metadata](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2Fmetadata%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)(path: [Path](../-path/index.md)): [FileMetadata](../-file-metadata/index.md)  <br><br><br>
| <a name="okio/ResourceFileSystem/metadataOrNull/#okio.Path/PointingToDeclaration/"></a>[metadataOrNull](metadata-or-null.md)| <a name="okio/ResourceFileSystem/metadataOrNull/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [metadataOrNull](metadata-or-null.md)(path: [Path](../-path/index.md)): [FileMetadata](../-file-metadata/index.md)?  <br><br><br>
| <a name="okio/ResourceFileSystem/openReadOnly/#okio.Path/PointingToDeclaration/"></a>[openReadOnly](open-read-only.md)| <a name="okio/ResourceFileSystem/openReadOnly/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [openReadOnly](open-read-only.md)(file: [Path](../-path/index.md)): [FileHandle](../-file-handle/index.md)  <br><br><br>
| <a name="okio/ResourceFileSystem/openReadWrite/#okio.Path/PointingToDeclaration/"></a>[openReadWrite](open-read-write.md)| <a name="okio/ResourceFileSystem/openReadWrite/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [openReadWrite](open-read-write.md)(file: [Path](../-path/index.md)): [FileHandle](../-file-handle/index.md)  <br><br><br>
| <a name="okio/FileSystem/read/#okio.Path#kotlin.Function1[okio.BufferedSource,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[read](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)| <a name="okio/FileSystem/read/#okio.Path#kotlin.Function1[okio.BufferedSource,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>inline fun <[T](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)> [read](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)(file: [Path](../-path/index.md), readerAction: [BufferedSource](../-buffered-source/index.md).() -> [T](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)): [T](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)  <br><br><br>
| <a name="okio/ResourceFileSystem/sink/#okio.Path/PointingToDeclaration/"></a>[sink](sink.md)| <a name="okio/ResourceFileSystem/sink/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [sink](sink.md)(file: [Path](../-path/index.md)): [Sink](../-sink/index.md)  <br><br><br>
| <a name="okio/ResourceFileSystem/source/#okio.Path/PointingToDeclaration/"></a>[source](source.md)| <a name="okio/ResourceFileSystem/source/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [source](source.md)(file: [Path](../-path/index.md)): [Source](../-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| <a name="okio/FileSystem/write/#okio.Path#kotlin.Function1[okio.BufferedSink,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[write](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)| <a name="okio/FileSystem/write/#okio.Path#kotlin.Function1[okio.BufferedSink,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>inline fun <[T](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)> [write](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)(file: [Path](../-path/index.md), writerAction: [BufferedSink](../-buffered-sink/index.md).() -> [T](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)): [T](../-zip-file-system/index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F780401557)  <br><br><br>

