//[okio-fakefilesystem](../../../index.md)/[okio.fakefilesystem](../index.md)/[FakeFileSystem](index.md)

# FakeFileSystem

[common]\
class [FakeFileSystem](index.md)(clock: Clock) : FileSystem

A fully in-memory file system useful for testing. It includes features to support writing better tests.

Use [openPaths](open-paths.md) to see which paths have been opened for read or write, but not yet closed. Tests should call [checkNoOpenFiles](check-no-open-files.md) in tearDown() to confirm that no file streams were leaked.

Strict By Default

 -----------------

These actions are not allowed and throw an IOException if attempted:

<ul><li>Moving a file that is currently open for reading or writing.</li><li>Deleting a file that is currently open for reading or writing.</li><li>Moving a file to a path that currently resolves to an empty directory.</li><li>Reading and writing the same file at the same time.</li><li>Opening a file for writing that is already open for writing.</li></ul>

Programs that do not attempt any of the above operations should work fine on both UNIX and Windows systems. Relax these constraints individually or call [emulateWindows](emulate-windows.md) or [emulateUnix](emulate-unix.md); to apply the constraints of a particular operating system.

## Constructors

| | |
|---|---|
| [FakeFileSystem](-fake-file-system.md) | [common]<br>fun [FakeFileSystem](-fake-file-system.md)(clock: Clock = Clock.System) |

## Functions

| Name | Summary |
|---|---|
| [appendingSink](appending-sink.md) | [common]<br>open override fun [appendingSink](appending-sink.md)(file: Path, mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): Sink |
| [atomicMove](atomic-move.md) | [common]<br>open override fun [atomicMove](atomic-move.md)(source: Path, target: Path) |
| [canonicalize](canonicalize.md) | [common]<br>open override fun [canonicalize](canonicalize.md)(path: Path): Path |
| [checkNoOpenFiles](check-no-open-files.md) | [common]<br>fun [checkNoOpenFiles](check-no-open-files.md)()<br>Confirm that all files that have been opened on this file system (with [source](source.md), [sink](sink.md), and [appendingSink](appending-sink.md)) have since been closed. Call this in your test's tearDown() function to confirm that your program hasn't leaked any open files. |
| [copy](index.md#419090610%2FFunctions%2F-1775094286) | [common]<br>open fun [copy](index.md#419090610%2FFunctions%2F-1775094286)(source: Path, target: Path) |
| [createDirectories](index.md#1133903352%2FFunctions%2F-1775094286) | [common]<br>fun [createDirectories](index.md#1133903352%2FFunctions%2F-1775094286)(dir: Path, mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) |
| [createDirectory](create-directory.md) | [common]<br>open override fun [createDirectory](create-directory.md)(dir: Path, mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) |
| [createSymlink](create-symlink.md) | [common]<br>open override fun [createSymlink](create-symlink.md)(source: Path, target: Path) |
| [delete](delete.md) | [common]<br>open override fun [delete](delete.md)(path: Path, mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) |
| [deleteRecursively](index.md#1932614451%2FFunctions%2F-1775094286) | [common]<br>open fun [deleteRecursively](index.md#1932614451%2FFunctions%2F-1775094286)(fileOrDirectory: Path, mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) |
| [emulateUnix](emulate-unix.md) | [common]<br>fun [emulateUnix](emulate-unix.md)()<br>Configure this file system to use a UNIX-like working directory (/, unless the working directory is already UNIX-like) and to follow a UNIX-like policy on what operations are permitted. |
| [emulateWindows](emulate-windows.md) | [common]<br>fun [emulateWindows](emulate-windows.md)()<br>Configure this file system to use a Windows-like working directory (F:\, unless the working directory is already Windows-like) and to follow a Windows-like policy on what operations are permitted. |
| [exists](index.md#-1094583673%2FFunctions%2F-1775094286) | [common]<br>fun [exists](index.md#-1094583673%2FFunctions%2F-1775094286)(path: Path): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [list](list.md) | [common]<br>open override fun [list](list.md)(dir: Path): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Path&gt; |
| [listOrNull](list-or-null.md) | [common]<br>open override fun [listOrNull](list-or-null.md)(dir: Path): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Path&gt;? |
| [listRecursively](index.md#1381599590%2FFunctions%2F-1775094286) | [common]<br>open fun [listRecursively](index.md#1381599590%2FFunctions%2F-1775094286)(dir: Path, followSymlinks: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [Sequence](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.sequences/-sequence/index.html)&lt;Path&gt; |
| [metadata](index.md#-218291494%2FFunctions%2F-1775094286) | [common]<br>fun [metadata](index.md#-218291494%2FFunctions%2F-1775094286)(path: Path): FileMetadata |
| [metadataOrNull](metadata-or-null.md) | [common]<br>open override fun [metadataOrNull](metadata-or-null.md)(path: Path): FileMetadata? |
| [openReadOnly](open-read-only.md) | [common]<br>open override fun [openReadOnly](open-read-only.md)(file: Path): FileHandle |
| [openReadWrite](open-read-write.md) | [common]<br>open override fun [openReadWrite](open-read-write.md)(file: Path, mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): FileHandle |
| [read](index.md#-1037056394%2FFunctions%2F-1775094286) | [common]<br>inline fun &lt;[T](index.md#-1037056394%2FFunctions%2F-1775094286)&gt; [read](index.md#-1037056394%2FFunctions%2F-1775094286)(file: Path, readerAction: BufferedSource.() -&gt; [T](index.md#-1037056394%2FFunctions%2F-1775094286)): [T](index.md#-1037056394%2FFunctions%2F-1775094286) |
| [setExtra](set-extra.md) | [common]<br>fun &lt;[T](set-extra.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [setExtra](set-extra.md)(path: Path, type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;out [T](set-extra.md)&gt;, value: [T](set-extra.md)?)<br>Sets the metadata of type [type](set-extra.md) on [path](set-extra.md) to [value](set-extra.md). If [value](set-extra.md) is null this clears that metadata. |
| [sink](sink.md) | [common]<br>open override fun [sink](sink.md)(file: Path, mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): Sink |
| [source](source.md) | [common]<br>open override fun [source](source.md)(file: Path): Source |
| [toString](to-string.md) | [common]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [write](index.md#1005639157%2FFunctions%2F-1775094286) | [common]<br>inline fun &lt;[T](index.md#1005639157%2FFunctions%2F-1775094286)&gt; [write](index.md#1005639157%2FFunctions%2F-1775094286)(file: Path, mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), writerAction: BufferedSink.() -&gt; [T](index.md#1005639157%2FFunctions%2F-1775094286)): [T](index.md#1005639157%2FFunctions%2F-1775094286) |

## Properties

| Name | Summary |
|---|---|
| [allowClobberingEmptyDirectories](allow-clobbering-empty-directories.md) | [common]<br>var [allowClobberingEmptyDirectories](allow-clobbering-empty-directories.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false<br>True to allow the target of an [atomicMove](atomic-move.md) operation to be an empty directory. Windows file systems typically allow files to replace empty directories; UNIX file systems do not. |
| [allowDeletingOpenFiles](allow-deleting-open-files.md) | [common]<br>var [allowDeletingOpenFiles](allow-deleting-open-files.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false<br>True to allow files to be deleted even if they're currently open for read or write. UNIX file systems typically allow open files to be deleted; Windows file systems do not. |
| [allowMovingOpenFiles](allow-moving-open-files.md) | [common]<br>var [allowMovingOpenFiles](allow-moving-open-files.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false<br>True to allow files to be moved even if they're currently open for read or write. UNIX file systems typically allow open files to be moved; Windows file systems do not. |
| [allowReadsWhileWriting](allow-reads-while-writing.md) | [common]<br>var [allowReadsWhileWriting](allow-reads-while-writing.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false<br>True to permit a file to have a [source](source.md) and [sink](sink.md) open at the same time. Both Windows and UNIX file systems permit this but the result may be undefined. |
| [allowSymlinks](allow-symlinks.md) | [common]<br>var [allowSymlinks](allow-symlinks.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false<br>True to allow symlinks to be created. UNIX file systems typically allow symlinks; Windows file systems do not. Setting this to false after creating a symlink does not prevent that symlink from being returned or used. |
| [allowWritesWhileWriting](allow-writes-while-writing.md) | [common]<br>var [allowWritesWhileWriting](allow-writes-while-writing.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false<br>True to permit a file to have multiple [sinks](sink.md) open at the same time. Both Windows and UNIX file systems permit this but the result may be undefined. |
| [allPaths](all-paths.md) | [common]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "allPaths")<br>val [allPaths](all-paths.md): [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)&lt;Path&gt;<br>Canonical paths for every file and directory in this file system. This omits file system roots like C:\ and /. |
| [clock](clock.md) | [common]<br>@[JvmField](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-field/index.html)<br>val [clock](clock.md): Clock |
| [openPaths](open-paths.md) | [common]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "openPaths")<br>val [openPaths](open-paths.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Path&gt;<br>Canonical paths currently opened for reading or writing in the order they were opened. This may contain duplicates if a single path is open by multiple readers. |
| [workingDirectory](working-directory.md) | [common]<br>var [workingDirectory](working-directory.md): Path<br>An absolute path with this file system's current working directory. Relative paths will be resolved against this directory when they are used. |
