

### All Types

| Name | Summary |
|---|---|
| [okio.ArrayIndexOutOfBoundsException](../okio/-array-index-out-of-bounds-exception/index.md) |  |
| [okio.AsyncTimeout](../okio/-async-timeout/index.md) | This timeout uses a background thread to take action exactly when the timeout occurs. Use this to implement timeouts where they aren't supported natively, such as to sockets that are blocked on writing. |
| [okio.Buffer](../okio/-buffer/index.md) | A collection of bytes in memory. |
| [okio.BufferedSink](../okio/-buffered-sink/index.md) | A sink that keeps a buffer internally so that callers can do small writes without a performance penalty. |
| [okio.BufferedSource](../okio/-buffered-source/index.md) | A source that keeps a buffer internally so that callers can do small reads without a performance penalty. It also allows clients to read ahead, buffering as much as necessary before consuming input. |
| [okio.ByteString](../okio/-byte-string/index.md) | An immutable sequence of bytes. |
| [okio.DeflaterSink](../okio/-deflater-sink/index.md) | A sink that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to compress data written to another source. |
| [okio.EOFException](../okio/-e-o-f-exception/index.md) |  |
| [java.io.File](../okio/java.io.-file/index.md) (extensions in package okio) |  |
| [okio.ForwardingSink](../okio/-forwarding-sink/index.md) | A [Sink](../okio/-sink/index.md) which forwards calls to another. Useful for subclassing. |
| [okio.ForwardingSource](../okio/-forwarding-source/index.md) | A [Source](../okio/-source/index.md) which forwards calls to another. Useful for subclassing. |
| [okio.ForwardingTimeout](../okio/-forwarding-timeout/index.md) | A [Timeout](../okio/-timeout/index.md) which forwards calls to another. Useful for subclassing. |
| [okio.GzipSink](../okio/-gzip-sink/index.md) | A sink that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to compress written data to another sink. |
| [okio.GzipSource](../okio/-gzip-source/index.md) | A source that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to decompress data read from another source. |
| [okio.HashingSink](../okio/-hashing-sink/index.md) | A sink that computes a hash of the full stream of bytes it has accepted. To use, create an instance with your preferred hash algorithm. Write all of the data to the sink and then call [hash](#) to compute the final hash value. |
| [okio.HashingSource](../okio/-hashing-source/index.md) | A source that computes a hash of the full stream of bytes it has supplied. To use, create an instance with your preferred hash algorithm. Exhaust the source by reading all of its bytes and then call [hash](#) to compute the final hash value. |
| [okio.InflaterSource](../okio/-inflater-source/index.md) | A source that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to decompress data read from another source. |
| [java.io.InputStream](../okio/java.io.-input-stream/index.md) (extensions in package okio) |  |
| [okio.IOException](../okio/-i-o-exception/index.md) |  |
| [okio.Options](../okio/-options/index.md) | An indexed set of values that may be read with [BufferedSource.select](../okio/-buffered-source/select.md). |
| [java.io.OutputStream](../okio/java.io.-output-stream/index.md) (extensions in package okio) |  |
| [java.nio.file.Path](../okio/java.nio.file.-path/index.md) (extensions in package okio) |  |
| [okio.Pipe](../okio/-pipe/index.md) | A source and a sink that are attached. The sink's output is the source's input. Typically each is accessed by its own thread: a producer thread writes data to the sink and a consumer thread reads data from the source. |
| [okio.Sink](../okio/-sink/index.md) | Receives a stream of bytes. Use this interface to write data wherever it's needed: to the network, storage, or a buffer in memory. Sinks may be layered to transform received data, such as to compress, encrypt, throttle, or add protocol framing. |
| [java.net.Socket](../okio/java.net.-socket/index.md) (extensions in package okio) |  |
| [okio.Source](../okio/-source/index.md) | Supplies a stream of bytes. Use this interface to read data from wherever it's located: from the network, storage, or a buffer in memory. Sources may be layered to transform supplied data, such as to decompress, decrypt, or remove protocol framing. |
| [kotlin.String](../okio/kotlin.-string/index.md) (extensions in package okio) |  |
| [okio.Throttler](../okio/-throttler/index.md) | Enables limiting of Source and Sink throughput. Attach to this throttler via [source](../okio/-throttler/source.md) and [sink](../okio/-throttler/sink.md) and set the desired throughput via [bytesPerSecond](../okio/-throttler/bytes-per-second.md). Multiple Sources and Sinks can be attached to a single Throttler and they will be throttled as a group, where their combined throughput will not exceed the desired throughput. The same Source or Sink can be attached to multiple Throttlers and its throughput will not exceed the desired throughput of any of the Throttlers. |
| [okio.Timeout](../okio/-timeout/index.md) | A policy on how much time to spend on a task before giving up. When a task times out, it is left in an unspecified state and should be abandoned. For example, if reading from a source times out, that source should be closed and the read should be retried later. If writing to a sink times out, the same rules apply: close the sink and retry later. |
