[okio](../../index.md) / [okio](../index.md) / [Buffer](./index.md)

# Buffer

`expect class Buffer : `[`BufferedSource`](../-buffered-source/index.md)`, `[`BufferedSink`](../-buffered-sink/index.md)

**Platform and version requirements:** JVM, js, native

A collection of bytes in memory.

**Moving data from one buffer to another is fast.** Instead of copying bytes from one place in
memory to another, this class just changes ownership of the underlying byte arrays.

**This buffer grows with your data.** Just like ArrayList, each buffer starts small. It consumes
only the memory it needs to.

**This buffer pools its byte arrays.** When you allocate a byte array in Java, the runtime must
zero-fill the requested array before returning it to you. Even if you're going to write over that
space anyway. This class avoids zero-fill and GC churn by pooling byte arrays.

### Types

| Name | Summary |
|---|---|
| [UnsafeCursor](-unsafe-cursor/index.md)<br>(JVM) | `class UnsafeCursor : `[`Closeable`](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html)<br>A handle to the underlying data in a buffer. This handle is unsafe because it does not enforce its own invariants. Instead, it assumes a careful user who has studied Okio's implementation details and their consequences. |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `Buffer()`<br>A collection of bytes in memory. |

### Properties

| Name | Summary |
|---|---|
| [buffer](buffer.md) | `val buffer: `[`Buffer`](./index.md)<br>This source's internal buffer. |
| [size](size.md) | `var size: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |

### Functions

| Name | Summary |
|---|---|
| [buffer](buffer.md)<br>(JVM) | `fun buffer(): `[`Buffer`](./index.md)<br>Returns this source's internal buffer. |
| [clear](clear.md) | `fun clear(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [clone](clone.md)<br>(JVM) | `fun clone(): `[`Buffer`](./index.md)<br>Returns a deep copy of this buffer. |
| [close](close.md) | `fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [completeSegmentByteCount](complete-segment-byte-count.md) | `fun completeSegmentByteCount(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the number of bytes in segments that are not writable. This is the number of bytes that can be flushed immediately to an underlying sink without harming throughput. |
| [copyTo](copy-to.md)<br>(JVM) | `fun copyTo(out: `[`Buffer`](./index.md)`, offset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)` = 0L, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Buffer`](./index.md)<br>`fun copyTo(out: `[`OutputStream`](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)`, offset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)` = 0L, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)` = size - offset): `[`Buffer`](./index.md)<br>Copy `byteCount` bytes from this, starting at `offset`, to `out`.`fun copyTo(out: `[`Buffer`](./index.md)`, offset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)` = 0L): `[`Buffer`](./index.md)<br>Overload of [copyTo](copy-to.md) with byteCount = size - offset, work around for https://youtrack.jetbrains.com/issue/KT-30847 |
| [emit](emit.md) | `fun emit(): `[`Buffer`](./index.md)<br>Writes all buffered data to the underlying sink, if one exists. Like [flush](../-buffered-sink/flush.md), but weaker. Call this before this buffered sink goes out of scope so that its data can reach its destination. |
| [emitCompleteSegments](emit-complete-segments.md) | `fun emitCompleteSegments(): `[`Buffer`](./index.md)<br>Writes complete segments to the underlying sink, if one exists. Like [flush](../-buffered-sink/flush.md), but weaker. Use this to limit the memory held in the buffer to a single segment. Typically application code will not need to call this: it is only necessary when application code writes directly to this [sink's buffer](../buffer.md). |
| [equals](equals.md) | `fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [exhausted](exhausted.md) | `fun exhausted(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [flush](flush.md) | `fun flush(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [get](get.md) | `operator fun get(pos: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)<br>Returns the byte at `pos`. |
| [hashCode](hash-code.md) | `fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [hmacSha1](hmac-sha1.md)<br>(JVM) | `fun hmacSha1(key: `[`ByteString`](../-byte-string/index.md)`): `[`ByteString`](../-byte-string/index.md)<br>Returns the 160-bit SHA-1 HMAC of this buffer. |
| [hmacSha256](hmac-sha256.md)<br>(JVM) | `fun hmacSha256(key: `[`ByteString`](../-byte-string/index.md)`): `[`ByteString`](../-byte-string/index.md)<br>Returns the 256-bit SHA-256 HMAC of this buffer. |
| [hmacSha512](hmac-sha512.md)<br>(JVM) | `fun hmacSha512(key: `[`ByteString`](../-byte-string/index.md)`): `[`ByteString`](../-byte-string/index.md)<br>Returns the 512-bit SHA-512 HMAC of this buffer. |
| [indexOf](index-of.md) | `fun indexOf(b: `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>`fun indexOf(b: `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)`, fromIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, toIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>`fun indexOf(bytes: `[`ByteString`](../-byte-string/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>`fun indexOf(bytes: `[`ByteString`](../-byte-string/index.md)`, fromIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`fun indexOf(b: `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)`, fromIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of `b` in this at or beyond `fromIndex`, or -1 if this buffer does not contain `b` in that range. |
| [indexOfElement](index-of-element.md) | `fun indexOfElement(targetBytes: `[`ByteString`](../-byte-string/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>`fun indexOfElement(targetBytes: `[`ByteString`](../-byte-string/index.md)`, fromIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [inputStream](input-stream.md)<br>(JVM) | `fun inputStream(): `[`InputStream`](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)<br>Returns an input stream that reads from this source. |
| [isOpen](is-open.md)<br>(JVM) | `fun isOpen(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [md5](md5.md)<br>(JVM) | `fun md5(): `[`ByteString`](../-byte-string/index.md)<br>Returns the 128-bit MD5 hash of this buffer. |
| [outputStream](output-stream.md)<br>(JVM) | `fun outputStream(): `[`OutputStream`](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)<br>Returns an output stream that writes to this sink. |
| [peek](peek.md) | `fun peek(): `[`BufferedSource`](../-buffered-source/index.md) |
| [rangeEquals](range-equals.md) | `fun rangeEquals(offset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, bytes: `[`ByteString`](../-byte-string/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>`fun rangeEquals(offset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, bytes: `[`ByteString`](../-byte-string/index.md)`, bytesOffset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [read](read.md)<br>(JVM) | `fun read(sink: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): <ERROR CLASS>`<br>`fun read(sink: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>`fun read(sink: `[`ByteBuffer`](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>`fun read(sink: `[`Buffer`](./index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [readAll](read-all.md) | `fun readAll(sink: `[`Sink`](../-sink/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [readAndWriteUnsafe](read-and-write-unsafe.md)<br>(JVM) | `fun readAndWriteUnsafe(unsafeCursor: `[`Buffer.UnsafeCursor`](-unsafe-cursor/index.md)` = UnsafeCursor()): `[`Buffer.UnsafeCursor`](-unsafe-cursor/index.md) |
| [readByte](read-byte.md) | `fun readByte(): `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html) |
| [readByteArray](read-byte-array.md) | `fun readByteArray(): <ERROR CLASS>`<br>`fun readByteArray(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html) |
| [readByteString](read-byte-string.md) | `fun readByteString(): `[`ByteString`](../-byte-string/index.md)<br>`fun readByteString(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): <ERROR CLASS>` |
| [readDecimalLong](read-decimal-long.md) | `fun readDecimalLong(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [readFrom](read-from.md)<br>(JVM) | `fun readFrom(input: `[`InputStream`](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)`): `[`Buffer`](./index.md)<br>Read and exhaust bytes from `input` into this.`fun readFrom(input: `[`InputStream`](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Buffer`](./index.md)<br>Read `byteCount` bytes from `input` into this. |
| [readFully](read-fully.md) | `fun readFully(sink: `[`Buffer`](./index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>`fun readFully(sink: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): <ERROR CLASS>` |
| [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md) | `fun readHexadecimalUnsignedLong(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [readInt](read-int.md) | `fun readInt(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [readIntLe](read-int-le.md) | `fun readIntLe(): <ERROR CLASS>` |
| [readLong](read-long.md) | `fun readLong(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [readLongLe](read-long-le.md) | `fun readLongLe(): <ERROR CLASS>` |
| [readShort](read-short.md) | `fun readShort(): `[`Short`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html) |
| [readShortLe](read-short-le.md) | `fun readShortLe(): <ERROR CLASS>` |
| [readString](read-string.md)<br>(JVM) | `fun readString(charset: `[`Charset`](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes all bytes from this, decodes them as `charset`, and returns the string.`fun readString(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, charset: `[`Charset`](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes `byteCount` bytes from this, decodes them as `charset`, and returns the string. |
| [readUnsafe](read-unsafe.md)<br>(JVM) | `fun readUnsafe(unsafeCursor: `[`Buffer.UnsafeCursor`](-unsafe-cursor/index.md)` = UnsafeCursor()): `[`Buffer.UnsafeCursor`](-unsafe-cursor/index.md) |
| [readUtf8](read-utf8.md) | `fun readUtf8(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>`fun readUtf8(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [readUtf8CodePoint](read-utf8-code-point.md) | `fun readUtf8CodePoint(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [readUtf8Line](read-utf8-line.md) | `fun readUtf8Line(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [readUtf8LineStrict](read-utf8-line-strict.md) | `fun readUtf8LineStrict(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>`fun readUtf8LineStrict(limit: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [request](request.md) | `fun request(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [require](require.md) | `fun require(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [select](select.md) | `fun select(options: <ERROR CLASS>): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [sha1](sha1.md)<br>(JVM) | `fun sha1(): `[`ByteString`](../-byte-string/index.md)<br>Returns the 160-bit SHA-1 hash of this buffer. |
| [sha256](sha256.md)<br>(JVM) | `fun sha256(): `[`ByteString`](../-byte-string/index.md)<br>Returns the 256-bit SHA-256 hash of this buffer. |
| [sha512](sha512.md)<br>(JVM) | `fun sha512(): `[`ByteString`](../-byte-string/index.md)<br>Returns the 512-bit SHA-512 hash of this buffer. |
| [skip](skip.md) | `fun skip(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Reads and discards `byteCount` bytes from this source. Throws an [java.io.EOFException](https://docs.oracle.com/javase/8/docs/api/java/io/EOFException.html) if the source is exhausted before the requested bytes can be skipped. |
| [snapshot](snapshot.md) | `fun snapshot(): `[`ByteString`](../-byte-string/index.md)<br>Returns an immutable copy of this buffer as a byte string.`fun snapshot(byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`ByteString`](../-byte-string/index.md)<br>Returns an immutable copy of the first `byteCount` bytes of this buffer as a byte string. |
| [timeout](timeout.md) | `fun timeout(): `[`Timeout`](../-timeout/index.md) |
| [toString](to-string.md) | `fun toString(): <ERROR CLASS>`<br>Returns a human-readable string that describes the contents of this buffer. Typically this is a string like `[text=Hello]` or `[hex=0000ffff]`. |
| [write](write.md)<br>(JVM) | `fun write(byteString: `[`ByteString`](../-byte-string/index.md)`): `[`Buffer`](./index.md)<br>`fun write(source: `[`ByteBuffer`](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>`fun write(source: `[`Buffer`](./index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`fun write(source: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`Buffer`](./index.md)<br>Like [OutputStream.write](#), this writes a complete byte array to this sink.`fun write(source: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](./index.md)<br>Like [OutputStream.write](#), this writes `byteCount` bytes of `source`, starting at `offset`.`fun write(source: `[`Source`](../-source/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Buffer`](./index.md)<br>Removes `byteCount` bytes from `source` and appends them to this sink. |
| [writeAll](write-all.md) | `fun writeAll(source: `[`Source`](../-source/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [writeByte](write-byte.md) | `fun writeByte(b: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](./index.md)<br>Writes a byte to this sink. |
| [writeDecimalLong](write-decimal-long.md) | `fun writeDecimalLong(v: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Buffer`](./index.md)<br>Writes a long to this sink in signed decimal form (i.e., as a string in base 10). |
| [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md) | `fun writeHexadecimalUnsignedLong(v: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Buffer`](./index.md)<br>Writes a long to this sink in hexadecimal form (i.e., as a string in base 16). |
| [writeInt](write-int.md) | `fun writeInt(i: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](./index.md)<br>Writes a big-endian int to this sink using four bytes. |
| [writeIntLe](write-int-le.md) | `fun writeIntLe(i: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](./index.md)<br>Writes a little-endian int to this sink using four bytes. |
| [writeLong](write-long.md) | `fun writeLong(v: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Buffer`](./index.md)<br>Writes a big-endian long to this sink using eight bytes. |
| [writeLongLe](write-long-le.md) | `fun writeLongLe(v: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Buffer`](./index.md)<br>Writes a little-endian long to this sink using eight bytes. |
| [writeShort](write-short.md) | `fun writeShort(s: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](./index.md)<br>Writes a big-endian short to this sink using two bytes. |
| [writeShortLe](write-short-le.md) | `fun writeShortLe(s: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](./index.md)<br>Writes a little-endian short to this sink using two bytes. |
| [writeString](write-string.md)<br>(JVM) | `fun writeString(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, charset: `[`Charset`](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)`): `[`Buffer`](./index.md)<br>`fun writeString(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, beginIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, endIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, charset: `[`Charset`](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)`): `[`Buffer`](./index.md) |
| [writeTo](write-to.md)<br>(JVM) | `fun writeTo(out: `[`OutputStream`](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)` = size): `[`Buffer`](./index.md)<br>Write `byteCount` bytes from this to `out`. |
| [writeUtf8](write-utf8.md) | `fun writeUtf8(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Buffer`](./index.md)<br>Encodes `string` in UTF-8 and writes it to this sink.`fun writeUtf8(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, beginIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, endIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](./index.md)<br>Encodes the characters at `beginIndex` up to `endIndex` from `string` in UTF-8 and writes it to this sink. |
| [writeUtf8CodePoint](write-utf8-code-point.md) | `fun writeUtf8CodePoint(codePoint: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](./index.md)<br>Encodes `codePoint` in UTF-8 and writes it to this sink. |

### Inherited Functions

| Name | Summary |
|---|---|
| [exhausted](../-buffered-source/exhausted.md)<br>(JVM, js, native) | `abstract fun exhausted(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if there are no more bytes in this source. This will block until there are bytes to read or the source is definitely exhausted. |
| [flush](../-buffered-sink/flush.md)<br>(JVM, js, native) | `abstract fun flush(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Writes all buffered data to the underlying sink, if one exists. Then that sink is recursively flushed which pushes data as far as possible towards its ultimate destination. Typically that destination is a network socket or file. |
| [indexOf](../-buffered-source/index-of.md)<br>(JVM, js, native) | `abstract fun indexOf(b: `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOf(b, 0)](../-buffered-source/index-of.md).`abstract fun indexOf(b: `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)`, fromIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of the first `b` in the buffer at or after `fromIndex`. This expands the buffer as necessary until `b` is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested byte is found.`abstract fun indexOf(b: `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)`, fromIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, toIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of `b` if it is found in the range of `fromIndex` inclusive to `toIndex` exclusive. If `b` isn't found, or if `fromIndex == toIndex`, then -1 is returned.`abstract fun indexOf(bytes: `[`ByteString`](../-byte-string/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOf(bytes, 0)](../-buffered-source/index-of.md).`abstract fun indexOf(bytes: `[`ByteString`](../-byte-string/index.md)`, fromIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of the first match for `bytes` in the buffer at or after `fromIndex`. This expands the buffer as necessary until `bytes` is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested bytes are found. |
| [indexOfElement](../-buffered-source/index-of-element.md)<br>(JVM, js, native) | `abstract fun indexOfElement(targetBytes: `[`ByteString`](../-byte-string/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOfElement(targetBytes, 0)](../-buffered-source/index-of-element.md).`abstract fun indexOfElement(targetBytes: `[`ByteString`](../-byte-string/index.md)`, fromIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the first index in this buffer that is at or after `fromIndex` and that contains any of the bytes in `targetBytes`. This expands the buffer as necessary until a target byte is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested byte is found. |
| [peek](../-buffered-source/peek.md)<br>(JVM, js, native) | `abstract fun peek(): `[`BufferedSource`](../-buffered-source/index.md)<br>Returns a new `BufferedSource` that can read data from this `BufferedSource` without consuming it. The returned source becomes invalid once this source is next read or closed. |
| [rangeEquals](../-buffered-source/range-equals.md)<br>(JVM, js, native) | `abstract fun rangeEquals(offset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, bytes: `[`ByteString`](../-byte-string/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if the bytes at `offset` in this source equal `bytes`. This expands the buffer as necessary until a byte does not match, all bytes are matched, or if the stream is exhausted before enough bytes could determine a match.`abstract fun rangeEquals(offset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, bytes: `[`ByteString`](../-byte-string/index.md)`, bytesOffset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if `byteCount` bytes at `offset` in this source equal `bytes` at `bytesOffset`. This expands the buffer as necessary until a byte does not match, all bytes are matched, or if the stream is exhausted before enough bytes could determine a match. |
| [read](../-buffered-source/read.md)<br>(JVM, js, native) | `abstract fun read(sink: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes up to `sink.length` bytes from this and copies them into `sink`. Returns the number of bytes read, or -1 if this source is exhausted.`abstract fun read(sink: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes up to `byteCount` bytes from this and copies them into `sink` at `offset`. Returns the number of bytes read, or -1 if this source is exhausted. |
| [readAll](../-buffered-source/read-all.md)<br>(JVM, js, native) | `abstract fun readAll(sink: `[`Sink`](../-sink/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes all bytes from this and appends them to `sink`. Returns the total number of bytes written to `sink` which will be 0 if this is exhausted. |
| [readByte](../-buffered-source/read-byte.md)<br>(JVM, js, native) | `abstract fun readByte(): `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)<br>Removes a byte from this source and returns it. |
| [readByteArray](../-buffered-source/read-byte-array.md)<br>(JVM, js, native) | `abstract fun readByteArray(): `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Removes all bytes from this and returns them as a byte array.`abstract fun readByteArray(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Removes `byteCount` bytes from this and returns them as a byte array. |
| [readByteString](../-buffered-source/read-byte-string.md)<br>(JVM, js, native) | `abstract fun readByteString(): `[`ByteString`](../-byte-string/index.md)<br>Removes all bytes bytes from this and returns them as a byte string.`abstract fun readByteString(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`ByteString`](../-byte-string/index.md)<br>Removes `byteCount` bytes from this and returns them as a byte string. |
| [readDecimalLong](../-buffered-source/read-decimal-long.md)<br>(JVM, js, native) | `abstract fun readDecimalLong(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Reads a long from this source in signed decimal form (i.e., as a string in base 10 with optional leading '-'). This will iterate until a non-digit character is found. |
| [readFully](../-buffered-source/read-fully.md)<br>(JVM, js, native) | `abstract fun readFully(sink: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Removes exactly `sink.length` bytes from this and copies them into `sink`. Throws an [java.io.EOFException](https://docs.oracle.com/javase/8/docs/api/java/io/EOFException.html) if the requested number of bytes cannot be read.`abstract fun readFully(sink: `[`Buffer`](./index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Removes exactly `byteCount` bytes from this and appends them to `sink`. Throws an [java.io.EOFException](https://docs.oracle.com/javase/8/docs/api/java/io/EOFException.html) if the requested number of bytes cannot be read. |
| [readHexadecimalUnsignedLong](../-buffered-source/read-hexadecimal-unsigned-long.md)<br>(JVM, js, native) | `abstract fun readHexadecimalUnsignedLong(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Reads a long form this source in hexadecimal form (i.e., as a string in base 16). This will iterate until a non-hexadecimal character is found. |
| [readInt](../-buffered-source/read-int.md)<br>(JVM, js, native) | `abstract fun readInt(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes four bytes from this source and returns a big-endian int. |
| [readIntLe](../-buffered-source/read-int-le.md)<br>(JVM, js, native) | `abstract fun readIntLe(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes four bytes from this source and returns a little-endian int. |
| [readLong](../-buffered-source/read-long.md)<br>(JVM, js, native) | `abstract fun readLong(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes eight bytes from this source and returns a big-endian long. |
| [readLongLe](../-buffered-source/read-long-le.md)<br>(JVM, js, native) | `abstract fun readLongLe(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes eight bytes from this source and returns a little-endian long. |
| [readShort](../-buffered-source/read-short.md)<br>(JVM, js, native) | `abstract fun readShort(): `[`Short`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)<br>Removes two bytes from this source and returns a big-endian short. |
| [readShortLe](../-buffered-source/read-short-le.md)<br>(JVM, js, native) | `abstract fun readShortLe(): `[`Short`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)<br>Removes two bytes from this source and returns a little-endian short. |
| [readUtf8](../-buffered-source/read-utf8.md)<br>(JVM, js, native) | `abstract fun readUtf8(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes all bytes from this, decodes them as UTF-8, and returns the string. Returns the empty string if this source is empty.`abstract fun readUtf8(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes `byteCount` bytes from this, decodes them as UTF-8, and returns the string. |
| [readUtf8CodePoint](../-buffered-source/read-utf8-code-point.md)<br>(JVM, js, native) | `abstract fun readUtf8CodePoint(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes and returns a single UTF-8 code point, reading between 1 and 4 bytes as necessary. |
| [readUtf8Line](../-buffered-source/read-utf8-line.md)<br>(JVM, js, native) | `abstract fun readUtf8Line(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?`<br>Removes and returns characters up to but not including the next line break. A line break is either `"\n"` or `"\r\n"`; these characters are not included in the result. |
| [readUtf8LineStrict](../-buffered-source/read-utf8-line-strict.md)<br>(JVM, js, native) | `abstract fun readUtf8LineStrict(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes and returns characters up to but not including the next line break. A line break is either `"\n"` or `"\r\n"`; these characters are not included in the result.`abstract fun readUtf8LineStrict(limit: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Like [readUtf8LineStrict](../-buffered-source/read-utf8-line-strict.md), except this allows the caller to specify the longest allowed match. Use this to protect against streams that may not include `"\n"` or `"\r\n"`. |
| [request](../-buffered-source/request.md)<br>(JVM, js, native) | `abstract fun request(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true when the buffer contains at least `byteCount` bytes, expanding it as necessary. Returns false if the source is exhausted before the requested bytes can be read. |
| [require](../-buffered-source/require.md)<br>(JVM, js, native) | `abstract fun require(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Returns when the buffer contains at least `byteCount` bytes. Throws an [java.io.EOFException](https://docs.oracle.com/javase/8/docs/api/java/io/EOFException.html) if the source is exhausted before the required bytes can be read. |
| [select](../-buffered-source/select.md) | `abstract fun select(options: `[`Options`](../-options/index.md)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Finds the first string in `options` that is a prefix of this buffer, consumes it from this buffer, and returns its index. If no byte string in `options` is a prefix of this buffer this returns -1 and no bytes are consumed. |
| [writeAll](../-buffered-sink/write-all.md)<br>(JVM, js, native) | `abstract fun writeAll(source: `[`Source`](../-source/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes all bytes from `source` and appends them to this sink. Returns the number of bytes read which will be 0 if `source` is exhausted. |

### Extension Functions

| Name | Summary |
|---|---|
| [deflate](../deflate.md)<br>(JVM) | `fun `[`Sink`](../-sink/index.md)`.deflate(deflater: `[`Deflater`](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html)` = Deflater()): `[`DeflaterSink`](../-deflater-sink/index.md)<br>Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](../-sink/index.md) while writing. |
| [inflate](../inflate.md)<br>(JVM) | `fun `[`Source`](../-source/index.md)`.inflate(inflater: `[`Inflater`](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html)` = Inflater()): `[`InflaterSource`](../-inflater-source/index.md)<br>Returns an [InflaterSource](../-inflater-source/index.md) that DEFLATE-decompresses this [Source](../-source/index.md) while reading. |
