[okio](../../index.md) / [okio](../index.md) / [BufferedSink](index.md) / [writeLong](./write-long.md)

# writeLong

`abstract fun writeLong(v: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`BufferedSink`](index.md)

**Platform and version requirements:** JVM, js, native

Writes a big-endian long to this sink using eight bytes.

```
Buffer buffer = new Buffer();
buffer.writeLong(9223372036854775807L);
buffer.writeLong(15);

assertEquals(16, buffer.size());
assertEquals((byte) 0x7f, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x0f, buffer.readByte());
assertEquals(0, buffer.size());
```

