[okio](../../index.md) / [okio](../index.md) / [ForwardingSink](./index.md)

# ForwardingSink

`abstract class ForwardingSink : `[`Sink`](../-sink/index.md)

**Platform and version requirements:** JVM

A [Sink](../-sink/index.md) which forwards calls to another. Useful for subclassing.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `ForwardingSink(delegate: `[`Sink`](../-sink/index.md)`)`<br>A [Sink](../-sink/index.md) which forwards calls to another. Useful for subclassing. |

### Properties

| Name | Summary |
|---|---|
| [delegate](delegate.md) | `val delegate: `[`Sink`](../-sink/index.md)<br>[Sink](../-sink/index.md) to which this instance is delegating. |

### Functions

| Name | Summary |
|---|---|
| [close](close.md) | `open fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [flush](flush.md) | `open fun flush(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [timeout](timeout.md) | `open fun timeout(): `[`Timeout`](../-timeout/index.md) |
| [toString](to-string.md) | `open fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [write](write.md) | `open fun write(source: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Extension Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md)<br>(JVM, js, native) | `expect fun `[`Sink`](../-sink/index.md)`.buffer(): `[`BufferedSink`](../-buffered-sink/index.md)<br>Returns a new sink that buffers writes to `sink`. The returned sink will batch writes to `sink`. Use this wherever you write to a sink to get an ergonomic and efficient access to data. |
| [deflate](../deflate.md)<br>(JVM) | `fun `[`Sink`](../-sink/index.md)`.deflate(deflater: `[`Deflater`](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html)` = Deflater()): `[`DeflaterSink`](../-deflater-sink/index.md)<br>Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](../-sink/index.md) while writing. |
| [gzip](../gzip.md)<br>(JVM) | `fun `[`Sink`](../-sink/index.md)`.gzip(): `[`GzipSink`](../-gzip-sink/index.md)<br>Returns a [GzipSink](../-gzip-sink/index.md) that gzip-compresses to this [Sink](../-sink/index.md) while writing. |

### Inheritors

| Name | Summary |
|---|---|
| [HashingSink](../-hashing-sink/index.md)<br>(JVM) | `class HashingSink : `[`ForwardingSink`](./index.md)<br>A sink that computes a hash of the full stream of bytes it has accepted. To use, create an instance with your preferred hash algorithm. Write all of the data to the sink and then call [hash](#) to compute the final hash value. |
