[okio](../../index.md) / [okio](../index.md) / [InflaterSource](./index.md)

# InflaterSource

`class InflaterSource : `[`Source`](../-source/index.md)

**Platform and version requirements:** JVM

A source that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to decompress data read from
another source.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `InflaterSource(source: `[`Source`](../-source/index.md)`, inflater: `[`Inflater`](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html)`)` |

### Functions

| Name | Summary |
|---|---|
| [close](close.md) | `fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [read](read.md) | `fun read(sink: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [refill](refill.md) | `fun refill(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Refills the inflater with compressed data if it needs input. (And only if it needs input). Returns true if the inflater required input but the source was exhausted. |
| [timeout](timeout.md) | `fun timeout(): `[`Timeout`](../-timeout/index.md) |

### Extension Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md)<br>(JVM, js, native) | `expect fun `[`Source`](../-source/index.md)`.buffer(): `[`BufferedSource`](../-buffered-source/index.md)<br>Returns a new source that buffers reads from `source`. The returned source will perform bulk reads into its in-memory buffer. Use this wherever you read a source to get an ergonomic and efficient access to data. |
| [gzip](../gzip.md)<br>(JVM) | `fun `[`Source`](../-source/index.md)`.gzip(): `[`GzipSource`](../-gzip-source/index.md)<br>Returns a [GzipSource](../-gzip-source/index.md) that gzip-decompresses this [Source](../-source/index.md) while reading. |
| [inflate](../inflate.md)<br>(JVM) | `fun `[`Source`](../-source/index.md)`.inflate(inflater: `[`Inflater`](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html)` = Inflater()): `[`InflaterSource`](./index.md)<br>Returns an [InflaterSource](./index.md) that DEFLATE-decompresses this [Source](../-source/index.md) while reading. |
