[okio](../../index.md) / [okio](../index.md) / [Timeout](./index.md)

# Timeout

`open expect class Timeout`

**Platform and version requirements:** JVM, js, native

A policy on how much time to spend on a task before giving up. When a task times out, it is left
in an unspecified state and should be abandoned. For example, if reading from a source times out,
that source should be closed and the read should be retried later. If writing to a sink times
out, the same rules apply: close the sink and retry later.

### Timeouts and Deadlines

This class offers two complementary controls to define a timeout policy.

**Timeouts** specify the maximum time to wait for a single operation to complete. Timeouts are
typically used to detect problems like network partitions. For example, if a remote peer doesn't
return *any* data for ten seconds, we may assume that the peer is unavailable.

**Deadlines** specify the maximum time to spend on a job, composed of one or more operations. Use
deadlines to set an upper bound on the time invested on a job. For example, a battery-conscious
app may limit how much time it spends pre-loading content.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `Timeout()` |

### Functions

| Name | Summary |
|---|---|
| [clearDeadline](clear-deadline.md)<br>(JVM) | `open fun clearDeadline(): `[`Timeout`](./index.md)<br>Clears the deadline. |
| [clearTimeout](clear-timeout.md)<br>(JVM) | `open fun clearTimeout(): `[`Timeout`](./index.md)<br>Clears the timeout. Operating system timeouts may still apply. |
| [deadline](deadline.md)<br>(JVM) | `fun deadline(duration: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, unit: `[`TimeUnit`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)`): `[`Timeout`](./index.md)<br>Set a deadline of now plus `duration` time. |
| [deadlineNanoTime](deadline-nano-time.md)<br>(JVM) | `open fun deadlineNanoTime(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime()) when the deadline will be reached.`open fun deadlineNanoTime(deadlineNanoTime: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Timeout`](./index.md)<br>Sets the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime()) when the deadline will be reached. All operations must complete before this time. Use a deadline to set a maximum bound on the time spent on a sequence of operations. |
| [hasDeadline](has-deadline.md)<br>(JVM) | `open fun hasDeadline(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if a deadline is enabled. |
| [intersectWith](intersect-with.md)<br>(JVM) | `fun intersectWith(other: `[`Timeout`](./index.md)`, block: () -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Applies the minimum intersection between this timeout and `other`, run `block`, then finally rollback this timeout's values. |
| [throwIfReached](throw-if-reached.md)<br>(JVM) | `open fun throwIfReached(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Throws an [InterruptedIOException](https://docs.oracle.com/javase/8/docs/api/java/io/InterruptedIOException.html) if the deadline has been reached or if the current thread has been interrupted. This method doesn't detect timeouts; that should be implemented to asynchronously abort an in-progress operation. |
| [timeout](timeout.md)<br>(JVM) | `open fun timeout(timeout: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, unit: `[`TimeUnit`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)`): `[`Timeout`](./index.md)<br>Wait at most `timeout` time before aborting an operation. Using a per-operation timeout means that as long as forward progress is being made, no sequence of operations will fail. |
| [timeoutNanos](timeout-nanos.md)<br>(JVM) | `open fun timeoutNanos(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the timeout in nanoseconds, or `0` for no timeout. |
| [waitUntilNotified](wait-until-notified.md)<br>(JVM) | `fun waitUntilNotified(monitor: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Waits on `monitor` until it is notified. Throws [InterruptedIOException](https://docs.oracle.com/javase/8/docs/api/java/io/InterruptedIOException.html) if either the thread is interrupted or if this timeout elapses before `monitor` is notified. The caller must be synchronized on `monitor`. |

### Companion Object Properties

| Name | Summary |
|---|---|
| [NONE](-n-o-n-e.md) | `val NONE: `[`Timeout`](./index.md)<br>An empty timeout that neither tracks nor detects timeouts. Use this when timeouts aren't necessary, such as in implementations whose operations do not block. |

### Companion Object Functions

| Name | Summary |
|---|---|
| [minTimeout](min-timeout.md)<br>(JVM) | `fun minTimeout(aNanos: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, bNanos: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |

### Inheritors

| Name | Summary |
|---|---|
| [AsyncTimeout](../-async-timeout/index.md)<br>(JVM) | `open class AsyncTimeout : `[`Timeout`](./index.md)<br>This timeout uses a background thread to take action exactly when the timeout occurs. Use this to implement timeouts where they aren't supported natively, such as to sockets that are blocked on writing. |
| [ForwardingTimeout](../-forwarding-timeout/index.md)<br>(JVM) | `open class ForwardingTimeout : `[`Timeout`](./index.md)<br>A [Timeout](./index.md) which forwards calls to another. Useful for subclassing. |
