[okio](../index.md) / [okio](./index.md)

## Package okio

### Types

| Name | Summary |
|---|---|
| [AsyncTimeout](-async-timeout/index.md)<br>(JVM) | `open class AsyncTimeout : `[`Timeout`](-timeout/index.md)<br>This timeout uses a background thread to take action exactly when the timeout occurs. Use this to implement timeouts where they aren't supported natively, such as to sockets that are blocked on writing. |
| [Buffer](-buffer/index.md)<br>(JVM, js, native) | `expect class Buffer : `[`BufferedSource`](-buffered-source/index.md)`, `[`BufferedSink`](-buffered-sink/index.md)<br>A collection of bytes in memory. |
| [BufferedSink](-buffered-sink/index.md)<br>(JVM, js, native) | `expect interface BufferedSink : `[`Sink`](-sink/index.md)<br>A sink that keeps a buffer internally so that callers can do small writes without a performance penalty. |
| [BufferedSource](-buffered-source/index.md)<br>(JVM, js, native) | `expect interface BufferedSource : `[`Source`](-source/index.md)<br>A source that keeps a buffer internally so that callers can do small reads without a performance penalty. It also allows clients to read ahead, buffering as much as necessary before consuming input. |
| [ByteString](-byte-string/index.md)<br>(JVM, js, native) | `open expect class ByteString : `[`Comparable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)`<`[`ByteString`](-byte-string/index.md)`>`<br>An immutable sequence of bytes. |
| [DeflaterSink](-deflater-sink/index.md)<br>(JVM) | `class DeflaterSink : `[`Sink`](-sink/index.md)<br>A sink that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to compress data written to another source. |
| [ForwardingSink](-forwarding-sink/index.md)<br>(JVM) | `abstract class ForwardingSink : `[`Sink`](-sink/index.md)<br>A [Sink](-sink/index.md) which forwards calls to another. Useful for subclassing. |
| [ForwardingSource](-forwarding-source/index.md)<br>(JVM) | `abstract class ForwardingSource : `[`Source`](-source/index.md)<br>A [Source](-source/index.md) which forwards calls to another. Useful for subclassing. |
| [ForwardingTimeout](-forwarding-timeout/index.md)<br>(JVM) | `open class ForwardingTimeout : `[`Timeout`](-timeout/index.md)<br>A [Timeout](-timeout/index.md) which forwards calls to another. Useful for subclassing. |
| [GzipSink](-gzip-sink/index.md)<br>(JVM) | `class GzipSink : `[`Sink`](-sink/index.md)<br>A sink that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to compress written data to another sink. |
| [GzipSource](-gzip-source/index.md)<br>(JVM) | `class GzipSource : `[`Source`](-source/index.md)<br>A source that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to decompress data read from another source. |
| [HashingSink](-hashing-sink/index.md)<br>(JVM) | `class HashingSink : `[`ForwardingSink`](-forwarding-sink/index.md)<br>A sink that computes a hash of the full stream of bytes it has accepted. To use, create an instance with your preferred hash algorithm. Write all of the data to the sink and then call [hash](#) to compute the final hash value. |
| [HashingSource](-hashing-source/index.md)<br>(JVM) | `class HashingSource : `[`ForwardingSource`](-forwarding-source/index.md)<br>A source that computes a hash of the full stream of bytes it has supplied. To use, create an instance with your preferred hash algorithm. Exhaust the source by reading all of its bytes and then call [hash](#) to compute the final hash value. |
| [InflaterSource](-inflater-source/index.md)<br>(JVM) | `class InflaterSource : `[`Source`](-source/index.md)<br>A source that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to decompress data read from another source. |
| [Options](-options/index.md) | `class Options`<br>An indexed set of values that may be read with [BufferedSource.select](-buffered-source/select.md). |
| [Pipe](-pipe/index.md)<br>(JVM) | `class Pipe`<br>A source and a sink that are attached. The sink's output is the source's input. Typically each is accessed by its own thread: a producer thread writes data to the sink and a consumer thread reads data from the source. |
| [Sink](-sink/index.md)<br>(JVM, js, native) | `expect interface Sink`<br>Receives a stream of bytes. Use this interface to write data wherever it's needed: to the network, storage, or a buffer in memory. Sinks may be layered to transform received data, such as to compress, encrypt, throttle, or add protocol framing. |
| [Source](-source/index.md)<br>(JVM, js, native) | `expect interface Source`<br>Supplies a stream of bytes. Use this interface to read data from wherever it's located: from the network, storage, or a buffer in memory. Sources may be layered to transform supplied data, such as to decompress, decrypt, or remove protocol framing. |
| [Throttler](-throttler/index.md)<br>(JVM) | `class Throttler`<br>Enables limiting of Source and Sink throughput. Attach to this throttler via [source](-throttler/source.md) and [sink](-throttler/sink.md) and set the desired throughput via [bytesPerSecond](-throttler/bytes-per-second.md). Multiple Sources and Sinks can be attached to a single Throttler and they will be throttled as a group, where their combined throughput will not exceed the desired throughput. The same Source or Sink can be attached to multiple Throttlers and its throughput will not exceed the desired throughput of any of the Throttlers. |
| [Timeout](-timeout/index.md)<br>(JVM, js, native) | `open expect class Timeout`<br>A policy on how much time to spend on a task before giving up. When a task times out, it is left in an unspecified state and should be abandoned. For example, if reading from a source times out, that source should be closed and the read should be retried later. If writing to a sink times out, the same rules apply: close the sink and retry later. |

### Exceptions

| Name | Summary |
|---|---|
| [ArrayIndexOutOfBoundsException](-array-index-out-of-bounds-exception/index.md)<br>(JVM, js, native) | `expect class ArrayIndexOutOfBoundsException : `[`IndexOutOfBoundsException`](https://docs.oracle.com/javase/8/docs/api/java/lang/IndexOutOfBoundsException.html) |
| [EOFException](-e-o-f-exception/index.md)<br>(JVM, js, native) | `open expect class EOFException : `[`IOException`](-i-o-exception/index.md) |
| [IOException](-i-o-exception/index.md)<br>(JVM, js, native) | `open expect class IOException : `[`Exception`](https://docs.oracle.com/javase/8/docs/api/java/lang/Exception.html) |

### Extensions for External Classes

| Name | Summary |
|---|---|
| [java.io.File](java.io.-file/index.md) |  |
| [java.io.InputStream](java.io.-input-stream/index.md) |  |
| [java.io.OutputStream](java.io.-output-stream/index.md) |  |
| [java.net.Socket](java.net.-socket/index.md) |  |
| [java.nio.file.Path](java.nio.file.-path/index.md) |  |
| [kotlin.String](kotlin.-string/index.md) |  |

### Properties

| Name | Summary |
|---|---|
| [Okio](-okio.md)<br>(JVM) | `val Okio: -DeprecatedOkio` |
| [Utf8](-utf8.md)<br>(JVM) | `val Utf8: -DeprecatedUtf8` |

### Functions

| Name | Summary |
|---|---|
| [blackholeSink](blackhole-sink.md)<br>(JVM, js, native) | `expect fun blackholeSink(): `[`Sink`](-sink/index.md)<br>Returns a sink that writes nowhere. |
| [buffer](buffer.md)<br>(JVM, js, native) | `expect fun `[`Source`](-source/index.md)`.buffer(): `[`BufferedSource`](-buffered-source/index.md)<br>Returns a new source that buffers reads from `source`. The returned source will perform bulk reads into its in-memory buffer. Use this wherever you read a source to get an ergonomic and efficient access to data.`expect fun `[`Sink`](-sink/index.md)`.buffer(): `[`BufferedSink`](-buffered-sink/index.md)<br>Returns a new sink that buffers writes to `sink`. The returned sink will batch writes to `sink`. Use this wherever you write to a sink to get an ergonomic and efficient access to data. |
| [deflate](deflate.md)<br>(JVM) | `fun `[`Sink`](-sink/index.md)`.deflate(deflater: `[`Deflater`](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html)` = Deflater()): `[`DeflaterSink`](-deflater-sink/index.md)<br>Returns an [DeflaterSink](-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](-sink/index.md) while writing. |
| [gzip](gzip.md)<br>(JVM) | `fun `[`Sink`](-sink/index.md)`.gzip(): `[`GzipSink`](-gzip-sink/index.md)<br>Returns a [GzipSink](-gzip-sink/index.md) that gzip-compresses to this [Sink](-sink/index.md) while writing.`fun `[`Source`](-source/index.md)`.gzip(): `[`GzipSource`](-gzip-source/index.md)<br>Returns a [GzipSource](-gzip-source/index.md) that gzip-decompresses this [Source](-source/index.md) while reading. |
| [inflate](inflate.md)<br>(JVM) | `fun `[`Source`](-source/index.md)`.inflate(inflater: `[`Inflater`](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html)` = Inflater()): `[`InflaterSource`](-inflater-source/index.md)<br>Returns an [InflaterSource](-inflater-source/index.md) that DEFLATE-decompresses this [Source](-source/index.md) while reading. |
