[okio](../../index.md) / [okio](../index.md) / [Buffer](index.md) / [write](./write.md)

# write

`fun write(byteString: `[`ByteString`](../-byte-string/index.md)`): `[`Buffer`](index.md)

Overrides [BufferedSink.write](../-buffered-sink/write.md)

**Platform and version requirements:** JVM, js, native


`fun write(source: `[`ByteBuffer`](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)

**Platform and version requirements:** JVM


`fun write(source: `[`Buffer`](index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)

Overrides [Sink.write](../-sink/write.md)

**Platform and version requirements:** JVM, js, native

`fun write(source: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`Buffer`](index.md)

Overrides [BufferedSink.write](../-buffered-sink/write.md)

**Platform and version requirements:** JVM, js, native

Like [OutputStream.write](#), this writes a complete byte array to this sink.

`fun write(source: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](index.md)

Overrides [BufferedSink.write](../-buffered-sink/write.md)

**Platform and version requirements:** JVM, js, native

Like [OutputStream.write](#), this writes `byteCount` bytes of `source`, starting at `offset`.

`fun write(source: `[`Source`](../-source/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Buffer`](index.md)

Overrides [BufferedSink.write](../-buffered-sink/write.md)

**Platform and version requirements:** JVM, js, native

Removes `byteCount` bytes from `source` and appends them to this sink.

