[okio](../../index.md) / [okio](../index.md) / [BufferedSink](./index.md)

# BufferedSink

`expect interface BufferedSink : `[`Sink`](../-sink/index.md)

**Platform and version requirements:** JVM, js, native

A sink that keeps a buffer internally so that callers can do small writes without a performance
penalty.

### Properties

| Name | Summary |
|---|---|
| [buffer](buffer.md) | `abstract val buffer: `[`Buffer`](../-buffer/index.md)<br>This sink's internal buffer. |

### Functions

| Name | Summary |
|---|---|
| [emit](emit.md) | `abstract fun emit(): `[`BufferedSink`](./index.md)<br>Writes all buffered data to the underlying sink, if one exists. Like [flush](flush.md), but weaker. Call this before this buffered sink goes out of scope so that its data can reach its destination. |
| [emitCompleteSegments](emit-complete-segments.md) | `abstract fun emitCompleteSegments(): `[`BufferedSink`](./index.md)<br>Writes complete segments to the underlying sink, if one exists. Like [flush](flush.md), but weaker. Use this to limit the memory held in the buffer to a single segment. Typically application code will not need to call this: it is only necessary when application code writes directly to this [sink's buffer](../buffer.md). |
| [flush](flush.md) | `abstract fun flush(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Writes all buffered data to the underlying sink, if one exists. Then that sink is recursively flushed which pushes data as far as possible towards its ultimate destination. Typically that destination is a network socket or file. |
| [outputStream](output-stream.md)<br>(JVM) | `abstract fun outputStream(): `[`OutputStream`](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)<br>Returns an output stream that writes to this sink. |
| [write](write.md) | `abstract fun write(byteString: `[`ByteString`](../-byte-string/index.md)`): `[`BufferedSink`](./index.md)`abstract fun write(source: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`BufferedSink`](./index.md)<br>Like [OutputStream.write](#), this writes a complete byte array to this sink.`abstract fun write(source: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](./index.md)<br>Like [OutputStream.write](#), this writes `byteCount` bytes of `source`, starting at `offset`.`abstract fun write(source: `[`Source`](../-source/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`BufferedSink`](./index.md)<br>Removes `byteCount` bytes from `source` and appends them to this sink. |
| [writeAll](write-all.md) | `abstract fun writeAll(source: `[`Source`](../-source/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes all bytes from `source` and appends them to this sink. Returns the number of bytes read which will be 0 if `source` is exhausted. |
| [writeByte](write-byte.md) | `abstract fun writeByte(b: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](./index.md)<br>Writes a byte to this sink. |
| [writeDecimalLong](write-decimal-long.md) | `abstract fun writeDecimalLong(v: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`BufferedSink`](./index.md)<br>Writes a long to this sink in signed decimal form (i.e., as a string in base 10). |
| [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md) | `abstract fun writeHexadecimalUnsignedLong(v: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`BufferedSink`](./index.md)<br>Writes a long to this sink in hexadecimal form (i.e., as a string in base 16). |
| [writeInt](write-int.md) | `abstract fun writeInt(i: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](./index.md)<br>Writes a big-endian int to this sink using four bytes. |
| [writeIntLe](write-int-le.md) | `abstract fun writeIntLe(i: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](./index.md)<br>Writes a little-endian int to this sink using four bytes. |
| [writeLong](write-long.md) | `abstract fun writeLong(v: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`BufferedSink`](./index.md)<br>Writes a big-endian long to this sink using eight bytes. |
| [writeLongLe](write-long-le.md) | `abstract fun writeLongLe(v: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`BufferedSink`](./index.md)<br>Writes a little-endian long to this sink using eight bytes. |
| [writeShort](write-short.md) | `abstract fun writeShort(s: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](./index.md)<br>Writes a big-endian short to this sink using two bytes. |
| [writeShortLe](write-short-le.md) | `abstract fun writeShortLe(s: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](./index.md)<br>Writes a little-endian short to this sink using two bytes. |
| [writeString](write-string.md)<br>(JVM) | `abstract fun writeString(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, charset: `[`Charset`](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)`): `[`BufferedSink`](./index.md)<br>`abstract fun writeString(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, beginIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, endIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, charset: `[`Charset`](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)`): `[`BufferedSink`](./index.md) |
| [writeUtf8](write-utf8.md) | `abstract fun writeUtf8(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`BufferedSink`](./index.md)<br>Encodes `string` in UTF-8 and writes it to this sink.`abstract fun writeUtf8(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, beginIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, endIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](./index.md)<br>Encodes the characters at `beginIndex` up to `endIndex` from `string` in UTF-8 and writes it to this sink. |
| [writeUtf8CodePoint](write-utf8-code-point.md) | `abstract fun writeUtf8CodePoint(codePoint: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](./index.md)<br>Encodes `codePoint` in UTF-8 and writes it to this sink. |

### Inherited Functions

| Name | Summary |
|---|---|
| [close](../-sink/close.md)<br>(JVM, js, native) | `abstract fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Pushes all buffered bytes to their final destination and releases the resources held by this sink. It is an error to write a closed sink. It is safe to close a sink more than once. |
| [timeout](../-sink/timeout.md)<br>(JVM, js, native) | `abstract fun timeout(): `[`Timeout`](../-timeout/index.md)<br>Returns the timeout for this sink. |
| [write](../-sink/write.md)<br>(JVM, js, native) | `abstract fun write(source: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Removes `byteCount` bytes from `source` and appends them to this. |

### Extension Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md)<br>(JVM, js, native) | `expect fun `[`Sink`](../-sink/index.md)`.buffer(): `[`BufferedSink`](./index.md)<br>Returns a new sink that buffers writes to `sink`. The returned sink will batch writes to `sink`. Use this wherever you write to a sink to get an ergonomic and efficient access to data. |
| [deflate](../deflate.md)<br>(JVM) | `fun `[`Sink`](../-sink/index.md)`.deflate(deflater: `[`Deflater`](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html)` = Deflater()): `[`DeflaterSink`](../-deflater-sink/index.md)<br>Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](../-sink/index.md) while writing. |
| [gzip](../gzip.md)<br>(JVM) | `fun `[`Sink`](../-sink/index.md)`.gzip(): `[`GzipSink`](../-gzip-sink/index.md)<br>Returns a [GzipSink](../-gzip-sink/index.md) that gzip-compresses to this [Sink](../-sink/index.md) while writing. |

### Inheritors

| Name | Summary |
|---|---|
| [Buffer](../-buffer/index.md)<br>(JVM, js, native) | `expect class Buffer : `[`BufferedSource`](../-buffered-source/index.md)`, `[`BufferedSink`](./index.md)<br>A collection of bytes in memory. |
