[okio](../../index.md) / [okio](../index.md) / [BufferedSink](index.md) / [writeShort](./write-short.md)

# writeShort

`abstract fun writeShort(s: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](index.md)

**Platform and version requirements:** JVM, js, native

Writes a big-endian short to this sink using two bytes.

```
Buffer buffer = new Buffer();
buffer.writeShort(32767);
buffer.writeShort(15);

assertEquals(4, buffer.size());
assertEquals((byte) 0x7f, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x0f, buffer.readByte());
assertEquals(0, buffer.size());
```

