[okio](../../index.md) / [okio](../index.md) / [BufferedSource](./index.md)

# BufferedSource

`expect interface BufferedSource : `[`Source`](../-source/index.md)

**Platform and version requirements:** JVM, js, native

A source that keeps a buffer internally so that callers can do small reads without a performance
penalty. It also allows clients to read ahead, buffering as much as necessary before consuming
input.

### Properties

| Name | Summary |
|---|---|
| [buffer](buffer.md) | `abstract val buffer: `[`Buffer`](../-buffer/index.md)<br>This source's internal buffer. |

### Functions

| Name | Summary |
|---|---|
| [exhausted](exhausted.md) | `abstract fun exhausted(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if there are no more bytes in this source. This will block until there are bytes to read or the source is definitely exhausted. |
| [indexOf](index-of.md) | `abstract fun indexOf(b: `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOf(b, 0)](index-of.md).`abstract fun indexOf(b: `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)`, fromIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of the first `b` in the buffer at or after `fromIndex`. This expands the buffer as necessary until `b` is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested byte is found.`abstract fun indexOf(b: `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)`, fromIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, toIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of `b` if it is found in the range of `fromIndex` inclusive to `toIndex` exclusive. If `b` isn't found, or if `fromIndex == toIndex`, then -1 is returned.`abstract fun indexOf(bytes: `[`ByteString`](../-byte-string/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOf(bytes, 0)](index-of.md).`abstract fun indexOf(bytes: `[`ByteString`](../-byte-string/index.md)`, fromIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of the first match for `bytes` in the buffer at or after `fromIndex`. This expands the buffer as necessary until `bytes` is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested bytes are found. |
| [indexOfElement](index-of-element.md) | `abstract fun indexOfElement(targetBytes: `[`ByteString`](../-byte-string/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOfElement(targetBytes, 0)](index-of-element.md).`abstract fun indexOfElement(targetBytes: `[`ByteString`](../-byte-string/index.md)`, fromIndex: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the first index in this buffer that is at or after `fromIndex` and that contains any of the bytes in `targetBytes`. This expands the buffer as necessary until a target byte is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested byte is found. |
| [inputStream](input-stream.md)<br>(JVM) | `abstract fun inputStream(): `[`InputStream`](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)<br>Returns an input stream that reads from this source. |
| [peek](peek.md) | `abstract fun peek(): `[`BufferedSource`](./index.md)<br>Returns a new `BufferedSource` that can read data from this `BufferedSource` without consuming it. The returned source becomes invalid once this source is next read or closed. |
| [rangeEquals](range-equals.md) | `abstract fun rangeEquals(offset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, bytes: `[`ByteString`](../-byte-string/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if the bytes at `offset` in this source equal `bytes`. This expands the buffer as necessary until a byte does not match, all bytes are matched, or if the stream is exhausted before enough bytes could determine a match.`abstract fun rangeEquals(offset: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, bytes: `[`ByteString`](../-byte-string/index.md)`, bytesOffset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if `byteCount` bytes at `offset` in this source equal `bytes` at `bytesOffset`. This expands the buffer as necessary until a byte does not match, all bytes are matched, or if the stream is exhausted before enough bytes could determine a match. |
| [read](read.md) | `abstract fun read(sink: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes up to `sink.length` bytes from this and copies them into `sink`. Returns the number of bytes read, or -1 if this source is exhausted.`abstract fun read(sink: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes up to `byteCount` bytes from this and copies them into `sink` at `offset`. Returns the number of bytes read, or -1 if this source is exhausted. |
| [readAll](read-all.md) | `abstract fun readAll(sink: `[`Sink`](../-sink/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes all bytes from this and appends them to `sink`. Returns the total number of bytes written to `sink` which will be 0 if this is exhausted. |
| [readByte](read-byte.md) | `abstract fun readByte(): `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)<br>Removes a byte from this source and returns it. |
| [readByteArray](read-byte-array.md) | `abstract fun readByteArray(): `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Removes all bytes from this and returns them as a byte array.`abstract fun readByteArray(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Removes `byteCount` bytes from this and returns them as a byte array. |
| [readByteString](read-byte-string.md) | `abstract fun readByteString(): `[`ByteString`](../-byte-string/index.md)<br>Removes all bytes bytes from this and returns them as a byte string.`abstract fun readByteString(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`ByteString`](../-byte-string/index.md)<br>Removes `byteCount` bytes from this and returns them as a byte string. |
| [readDecimalLong](read-decimal-long.md) | `abstract fun readDecimalLong(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Reads a long from this source in signed decimal form (i.e., as a string in base 10 with optional leading '-'). This will iterate until a non-digit character is found. |
| [readFully](read-fully.md) | `abstract fun readFully(sink: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Removes exactly `sink.length` bytes from this and copies them into `sink`. Throws an [java.io.EOFException](https://docs.oracle.com/javase/8/docs/api/java/io/EOFException.html) if the requested number of bytes cannot be read.`abstract fun readFully(sink: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Removes exactly `byteCount` bytes from this and appends them to `sink`. Throws an [java.io.EOFException](https://docs.oracle.com/javase/8/docs/api/java/io/EOFException.html) if the requested number of bytes cannot be read. |
| [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md) | `abstract fun readHexadecimalUnsignedLong(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Reads a long form this source in hexadecimal form (i.e., as a string in base 16). This will iterate until a non-hexadecimal character is found. |
| [readInt](read-int.md) | `abstract fun readInt(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes four bytes from this source and returns a big-endian int. |
| [readIntLe](read-int-le.md) | `abstract fun readIntLe(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes four bytes from this source and returns a little-endian int. |
| [readLong](read-long.md) | `abstract fun readLong(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes eight bytes from this source and returns a big-endian long. |
| [readLongLe](read-long-le.md) | `abstract fun readLongLe(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes eight bytes from this source and returns a little-endian long. |
| [readShort](read-short.md) | `abstract fun readShort(): `[`Short`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)<br>Removes two bytes from this source and returns a big-endian short. |
| [readShortLe](read-short-le.md) | `abstract fun readShortLe(): `[`Short`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)<br>Removes two bytes from this source and returns a little-endian short. |
| [readString](read-string.md)<br>(JVM) | `abstract fun readString(charset: `[`Charset`](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes all bytes from this, decodes them as `charset`, and returns the string.`abstract fun readString(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, charset: `[`Charset`](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes `byteCount` bytes from this, decodes them as `charset`, and returns the string. |
| [readUtf8](read-utf8.md) | `abstract fun readUtf8(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes all bytes from this, decodes them as UTF-8, and returns the string. Returns the empty string if this source is empty.`abstract fun readUtf8(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes `byteCount` bytes from this, decodes them as UTF-8, and returns the string. |
| [readUtf8CodePoint](read-utf8-code-point.md) | `abstract fun readUtf8CodePoint(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes and returns a single UTF-8 code point, reading between 1 and 4 bytes as necessary. |
| [readUtf8Line](read-utf8-line.md) | `abstract fun readUtf8Line(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?`<br>Removes and returns characters up to but not including the next line break. A line break is either `"\n"` or `"\r\n"`; these characters are not included in the result. |
| [readUtf8LineStrict](read-utf8-line-strict.md) | `abstract fun readUtf8LineStrict(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes and returns characters up to but not including the next line break. A line break is either `"\n"` or `"\r\n"`; these characters are not included in the result.`abstract fun readUtf8LineStrict(limit: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Like [readUtf8LineStrict](read-utf8-line-strict.md), except this allows the caller to specify the longest allowed match. Use this to protect against streams that may not include `"\n"` or `"\r\n"`. |
| [request](request.md) | `abstract fun request(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true when the buffer contains at least `byteCount` bytes, expanding it as necessary. Returns false if the source is exhausted before the requested bytes can be read. |
| [require](require.md) | `abstract fun require(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Returns when the buffer contains at least `byteCount` bytes. Throws an [java.io.EOFException](https://docs.oracle.com/javase/8/docs/api/java/io/EOFException.html) if the source is exhausted before the required bytes can be read. |
| [select](select.md) | `abstract fun select(options: `[`Options`](../-options/index.md)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Finds the first string in `options` that is a prefix of this buffer, consumes it from this buffer, and returns its index. If no byte string in `options` is a prefix of this buffer this returns -1 and no bytes are consumed.`abstract actual fun select(options: <ERROR CLASS>): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [skip](skip.md) | `abstract fun skip(byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Reads and discards `byteCount` bytes from this source. Throws an [java.io.EOFException](https://docs.oracle.com/javase/8/docs/api/java/io/EOFException.html) if the source is exhausted before the requested bytes can be skipped. |

### Inherited Functions

| Name | Summary |
|---|---|
| [close](../-source/close.md)<br>(JVM, js, native) | `abstract fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Closes this source and releases the resources held by this source. It is an error to read a closed source. It is safe to close a source more than once. |
| [read](../-source/read.md)<br>(JVM, js, native) | `abstract fun read(sink: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes at least 1, and up to `byteCount` bytes from this and appends them to `sink`. Returns the number of bytes read, or -1 if this source is exhausted. |
| [timeout](../-source/timeout.md)<br>(JVM, js, native) | `abstract fun timeout(): `[`Timeout`](../-timeout/index.md)<br>Returns the timeout for this source. |

### Extension Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md)<br>(JVM, js, native) | `expect fun `[`Source`](../-source/index.md)`.buffer(): `[`BufferedSource`](./index.md)<br>Returns a new source that buffers reads from `source`. The returned source will perform bulk reads into its in-memory buffer. Use this wherever you read a source to get an ergonomic and efficient access to data. |
| [gzip](../gzip.md)<br>(JVM) | `fun `[`Source`](../-source/index.md)`.gzip(): `[`GzipSource`](../-gzip-source/index.md)<br>Returns a [GzipSource](../-gzip-source/index.md) that gzip-decompresses this [Source](../-source/index.md) while reading. |
| [inflate](../inflate.md)<br>(JVM) | `fun `[`Source`](../-source/index.md)`.inflate(inflater: `[`Inflater`](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html)` = Inflater()): `[`InflaterSource`](../-inflater-source/index.md)<br>Returns an [InflaterSource](../-inflater-source/index.md) that DEFLATE-decompresses this [Source](../-source/index.md) while reading. |

### Inheritors

| Name | Summary |
|---|---|
| [Buffer](../-buffer/index.md)<br>(JVM, js, native) | `expect class Buffer : `[`BufferedSource`](./index.md)`, `[`BufferedSink`](../-buffered-sink/index.md)<br>A collection of bytes in memory. |
