[okio](../../index.md) / [okio](../index.md) / [ByteString](./index.md)

# ByteString

`open expect class ByteString : `[`Comparable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)`<`[`ByteString`](./index.md)`>`

**Platform and version requirements:** JVM, js, native

An immutable sequence of bytes.

Byte strings compare lexicographically as a sequence of **unsigned** bytes. That is, the byte
string `ff` sorts after `00`. This is counter to the sort order of the corresponding bytes,
where `-1` sorts before `0`.

**Full disclosure:** this class provides untrusted input and output streams with raw access to
the underlying byte array. A hostile stream implementation could keep a reference to the mutable
byte string, violating the immutable guarantee of this class. For this reason a byte string's
immutability guarantee cannot be relied upon for security in applets and other environments that
run both trusted and untrusted code in the same process.

### Properties

| Name | Summary |
|---|---|
| [size](size.md) | `val size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Returns the number of bytes in this ByteString. |

### Functions

| Name | Summary |
|---|---|
| [asByteBuffer](as-byte-buffer.md)<br>(JVM) | `open fun asByteBuffer(): `[`ByteBuffer`](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)<br>Returns a `ByteBuffer` view of the bytes in this `ByteString`. |
| [base64](base64.md) | `fun base64(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns this byte string encoded as [Base64](http://www.ietf.org/rfc/rfc2045.txt). In violation of the RFC, the returned string does not wrap lines at 76 columns. |
| [base64Url](base64-url.md) | `fun base64Url(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns this byte string encoded as [URL-safe Base64](http://www.ietf.org/rfc/rfc4648.txt). |
| [compareTo](compare-to.md) | `open fun compareTo(other: `[`ByteString`](./index.md)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [endsWith](ends-with.md) | `fun endsWith(suffix: `[`ByteString`](./index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>`fun endsWith(suffix: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [equals](equals.md) | `open fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [get](get.md) | `operator fun get(index: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)<br>Returns the byte at `index`. |
| [hashCode](hash-code.md) | `open fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [hex](hex.md) | `fun hex(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns this byte string encoded in hexadecimal. |
| [hmacSha1](hmac-sha1.md)<br>(JVM) | `open fun hmacSha1(key: `[`ByteString`](./index.md)`): `[`ByteString`](./index.md)<br>Returns the 160-bit SHA-1 HMAC of this byte string. |
| [hmacSha256](hmac-sha256.md)<br>(JVM) | `open fun hmacSha256(key: `[`ByteString`](./index.md)`): `[`ByteString`](./index.md)<br>Returns the 256-bit SHA-256 HMAC of this byte string. |
| [hmacSha512](hmac-sha512.md)<br>(JVM) | `open fun hmacSha512(key: `[`ByteString`](./index.md)`): `[`ByteString`](./index.md)<br>Returns the 512-bit SHA-512 HMAC of this byte string. |
| [indexOf](index-of.md) | `fun indexOf(other: `[`ByteString`](./index.md)`, fromIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 0): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>`fun indexOf(other: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, fromIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 0): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [lastIndexOf](last-index-of.md) | `fun lastIndexOf(other: `[`ByteString`](./index.md)`, fromIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = size): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>`fun lastIndexOf(other: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, fromIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = size): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [md5](md5.md)<br>(JVM) | `open fun md5(): `[`ByteString`](./index.md)<br>Returns the 128-bit MD5 hash of this byte string. |
| [rangeEquals](range-equals.md) | `fun rangeEquals(offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, other: `[`ByteString`](./index.md)`, otherOffset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>`fun rangeEquals(offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, other: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, otherOffset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if the bytes of this in `[offset..offset+byteCount)` equal the bytes of `other` in `[otherOffset..otherOffset+byteCount)`. Returns false if either range is out of bounds. |
| [sha1](sha1.md)<br>(JVM) | `open fun sha1(): `[`ByteString`](./index.md)<br>Returns the 160-bit SHA-1 hash of this byte string. |
| [sha256](sha256.md)<br>(JVM) | `open fun sha256(): `[`ByteString`](./index.md)<br>Returns the 256-bit SHA-256 hash of this byte string. |
| [sha512](sha512.md)<br>(JVM) | `open fun sha512(): `[`ByteString`](./index.md)<br>Returns the 512-bit SHA-512 hash of this byte string. |
| [startsWith](starts-with.md) | `fun startsWith(prefix: `[`ByteString`](./index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>`fun startsWith(prefix: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [string](string.md)<br>(JVM) | `open fun string(charset: `[`Charset`](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Constructs a new `String` by decoding the bytes using `charset`. |
| [substring](substring.md) | `fun substring(beginIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 0, endIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = size): `[`ByteString`](./index.md)<br>Returns a byte string that is a substring of this byte string, beginning at the specified `beginIndex` and ends at the specified `endIndex`. Returns this byte string if `beginIndex` is 0 and `endIndex` is the length of this byte string. |
| [toAsciiLowercase](to-ascii-lowercase.md) | `fun toAsciiLowercase(): `[`ByteString`](./index.md)<br>Returns a byte string equal to this byte string, but with the bytes 'A' through 'Z' replaced with the corresponding byte in 'a' through 'z'. Returns this byte string if it contains no bytes in 'A' through 'Z'. |
| [toAsciiUppercase](to-ascii-uppercase.md) | `fun toAsciiUppercase(): `[`ByteString`](./index.md)<br>Returns a byte string equal to this byte string, but with the bytes 'a' through 'z' replaced with the corresponding byte in 'A' through 'Z'. Returns this byte string if it contains no bytes in 'a' through 'z'. |
| [toByteArray](to-byte-array.md) | `fun toByteArray(): `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Returns a byte array containing a copy of the bytes in this `ByteString`. |
| [toString](to-string.md) | `open fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns a human-readable string that describes the contents of this byte string. Typically this is a string like `[text=Hello]` or `[hex=0000ffff]`. |
| [utf8](utf8.md) | `fun utf8(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Constructs a new `String` by decoding the bytes as `UTF-8`. |
| [write](write.md)<br>(JVM) | `open fun write(out: `[`OutputStream`](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Writes the contents of this byte string to `out`. |

### Companion Object Properties

| Name | Summary |
|---|---|
| [EMPTY](-e-m-p-t-y.md) | `val EMPTY: `[`ByteString`](./index.md)<br>A singleton empty `ByteString`. |

### Companion Object Functions

| Name | Summary |
|---|---|
| [decodeBase64](decode-base64.md) | `fun `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`.decodeBase64(): `[`ByteString`](./index.md)`?`<br>Decodes the Base64-encoded bytes and returns their value as a byte string. Returns null if this is not a Base64-encoded sequence of bytes. |
| [decodeHex](decode-hex.md) | `fun `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`.decodeHex(): `[`ByteString`](./index.md)<br>Decodes the hex-encoded bytes and returns their value a byte string. |
| [encode](encode.md)<br>(JVM) | `fun `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`.encode(charset: `[`Charset`](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)` = Charsets.UTF_8): `[`ByteString`](./index.md)<br>Returns a new [ByteString](./index.md) containing the `charset`-encoded bytes of this [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html). |
| [encodeUtf8](encode-utf8.md) | `fun `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`.encodeUtf8(): `[`ByteString`](./index.md)<br>Returns a new byte string containing the `UTF-8` bytes of this [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html). |
| [of](of.md) | `fun of(vararg data: `[`Byte`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)`): `[`ByteString`](./index.md)<br>Returns a new byte string containing a clone of the bytes of `data`. |
| [readByteString](read-byte-string.md)<br>(JVM) | `fun `[`InputStream`](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)`.readByteString(byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`ByteString`](./index.md)<br>Reads `count` bytes from this [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html) and returns the result. |
| [toByteString](to-byte-string.md)<br>(JVM) | `fun `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`.toByteString(offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 0, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = size): `[`ByteString`](./index.md)<br>Returns a new [ByteString](./index.md) containing a copy of `byteCount` bytes of this [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html) starting at `offset`.`fun `[`ByteBuffer`](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)`.toByteString(): `[`ByteString`](./index.md)<br>Returns a [ByteString](./index.md) containing a copy of this [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html). |
