[okio](../../index.md) / [okio](../index.md) / [ForwardingSource](./index.md)

# ForwardingSource

`abstract class ForwardingSource : `[`Source`](../-source/index.md)

**Platform and version requirements:** JVM

A [Source](../-source/index.md) which forwards calls to another. Useful for subclassing.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `ForwardingSource(delegate: `[`Source`](../-source/index.md)`)`<br>A [Source](../-source/index.md) which forwards calls to another. Useful for subclassing. |

### Properties

| Name | Summary |
|---|---|
| [delegate](delegate.md) | `val delegate: `[`Source`](../-source/index.md)<br>[Source](../-source/index.md) to which this instance is delegating. |

### Functions

| Name | Summary |
|---|---|
| [close](close.md) | `open fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [read](read.md) | `open fun read(sink: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [timeout](timeout.md) | `open fun timeout(): `[`Timeout`](../-timeout/index.md) |
| [toString](to-string.md) | `open fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Extension Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md)<br>(JVM, js, native) | `expect fun `[`Source`](../-source/index.md)`.buffer(): `[`BufferedSource`](../-buffered-source/index.md)<br>Returns a new source that buffers reads from `source`. The returned source will perform bulk reads into its in-memory buffer. Use this wherever you read a source to get an ergonomic and efficient access to data. |
| [gzip](../gzip.md)<br>(JVM) | `fun `[`Source`](../-source/index.md)`.gzip(): `[`GzipSource`](../-gzip-source/index.md)<br>Returns a [GzipSource](../-gzip-source/index.md) that gzip-decompresses this [Source](../-source/index.md) while reading. |
| [inflate](../inflate.md)<br>(JVM) | `fun `[`Source`](../-source/index.md)`.inflate(inflater: `[`Inflater`](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html)` = Inflater()): `[`InflaterSource`](../-inflater-source/index.md)<br>Returns an [InflaterSource](../-inflater-source/index.md) that DEFLATE-decompresses this [Source](../-source/index.md) while reading. |

### Inheritors

| Name | Summary |
|---|---|
| [HashingSource](../-hashing-source/index.md)<br>(JVM) | `class HashingSource : `[`ForwardingSource`](./index.md)<br>A source that computes a hash of the full stream of bytes it has supplied. To use, create an instance with your preferred hash algorithm. Exhaust the source by reading all of its bytes and then call [hash](#) to compute the final hash value. |
