[okio](../../index.md) / [okio](../index.md) / [GzipSink](./index.md)

# GzipSink

`class GzipSink : `[`Sink`](../-sink/index.md)

**Platform and version requirements:** JVM

A sink that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to
compress written data to another sink.

### Sync flush

Aggressive flushing of this stream may result in reduced compression. Each
call to [flush](flush.md) immediately compresses all currently-buffered data;
this early compression may be less effective than compression performed
without flushing.

This is equivalent to using [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html) with the sync flush option.
This class does not offer any partial flush mechanism. For best performance,
only call [flush](flush.md) when application behavior requires it.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `GzipSink(sink: `[`Sink`](../-sink/index.md)`)`<br>A sink that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to compress written data to another sink. |

### Properties

| Name | Summary |
|---|---|
| [deflater](deflater.md) | `val deflater: `[`Deflater`](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html)<br>The deflater used to compress the body. |

### Functions

| Name | Summary |
|---|---|
| [close](close.md) | `fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [flush](flush.md) | `fun flush(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [timeout](timeout.md) | `fun timeout(): `[`Timeout`](../-timeout/index.md) |
| [write](write.md) | `fun write(source: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Extension Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md)<br>(JVM, js, native) | `expect fun `[`Sink`](../-sink/index.md)`.buffer(): `[`BufferedSink`](../-buffered-sink/index.md)<br>Returns a new sink that buffers writes to `sink`. The returned sink will batch writes to `sink`. Use this wherever you write to a sink to get an ergonomic and efficient access to data. |
| [deflate](../deflate.md)<br>(JVM) | `fun `[`Sink`](../-sink/index.md)`.deflate(deflater: `[`Deflater`](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html)` = Deflater()): `[`DeflaterSink`](../-deflater-sink/index.md)<br>Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](../-sink/index.md) while writing. |
| [gzip](../gzip.md)<br>(JVM) | `fun `[`Sink`](../-sink/index.md)`.gzip(): `[`GzipSink`](./index.md)<br>Returns a [GzipSink](./index.md) that gzip-compresses to this [Sink](../-sink/index.md) while writing. |
