[okio](../../index.md) / [okio](../index.md) / [HashingSource](./index.md)

# HashingSource

`class HashingSource : `[`ForwardingSource`](../-forwarding-source/index.md)

**Platform and version requirements:** JVM

A source that computes a hash of the full stream of bytes it has supplied. To use, create an
instance with your preferred hash algorithm. Exhaust the source by reading all of its bytes and
then call [hash](#) to compute the final hash value.

In this example we use `HashingSource` with a [BufferedSource](../-buffered-source/index.md) to make reading
from the source easier.

```
HashingSource hashingSource = HashingSource.sha256(rawSource);
BufferedSource bufferedSource = Okio.buffer(hashingSource);

... // Read all of bufferedSource.

ByteString hash = hashingSource.hash();
```

### Properties

| Name | Summary |
|---|---|
| [hash](hash.md) | `val hash: `[`ByteString`](../-byte-string/index.md)<br>Returns the hash of the bytes supplied thus far and resets the internal state of this source. |

### Inherited Properties

| Name | Summary |
|---|---|
| [delegate](../-forwarding-source/delegate.md)<br>(JVM) | `val delegate: `[`Source`](../-source/index.md)<br>[Source](../-source/index.md) to which this instance is delegating. |

### Functions

| Name | Summary |
|---|---|
| [read](read.md) | `fun read(sink: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |

### Inherited Functions

| Name | Summary |
|---|---|
| [close](../-forwarding-source/close.md)<br>(JVM) | `open fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [timeout](../-forwarding-source/timeout.md)<br>(JVM) | `open fun timeout(): `[`Timeout`](../-timeout/index.md) |
| [toString](../-forwarding-source/to-string.md)<br>(JVM) | `open fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [hmacSha1](hmac-sha1.md) | `fun hmacSha1(source: `[`Source`](../-source/index.md)`, key: `[`ByteString`](../-byte-string/index.md)`): `[`HashingSource`](./index.md)<br>Returns a sink that uses the obsolete SHA-1 HMAC algorithm to produce 160-bit hashes. |
| [hmacSha256](hmac-sha256.md) | `fun hmacSha256(source: `[`Source`](../-source/index.md)`, key: `[`ByteString`](../-byte-string/index.md)`): `[`HashingSource`](./index.md)<br>Returns a sink that uses the SHA-256 HMAC algorithm to produce 256-bit hashes. |
| [hmacSha512](hmac-sha512.md) | `fun hmacSha512(source: `[`Source`](../-source/index.md)`, key: `[`ByteString`](../-byte-string/index.md)`): `[`HashingSource`](./index.md)<br>Returns a sink that uses the SHA-512 HMAC algorithm to produce 512-bit hashes. |
| [md5](md5.md) | `fun md5(source: `[`Source`](../-source/index.md)`): `[`HashingSource`](./index.md)<br>Returns a sink that uses the obsolete MD5 hash algorithm to produce 128-bit hashes. |
| [sha1](sha1.md) | `fun sha1(source: `[`Source`](../-source/index.md)`): `[`HashingSource`](./index.md)<br>Returns a sink that uses the obsolete SHA-1 hash algorithm to produce 160-bit hashes. |
| [sha256](sha256.md) | `fun sha256(source: `[`Source`](../-source/index.md)`): `[`HashingSource`](./index.md)<br>Returns a sink that uses the SHA-256 hash algorithm to produce 256-bit hashes. |
| [sha512](sha512.md) | `fun sha512(source: `[`Source`](../-source/index.md)`): `[`HashingSource`](./index.md)<br>Returns a sink that uses the SHA-512 hash algorithm to produce 512-bit hashes. |

### Extension Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md)<br>(JVM, js, native) | `expect fun `[`Source`](../-source/index.md)`.buffer(): `[`BufferedSource`](../-buffered-source/index.md)<br>Returns a new source that buffers reads from `source`. The returned source will perform bulk reads into its in-memory buffer. Use this wherever you read a source to get an ergonomic and efficient access to data. |
| [gzip](../gzip.md)<br>(JVM) | `fun `[`Source`](../-source/index.md)`.gzip(): `[`GzipSource`](../-gzip-source/index.md)<br>Returns a [GzipSource](../-gzip-source/index.md) that gzip-decompresses this [Source](../-source/index.md) while reading. |
| [inflate](../inflate.md)<br>(JVM) | `fun `[`Source`](../-source/index.md)`.inflate(inflater: `[`Inflater`](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html)` = Inflater()): `[`InflaterSource`](../-inflater-source/index.md)<br>Returns an [InflaterSource](../-inflater-source/index.md) that DEFLATE-decompresses this [Source](../-source/index.md) while reading. |
