[okio](../../index.md) / [okio](../index.md) / [ForwardingTimeout](./index.md)

# ForwardingTimeout

`open class ForwardingTimeout : `[`Timeout`](../-timeout/index.md)

**Platform and version requirements:** JVM

A [Timeout](../-timeout/index.md) which forwards calls to another. Useful for subclassing.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `ForwardingTimeout(delegate: `[`Timeout`](../-timeout/index.md)`)`<br>A [Timeout](../-timeout/index.md) which forwards calls to another. Useful for subclassing. |

### Properties

| Name | Summary |
|---|---|
| [delegate](delegate.md) | `var delegate: `[`Timeout`](../-timeout/index.md) |

### Functions

| Name | Summary |
|---|---|
| [clearDeadline](clear-deadline.md) | `open fun clearDeadline(): `[`Timeout`](../-timeout/index.md)<br>Clears the deadline. |
| [clearTimeout](clear-timeout.md) | `open fun clearTimeout(): `[`Timeout`](../-timeout/index.md)<br>Clears the timeout. Operating system timeouts may still apply. |
| [deadlineNanoTime](deadline-nano-time.md) | `open fun deadlineNanoTime(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime()) when the deadline will be reached.`open fun deadlineNanoTime(deadlineNanoTime: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Timeout`](../-timeout/index.md)<br>Sets the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime()) when the deadline will be reached. All operations must complete before this time. Use a deadline to set a maximum bound on the time spent on a sequence of operations. |
| [hasDeadline](has-deadline.md) | `open fun hasDeadline(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if a deadline is enabled. |
| [setDelegate](set-delegate.md) | `fun setDelegate(delegate: `[`Timeout`](../-timeout/index.md)`): `[`ForwardingTimeout`](./index.md) |
| [throwIfReached](throw-if-reached.md) | `open fun throwIfReached(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Throws an [InterruptedIOException](https://docs.oracle.com/javase/8/docs/api/java/io/InterruptedIOException.html) if the deadline has been reached or if the current thread has been interrupted. This method doesn't detect timeouts; that should be implemented to asynchronously abort an in-progress operation. |
| [timeout](timeout.md) | `open fun timeout(timeout: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, unit: `[`TimeUnit`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)`): `[`Timeout`](../-timeout/index.md)<br>Wait at most `timeout` time before aborting an operation. Using a per-operation timeout means that as long as forward progress is being made, no sequence of operations will fail. |
| [timeoutNanos](timeout-nanos.md) | `open fun timeoutNanos(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the timeout in nanoseconds, or `0` for no timeout. |

### Inherited Functions

| Name | Summary |
|---|---|
| [deadline](../-timeout/deadline.md)<br>(JVM) | `fun deadline(duration: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, unit: `[`TimeUnit`](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)`): `[`Timeout`](../-timeout/index.md)<br>Set a deadline of now plus `duration` time. |
| [intersectWith](../-timeout/intersect-with.md)<br>(JVM) | `fun intersectWith(other: `[`Timeout`](../-timeout/index.md)`, block: () -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Applies the minimum intersection between this timeout and `other`, run `block`, then finally rollback this timeout's values. |
| [waitUntilNotified](../-timeout/wait-until-notified.md)<br>(JVM) | `fun waitUntilNotified(monitor: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Waits on `monitor` until it is notified. Throws [InterruptedIOException](https://docs.oracle.com/javase/8/docs/api/java/io/InterruptedIOException.html) if either the thread is interrupted or if this timeout elapses before `monitor` is notified. The caller must be synchronized on `monitor`. |
