[okio](../../index.md) / [okio](../index.md) / [HashingSink](./index.md)

# HashingSink

`class HashingSink : `[`ForwardingSink`](../-forwarding-sink/index.md)

**Platform and version requirements:** JVM

A sink that computes a hash of the full stream of bytes it has accepted. To use, create an
instance with your preferred hash algorithm. Write all of the data to the sink and then call
[hash](#) to compute the final hash value.

In this example we use `HashingSink` with a [BufferedSink](../-buffered-sink/index.md) to make writing to the
sink easier.

```
HashingSink hashingSink = HashingSink.sha256(s);
BufferedSink bufferedSink = Okio.buffer(hashingSink);

... // Write to bufferedSink and either flush or close it.

ByteString hash = hashingSink.hash();
```

### Properties

| Name | Summary |
|---|---|
| [hash](hash.md) | `val hash: `[`ByteString`](../-byte-string/index.md)<br>Returns the hash of the bytes accepted thus far and resets the internal state of this sink. |

### Inherited Properties

| Name | Summary |
|---|---|
| [delegate](../-forwarding-sink/delegate.md)<br>(JVM) | `val delegate: `[`Sink`](../-sink/index.md)<br>[Sink](../-sink/index.md) to which this instance is delegating. |

### Functions

| Name | Summary |
|---|---|
| [write](write.md) | `fun write(source: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Inherited Functions

| Name | Summary |
|---|---|
| [close](../-forwarding-sink/close.md)<br>(JVM) | `open fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [flush](../-forwarding-sink/flush.md)<br>(JVM) | `open fun flush(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [timeout](../-forwarding-sink/timeout.md)<br>(JVM) | `open fun timeout(): `[`Timeout`](../-timeout/index.md) |
| [toString](../-forwarding-sink/to-string.md)<br>(JVM) | `open fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [hmacSha1](hmac-sha1.md) | `fun hmacSha1(sink: `[`Sink`](../-sink/index.md)`, key: `[`ByteString`](../-byte-string/index.md)`): `[`HashingSink`](./index.md)<br>Returns a sink that uses the obsolete SHA-1 HMAC algorithm to produce 160-bit hashes. |
| [hmacSha256](hmac-sha256.md) | `fun hmacSha256(sink: `[`Sink`](../-sink/index.md)`, key: `[`ByteString`](../-byte-string/index.md)`): `[`HashingSink`](./index.md)<br>Returns a sink that uses the SHA-256 HMAC algorithm to produce 256-bit hashes. |
| [hmacSha512](hmac-sha512.md) | `fun hmacSha512(sink: `[`Sink`](../-sink/index.md)`, key: `[`ByteString`](../-byte-string/index.md)`): `[`HashingSink`](./index.md)<br>Returns a sink that uses the SHA-512 HMAC algorithm to produce 512-bit hashes. |
| [md5](md5.md) | `fun md5(sink: `[`Sink`](../-sink/index.md)`): `[`HashingSink`](./index.md)<br>Returns a sink that uses the obsolete MD5 hash algorithm to produce 128-bit hashes. |
| [sha1](sha1.md) | `fun sha1(sink: `[`Sink`](../-sink/index.md)`): `[`HashingSink`](./index.md)<br>Returns a sink that uses the obsolete SHA-1 hash algorithm to produce 160-bit hashes. |
| [sha256](sha256.md) | `fun sha256(sink: `[`Sink`](../-sink/index.md)`): `[`HashingSink`](./index.md)<br>Returns a sink that uses the SHA-256 hash algorithm to produce 256-bit hashes. |
| [sha512](sha512.md) | `fun sha512(sink: `[`Sink`](../-sink/index.md)`): `[`HashingSink`](./index.md)<br>Returns a sink that uses the SHA-512 hash algorithm to produce 512-bit hashes. |

### Extension Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md)<br>(JVM, js, native) | `expect fun `[`Sink`](../-sink/index.md)`.buffer(): `[`BufferedSink`](../-buffered-sink/index.md)<br>Returns a new sink that buffers writes to `sink`. The returned sink will batch writes to `sink`. Use this wherever you write to a sink to get an ergonomic and efficient access to data. |
| [deflate](../deflate.md)<br>(JVM) | `fun `[`Sink`](../-sink/index.md)`.deflate(deflater: `[`Deflater`](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html)` = Deflater()): `[`DeflaterSink`](../-deflater-sink/index.md)<br>Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](../-sink/index.md) while writing. |
| [gzip](../gzip.md)<br>(JVM) | `fun `[`Sink`](../-sink/index.md)`.gzip(): `[`GzipSink`](../-gzip-sink/index.md)<br>Returns a [GzipSink](../-gzip-sink/index.md) that gzip-compresses to this [Sink](../-sink/index.md) while writing. |
