[okio](../../index.md) / [okio](../index.md) / [Buffer](index.md) / [emitCompleteSegments](./emit-complete-segments.md)

# emitCompleteSegments

`fun emitCompleteSegments(): `[`Buffer`](index.md)

Overrides [BufferedSink.emitCompleteSegments](../-buffered-sink/emit-complete-segments.md)

**Platform and version requirements:** JVM, js, native

Writes complete segments to the underlying sink, if one exists. Like [flush](../-buffered-sink/flush.md), but weaker. Use
this to limit the memory held in the buffer to a single segment. Typically application code
will not need to call this: it is only necessary when application code writes directly to this
[sink's buffer](../buffer.md).

```
BufferedSink b0 = new Buffer();
BufferedSink b1 = Okio.buffer(b0);
BufferedSink b2 = Okio.buffer(b1);

b2.buffer().write(new byte[20_000]);
assertEquals(20_000, b2.buffer().size());
assertEquals(     0, b1.buffer().size());
assertEquals(     0, b0.buffer().size());

b2.emitCompleteSegments();
assertEquals( 3_616, b2.buffer().size());
assertEquals(     0, b1.buffer().size());
assertEquals(16_384, b0.buffer().size()); // This example assumes 8192 byte segments.
```

