[okio](../../index.md) / [okio](../index.md) / [Buffer](index.md) / [writeIntLe](./write-int-le.md)

# writeIntLe

`fun writeIntLe(i: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Buffer`](index.md)

Overrides [BufferedSink.writeIntLe](../-buffered-sink/write-int-le.md)

**Platform and version requirements:** JVM, js, native

Writes a little-endian int to this sink using four bytes.

```
Buffer buffer = new Buffer();
buffer.writeIntLe(2147483647);
buffer.writeIntLe(15);

assertEquals(8, buffer.size());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0x7f, buffer.readByte());
assertEquals((byte) 0x0f, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals(0, buffer.size());
```

