[okio](../../index.md) / [okio](../index.md) / [GzipSource](./index.md)

# GzipSource

`class GzipSource : `[`Source`](../-source/index.md)

**Platform and version requirements:** JVM

A source that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to
decompress data read from another source.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `GzipSource(source: `[`Source`](../-source/index.md)`)`<br>A source that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to decompress data read from another source. |

### Functions

| Name | Summary |
|---|---|
| [close](close.md) | `fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [read](read.md) | `fun read(sink: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [timeout](timeout.md) | `fun timeout(): `[`Timeout`](../-timeout/index.md) |

### Extension Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md)<br>(JVM, js, native) | `expect fun `[`Source`](../-source/index.md)`.buffer(): `[`BufferedSource`](../-buffered-source/index.md)<br>Returns a new source that buffers reads from `source`. The returned source will perform bulk reads into its in-memory buffer. Use this wherever you read a source to get an ergonomic and efficient access to data. |
| [gzip](../gzip.md)<br>(JVM) | `fun `[`Source`](../-source/index.md)`.gzip(): `[`GzipSource`](./index.md)<br>Returns a [GzipSource](./index.md) that gzip-decompresses this [Source](../-source/index.md) while reading. |
| [inflate](../inflate.md)<br>(JVM) | `fun `[`Source`](../-source/index.md)`.inflate(inflater: `[`Inflater`](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html)` = Inflater()): `[`InflaterSource`](../-inflater-source/index.md)<br>Returns an [InflaterSource](../-inflater-source/index.md) that DEFLATE-decompresses this [Source](../-source/index.md) while reading. |
