[okio](../../index.md) / [okio](../index.md) / [Sink](./index.md)

# Sink

`expect interface Sink`

**Platform and version requirements:** JVM, js, native

Receives a stream of bytes. Use this interface to write data wherever it's needed: to the
network, storage, or a buffer in memory. Sinks may be layered to transform received data, such as
to compress, encrypt, throttle, or add protocol framing.

Most application code shouldn't operate on a sink directly, but rather on a [BufferedSink](../-buffered-sink/index.md) which
is both more efficient and more convenient. Use [buffer](../buffer.md) to wrap any sink with a buffer.

Sinks are easy to test: just use a [Buffer](../-buffer/index.md) in your tests, and read from it to confirm it
received the data that was expected.

### Comparison with OutputStream

This interface is functionally equivalent to [java.io.OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html).

`OutputStream` requires multiple layers when emitted data is heterogeneous: a `DataOutputStream`
for primitive values, a `BufferedOutputStream` for buffering, and `OutputStreamWriter` for
charset encoding. This library uses `BufferedSink` for all of the above.

Sink is also easier to layer: there is no [write()](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html#write(int)) method that is
awkward to implement efficiently.

### Interop with OutputStream

Use [sink](#) to adapt an `OutputStream` to a sink. Use [outputStream()](#)
to adapt a sink to an `OutputStream`.

### Functions

| Name | Summary |
|---|---|
| [close](close.md) | `abstract fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Pushes all buffered bytes to their final destination and releases the resources held by this sink. It is an error to write a closed sink. It is safe to close a sink more than once. |
| [flush](flush.md) | `abstract fun flush(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Pushes all buffered bytes to their final destination. |
| [timeout](timeout.md) | `abstract fun timeout(): `[`Timeout`](../-timeout/index.md)<br>Returns the timeout for this sink. |
| [write](write.md) | `abstract fun write(source: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Removes `byteCount` bytes from `source` and appends them to this. |

### Extension Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md)<br>(JVM, js, native) | `expect fun `[`Sink`](./index.md)`.buffer(): `[`BufferedSink`](../-buffered-sink/index.md)<br>Returns a new sink that buffers writes to `sink`. The returned sink will batch writes to `sink`. Use this wherever you write to a sink to get an ergonomic and efficient access to data. |
| [deflate](../deflate.md)<br>(JVM) | `fun `[`Sink`](./index.md)`.deflate(deflater: `[`Deflater`](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html)` = Deflater()): `[`DeflaterSink`](../-deflater-sink/index.md)<br>Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](./index.md) while writing. |
| [gzip](../gzip.md)<br>(JVM) | `fun `[`Sink`](./index.md)`.gzip(): `[`GzipSink`](../-gzip-sink/index.md)<br>Returns a [GzipSink](../-gzip-sink/index.md) that gzip-compresses to this [Sink](./index.md) while writing. |

### Inheritors

| Name | Summary |
|---|---|
| [BufferedSink](../-buffered-sink/index.md)<br>(JVM, js, native) | `expect interface BufferedSink : `[`Sink`](./index.md)<br>A sink that keeps a buffer internally so that callers can do small writes without a performance penalty. |
| [DeflaterSink](../-deflater-sink/index.md)<br>(JVM) | `class DeflaterSink : `[`Sink`](./index.md)<br>A sink that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to compress data written to another source. |
| [ForwardingSink](../-forwarding-sink/index.md)<br>(JVM) | `abstract class ForwardingSink : `[`Sink`](./index.md)<br>A [Sink](./index.md) which forwards calls to another. Useful for subclassing. |
| [GzipSink](../-gzip-sink/index.md)<br>(JVM) | `class GzipSink : `[`Sink`](./index.md)<br>A sink that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to compress written data to another sink. |
