[okio](../../index.md) / [okio](../index.md) / [Throttler](./index.md)

# Throttler

`class Throttler`

**Platform and version requirements:** JVM

Enables limiting of Source and Sink throughput. Attach to this throttler via [source](source.md) and [sink](sink.md)
and set the desired throughput via [bytesPerSecond](bytes-per-second.md). Multiple Sources and Sinks can be
attached to a single Throttler and they will be throttled as a group, where their combined
throughput will not exceed the desired throughput. The same Source or Sink can be attached to
multiple Throttlers and its throughput will not exceed the desired throughput of any of the
Throttlers.

This class has these tuning parameters:

* `bytesPerSecond`: Maximum sustained throughput. Use 0 for no limit.
* `waitByteCount`: When the requested byte count is greater than this many bytes and isn't
    immediately available, only wait until we can allocate at least this many bytes. Use this to
    set the ideal byte count during sustained throughput.
* `maxByteCount`: Maximum number of bytes to allocate on any call. This is also the number of
    bytes that will be returned before any waiting.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `Throttler()` |

### Functions

| Name | Summary |
|---|---|
| [bytesPerSecond](bytes-per-second.md) | `fun bytesPerSecond(bytesPerSecond: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, waitByteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)` = this.waitByteCount, maxByteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)` = this.maxByteCount): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Sets the rate at which bytes will be allocated. Use 0 for no limit. |
| [sink](sink.md) | `fun sink(sink: `[`Sink`](../-sink/index.md)`): `[`Sink`](../-sink/index.md)<br>Create a Sink which honors this Throttler. |
| [source](source.md) | `fun source(source: `[`Source`](../-source/index.md)`): `[`Source`](../-source/index.md)<br>Create a Source which honors this Throttler. |
