[okio](../../../index.md) / [okio](../../index.md) / [Buffer](../index.md) / [UnsafeCursor](index.md) / [resizeBuffer](./resize-buffer.md)

# resizeBuffer

(jvm) `fun resizeBuffer(newSize: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)

Change the size of the buffer so that it equals `newSize` by either adding new
capacity at the end or truncating the buffer at the end. Newly added capacity may span
multiple segments.

As a side-effect this cursor will [seek](seek.md). If the buffer is being enlarged
it will move [UnsafeCursor.offset](offset.md) to the first byte of newly-added capacity. This is the
size of the buffer prior to the `resizeBuffer()` call. If the buffer is being shrunk it will move
[UnsafeCursor.offset](offset.md) to the end of the buffer.

Warning: it is the caller’s responsibility to write new data to every byte of the
newly-allocated capacity. Failure to do so may cause serious security problems as the data
in the returned buffers is not zero filled. Buffers may contain dirty pooled segments that
hold very sensitive data from other parts of the current process.

**Return**
the previous size of the buffer.

