[okio](../../index.md) / [okio](../index.md) / [ForwardingSource](./index.md)

# ForwardingSource

(jvm) `abstract class ForwardingSource : `[`Source`](../-source/index.md)

A [Source](../-source/index.md#okio.Source) which forwards calls to another. Useful for subclassing.

### Constructors

| Name | Summary |
|---|---|
| (jvm) [&lt;init&gt;](-init-.md) | A [Source](../-source/index.md#okio.Source) which forwards calls to another. Useful for subclassing.`ForwardingSource(delegate: `[`Source`](../-source/index.md)`)` |

### Properties

| Name | Summary |
|---|---|
| (jvm) [delegate](delegate.md) | [Source](../-source/index.md#okio.Source) to which this instance is delegating.`val delegate: `[`Source`](../-source/index.md) |

### Functions

| Name | Summary |
|---|---|
| (jvm) [close](close.md) | `open fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [delegate](delegate.md) | `fun ~~delegate~~(): `[`Source`](../-source/index.md) |
| (jvm) [read](read.md) | `open fun read(sink: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (jvm) [timeout](timeout.md) | `open fun timeout(): `[`Timeout`](../-timeout/index.md) |
| (jvm) [toString](to-string.md) | `open fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Extension Functions

| Name | Summary |
|---|---|
| (jvm) [gzip](../gzip.md) | Returns a [GzipSource](../-gzip-source/index.md) that gzip-decompresses this [Source](../-source/index.md#okio.Source) while reading.`fun `[`Source`](../-source/index.md)`.gzip(): `[`GzipSource`](../-gzip-source/index.md) |
| (jvm) [inflate](../inflate.md) | Returns an [InflaterSource](../-inflater-source/index.md) that DEFLATE-decompresses this [Source](../-source/index.md#okio.Source) while reading.`fun `[`Source`](../-source/index.md)`.inflate(inflater: `[`Inflater`](https://docs.oracle.com/javase/6/docs/api/java/util/zip/Inflater.html)` = Inflater()): `[`InflaterSource`](../-inflater-source/index.md) |

### Inheritors

| Name | Summary |
|---|---|
| (jvm) [HashingSource](../-hashing-source/index.md) | A source that computes a hash of the full stream of bytes it has supplied. To use, create an instance with your preferred hash algorithm. Exhaust the source by reading all of its bytes and then call [hash](../-hashing-source/hash.md) to compute the final hash value.`class HashingSource : `[`ForwardingSource`](./index.md) |
