[okio](../../index.md) / [okio](../index.md) / [GzipSource](./index.md)

# GzipSource

(jvm) `class GzipSource : `[`Source`](../-source/index.md)

A source that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to
decompress data read from another source.

### Constructors

| Name | Summary |
|---|---|
| (jvm) [&lt;init&gt;](-init-.md) | A source that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to decompress data read from another source.`GzipSource(source: `[`Source`](../-source/index.md)`)` |

### Functions

| Name | Summary |
|---|---|
| (jvm) [close](close.md) | `fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [read](read.md) | `fun read(sink: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (jvm) [timeout](timeout.md) | `fun timeout(): `[`Timeout`](../-timeout/index.md) |

### Extension Functions

| Name | Summary |
|---|---|
| (jvm) [gzip](../gzip.md) | Returns a [GzipSource](./index.md) that gzip-decompresses this [Source](../-source/index.md#okio.Source) while reading.`fun `[`Source`](../-source/index.md)`.gzip(): `[`GzipSource`](./index.md) |
| (jvm) [inflate](../inflate.md) | Returns an [InflaterSource](../-inflater-source/index.md) that DEFLATE-decompresses this [Source](../-source/index.md#okio.Source) while reading.`fun `[`Source`](../-source/index.md)`.inflate(inflater: `[`Inflater`](https://docs.oracle.com/javase/6/docs/api/java/util/zip/Inflater.html)` = Inflater()): `[`InflaterSource`](../-inflater-source/index.md) |
