[okio](../../index.md) / [okio](../index.md) / [HashingSource](./index.md)

# HashingSource

(jvm) `class HashingSource : `[`ForwardingSource`](../-forwarding-source/index.md)

A source that computes a hash of the full stream of bytes it has supplied. To use, create an
instance with your preferred hash algorithm. Exhaust the source by reading all of its bytes and
then call [hash](hash.md) to compute the final hash value.

In this example we use `HashingSource` with a [BufferedSource](../-buffered-source/index.md#okio.BufferedSource) to make reading
from the source easier.

```
HashingSource hashingSource = HashingSource.sha256(rawSource);
BufferedSource bufferedSource = Okio.buffer(hashingSource);

... // Read all of bufferedSource.

ByteString hash = hashingSource.hash();
```

### Properties

| Name | Summary |
|---|---|
| (jvm) [hash](hash.md) | Returns the hash of the bytes supplied thus far and resets the internal state of this source.`val hash: `[`ByteString`](../-byte-string/index.md) |

### Functions

| Name | Summary |
|---|---|
| (jvm) [hash](hash.md) | `fun ~~hash~~(): `[`ByteString`](../-byte-string/index.md) |
| (jvm) [read](read.md) | `fun read(sink: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| (jvm) [hmacSha1](hmac-sha1.md) | Returns a sink that uses the obsolete SHA-1 HMAC algorithm to produce 160-bit hashes.`fun hmacSha1(source: `[`Source`](../-source/index.md)`, key: `[`ByteString`](../-byte-string/index.md)`): `[`HashingSource`](./index.md) |
| (jvm) [hmacSha256](hmac-sha256.md) | Returns a sink that uses the SHA-256 HMAC algorithm to produce 256-bit hashes.`fun hmacSha256(source: `[`Source`](../-source/index.md)`, key: `[`ByteString`](../-byte-string/index.md)`): `[`HashingSource`](./index.md) |
| (jvm) [hmacSha512](hmac-sha512.md) | Returns a sink that uses the SHA-512 HMAC algorithm to produce 512-bit hashes.`fun hmacSha512(source: `[`Source`](../-source/index.md)`, key: `[`ByteString`](../-byte-string/index.md)`): `[`HashingSource`](./index.md) |
| (jvm) [md5](md5.md) | Returns a sink that uses the obsolete MD5 hash algorithm to produce 128-bit hashes.`fun md5(source: `[`Source`](../-source/index.md)`): `[`HashingSource`](./index.md) |
| (jvm) [sha1](sha1.md) | Returns a sink that uses the obsolete SHA-1 hash algorithm to produce 160-bit hashes.`fun sha1(source: `[`Source`](../-source/index.md)`): `[`HashingSource`](./index.md) |
| (jvm) [sha256](sha256.md) | Returns a sink that uses the SHA-256 hash algorithm to produce 256-bit hashes.`fun sha256(source: `[`Source`](../-source/index.md)`): `[`HashingSource`](./index.md) |
| (jvm) [sha512](sha512.md) | Returns a sink that uses the SHA-512 hash algorithm to produce 512-bit hashes.`fun sha512(source: `[`Source`](../-source/index.md)`): `[`HashingSource`](./index.md) |

### Extension Functions

| Name | Summary |
|---|---|
| (jvm) [gzip](../gzip.md) | Returns a [GzipSource](../-gzip-source/index.md) that gzip-decompresses this [Source](../-source/index.md#okio.Source) while reading.`fun `[`Source`](../-source/index.md)`.gzip(): `[`GzipSource`](../-gzip-source/index.md) |
| (jvm) [inflate](../inflate.md) | Returns an [InflaterSource](../-inflater-source/index.md) that DEFLATE-decompresses this [Source](../-source/index.md#okio.Source) while reading.`fun `[`Source`](../-source/index.md)`.inflate(inflater: `[`Inflater`](https://docs.oracle.com/javase/6/docs/api/java/util/zip/Inflater.html)` = Inflater()): `[`InflaterSource`](../-inflater-source/index.md) |
