[okio](../../index.md) / [okio](../index.md) / [Pipe](./index.md)

# Pipe

(jvm) `class Pipe`

A source and a sink that are attached. The sink's output is the source's input. Typically each
is accessed by its own thread: a producer thread writes data to the sink and a consumer thread
reads data from the source.

This class uses a buffer to decouple source and sink. This buffer has a user-specified maximum
size. When a producer thread outruns its consumer the buffer fills up and eventually writes to
the sink will block until the consumer has caught up. Symmetrically, if a consumer outruns its
producer reads block until there is data to be read. Limits on the amount of time spent waiting
for the other party can be configured with [timeouts](../-timeout/index.md#okio.Timeout) on the source and the
sink.

When the sink is closed, source reads will continue to complete normally until the buffer has
been exhausted. At that point reads will return -1, indicating the end of the stream. But if the
source is closed first, writes to the sink will immediately fail with an [IOException](https://docs.oracle.com/javase/6/docs/api/java/io/IOException.html).

### Constructors

| Name | Summary |
|---|---|
| (jvm) [&lt;init&gt;](-init-.md) | A source and a sink that are attached. The sink's output is the source's input. Typically each is accessed by its own thread: a producer thread writes data to the sink and a consumer thread reads data from the source.`Pipe(maxBufferSize: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`)` |

### Properties

| Name | Summary |
|---|---|
| (jvm) [sink](sink.md) | `val sink: `[`Sink`](../-sink/index.md) |
| (jvm) [source](source.md) | `val source: `[`Source`](../-source/index.md) |

### Functions

| Name | Summary |
|---|---|
| (jvm) [fold](fold.md) | Writes any buffered contents of this pipe to `sink`, then replace this pipe's source with `sink`. This pipe's source is closed and attempts to read it will throw an [IllegalStateException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-illegal-state-exception/index.html).`fun fold(sink: `[`Sink`](../-sink/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [sink](sink.md) | `fun ~~sink~~(): `[`Sink`](../-sink/index.md) |
| (jvm) [source](source.md) | `fun ~~source~~(): `[`Source`](../-source/index.md) |
