[okio](../../index.md) / [okio](../index.md) / [Timeout](./index.md)

# Timeout

(js, jvm, native) `open class Timeout`

A policy on how much time to spend on a task before giving up. When a task times out, it is left
in an unspecified state and should be abandoned. For example, if reading from a source times out,
that source should be closed and the read should be retried later. If writing to a sink times
out, the same rules apply: close the sink and retry later.

### Timeouts and Deadlines

This class offers two complementary controls to define a timeout policy.

**Timeouts** specify the maximum time to wait for a single operation to complete. Timeouts are
typically used to detect problems like network partitions. For example, if a remote peer doesn't
return *any* data for ten seconds, we may assume that the peer is unavailable.

**Deadlines** specify the maximum time to spend on a job, composed of one or more operations. Use
deadlines to set an upper bound on the time invested on a job. For example, a battery-conscious
app may limit how much time it spends pre-loading content.

### Constructors

| Name | Summary |
|---|---|
| (js, jvm, native) [&lt;init&gt;](-init-.md) | `<init>()` |

### Functions

| Name | Summary |
|---|---|
| (jvm) [clearDeadline](clear-deadline.md) | Clears the deadline.`open fun clearDeadline(): `[`Timeout`](./index.md) |
| (jvm) [clearTimeout](clear-timeout.md) | Clears the timeout. Operating system timeouts may still apply.`open fun clearTimeout(): `[`Timeout`](./index.md) |
| (jvm) [deadline](deadline.md) | Set a deadline of now plus `duration` time.`fun deadline(duration: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, unit: `[`TimeUnit`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/TimeUnit.html)`): `[`Timeout`](./index.md) |
| (jvm) [deadlineNanoTime](deadline-nano-time.md) | Returns the [nano time](https://docs.oracle.com/javase/6/docs/api/java/lang/System.html#nanoTime()) when the deadline will be reached.`open fun deadlineNanoTime(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Sets the [nano time](https://docs.oracle.com/javase/6/docs/api/java/lang/System.html#nanoTime()) when the deadline will be reached. All operations must complete before this time. Use a deadline to set a maximum bound on the time spent on a sequence of operations.`open fun deadlineNanoTime(deadlineNanoTime: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Timeout`](./index.md) |
| (jvm) [hasDeadline](has-deadline.md) | Returns true if a deadline is enabled.`open fun hasDeadline(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| (jvm) [intersectWith](intersect-with.md) | Applies the minimum intersection between this timeout and `other`, run `block`, then finally rollback this timeout's values.`fun intersectWith(other: `[`Timeout`](./index.md)`, block: () -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [throwIfReached](throw-if-reached.md) | Throws an [InterruptedIOException](https://docs.oracle.com/javase/6/docs/api/java/io/InterruptedIOException.html) if the deadline has been reached or if the current thread has been interrupted. This method doesn't detect timeouts; that should be implemented to asynchronously abort an in-progress operation.`open fun throwIfReached(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [timeout](timeout.md) | Wait at most `timeout` time before aborting an operation. Using a per-operation timeout means that as long as forward progress is being made, no sequence of operations will fail.`open fun timeout(timeout: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, unit: `[`TimeUnit`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/TimeUnit.html)`): `[`Timeout`](./index.md) |
| (jvm) [timeoutNanos](timeout-nanos.md) | Returns the timeout in nanoseconds, or `0` for no timeout.`open fun timeoutNanos(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (jvm) [waitUntilNotified](wait-until-notified.md) | Waits on `monitor` until it is notified. Throws [InterruptedIOException](https://docs.oracle.com/javase/6/docs/api/java/io/InterruptedIOException.html) if either the thread is interrupted or if this timeout elapses before `monitor` is notified. The caller must be synchronized on `monitor`.`fun waitUntilNotified(monitor: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Properties

| Name | Summary |
|---|---|
| (js, jvm, native) [NONE](-n-o-n-e.md) | An empty timeout that neither tracks nor detects timeouts. Use this when timeouts aren't necessary, such as in implementations whose operations do not block.`val NONE: `[`Timeout`](./index.md) |

### Companion Object Functions

| Name | Summary |
|---|---|
| (jvm) [minTimeout](min-timeout.md) | `fun minTimeout(aNanos: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, bNanos: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |

### Inheritors

| Name | Summary |
|---|---|
| (jvm) [AsyncTimeout](../-async-timeout/index.md) | This timeout uses a background thread to take action exactly when the timeout occurs. Use this to implement timeouts where they aren't supported natively, such as to sockets that are blocked on writing.`open class AsyncTimeout : `[`Timeout`](./index.md) |
| (jvm) [ForwardingTimeout](../-forwarding-timeout/index.md) | A [Timeout](index.md#okio.Timeout) which forwards calls to another. Useful for subclassing.`open class ForwardingTimeout : `[`Timeout`](./index.md) |
