[okio](../../index.md) / [okio](../index.md) / [Source](./index.md)

# Source

(js, jvm, native) `interface Source`(js)

Supplies a stream of bytes. Use this interface to read data from wherever it's located: from the
network, storage, or a buffer in memory. Sources may be layered to transform supplied data, such
as to decompress, decrypt, or remove protocol framing.

Most applications shouldn't operate on a source directly, but rather on a [BufferedSource](../-buffered-source/index.md#okio.BufferedSource) which
is both more efficient and more convenient. Use [buffer](../buffer.md#okio$buffer(okio.Source)) to wrap any source with a buffer.

Sources are easy to test: just use a [Buffer](../-buffer/index.md#okio.Buffer) in your tests, and fill it with the data your
application is to read.

### Comparison with InputStream

This interface is functionally equivalent to [java.io.InputStream](#).

`InputStream` requires multiple layers when consumed data is heterogeneous: a `DataInputStream`
for primitive values, a `BufferedInputStream` for buffering, and `InputStreamReader` for strings.
This library uses `BufferedSource` for all of the above.

Source avoids the impossible-to-implement [available()](#) method.
Instead callers specify how many bytes they [require](../-buffered-source/require.md#okio.BufferedSource$require(kotlin.Long)).

Source omits the unsafe-to-compose [mark and reset](#) state that's
tracked by `InputStream`; instead, callers just buffer what they need.

When implementing a source, you don't need to worry about the [read()](#)
method that is awkward to implement efficiently and returns one of 257 possible values.

And source has a stronger `skip` method: [BufferedSource.skip](../-buffered-source/skip.md#okio.BufferedSource$skip(kotlin.Long)) won't return prematurely.

### Interop with InputStream

Use [source](#) to adapt an `InputStream` to a source. Use [BufferedSource.inputStream](#) to adapt a
source to an `InputStream`.

(jvm)

Supplies a stream of bytes. Use this interface to read data from wherever it's located: from the
network, storage, or a buffer in memory. Sources may be layered to transform supplied data, such
as to decompress, decrypt, or remove protocol framing.

Most applications shouldn't operate on a source directly, but rather on a [BufferedSource](../-buffered-source/index.md#okio.BufferedSource) which
is both more efficient and more convenient. Use [buffer](../buffer.md#okio$buffer(okio.Source)) to wrap any source with a buffer.

Sources are easy to test: just use a [Buffer](../-buffer/index.md#okio.Buffer) in your tests, and fill it with the data your
application is to read.

### Comparison with InputStream

This interface is functionally equivalent to [java.io.InputStream](https://docs.oracle.com/javase/6/docs/api/java/io/InputStream.html).

`InputStream` requires multiple layers when consumed data is heterogeneous: a `DataInputStream`
for primitive values, a `BufferedInputStream` for buffering, and `InputStreamReader` for strings.
This library uses `BufferedSource` for all of the above.

Source avoids the impossible-to-implement [available()](https://docs.oracle.com/javase/6/docs/api/java/io/InputStream.html#available()) method.
Instead callers specify how many bytes they [require](../-buffered-source/require.md#okio.BufferedSource$require(kotlin.Long)).

Source omits the unsafe-to-compose [mark and reset](https://docs.oracle.com/javase/6/docs/api/java/io/InputStream.html#mark(int)) state that's
tracked by `InputStream`; instead, callers just buffer what they need.

When implementing a source, you don't need to worry about the [read()](https://docs.oracle.com/javase/6/docs/api/java/io/InputStream.html#read())
method that is awkward to implement efficiently and returns one of 257 possible values.

And source has a stronger `skip` method: [BufferedSource.skip](../-buffered-source/skip.md#okio.BufferedSource$skip(kotlin.Long)) won't return prematurely.

### Interop with InputStream

Use [source](../java.io.-input-stream/source.md) to adapt an `InputStream` to a source. Use [BufferedSource.inputStream](../-buffered-source/input-stream.md) to adapt a
source to an `InputStream`.

### Functions

| Name | Summary |
|---|---|
| (js, jvm, native) [close](close.md) | Closes this source and releases the resources held by this source. It is an error to read a closed source. It is safe to close a source more than once.`abstract fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (js, jvm, native) [read](read.md) | Removes at least 1, and up to `byteCount` bytes from this and appends them to `sink`. Returns the number of bytes read, or -1 if this source is exhausted.`abstract fun read(sink: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (js, jvm, native) [timeout](timeout.md) | Returns the timeout for this source.`abstract fun timeout(): `[`Timeout`](../-timeout/index.md) |

### Extension Functions

| Name | Summary |
|---|---|
| (jvm) [gzip](../gzip.md) | Returns a [GzipSource](../-gzip-source/index.md) that gzip-decompresses this [Source](index.md#okio.Source) while reading.`fun `[`Source`](./index.md)`.gzip(): `[`GzipSource`](../-gzip-source/index.md) |
| (jvm) [inflate](../inflate.md) | Returns an [InflaterSource](../-inflater-source/index.md) that DEFLATE-decompresses this [Source](index.md#okio.Source) while reading.`fun `[`Source`](./index.md)`.inflate(inflater: `[`Inflater`](https://docs.oracle.com/javase/6/docs/api/java/util/zip/Inflater.html)` = Inflater()): `[`InflaterSource`](../-inflater-source/index.md) |

### Inheritors

| Name | Summary |
|---|---|
| (js, jvm, native) [BufferedSource](../-buffered-source/index.md) | A source that keeps a buffer internally so that callers can do small reads without a performance penalty. It also allows clients to read ahead, buffering as much as necessary before consuming input.`interface BufferedSource : `[`Source`](./index.md) |
| (jvm) [ForwardingSource](../-forwarding-source/index.md) | A [Source](index.md#okio.Source) which forwards calls to another. Useful for subclassing.`abstract class ForwardingSource : `[`Source`](./index.md) |
| (jvm) [GzipSource](../-gzip-source/index.md) | A source that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to decompress data read from another source.`class GzipSource : `[`Source`](./index.md) |
| (jvm) [InflaterSource](../-inflater-source/index.md) | A source that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to decompress data read from another source.`class InflaterSource : `[`Source`](./index.md) |
