[okio](../../index.md) / [okio](../index.md) / [AsyncTimeout](./index.md)

# AsyncTimeout

(jvm) `open class AsyncTimeout : `[`Timeout`](../-timeout/index.md)

This timeout uses a background thread to take action exactly when the timeout occurs. Use this to
implement timeouts where they aren't supported natively, such as to sockets that are blocked on
writing.

Subclasses should override [timedOut](timed-out.md) to take action when a timeout occurs. This method will be
invoked by the shared watchdog thread so it should not do any long-running operations. Otherwise
we risk starving other timeouts from being triggered.

Use [sink](sink.md) and [source](source.md) to apply this timeout to a stream. The returned value will apply the
timeout to each operation on the wrapped stream.

Callers should call [enter](enter.md) before doing work that is subject to timeouts, and [exit](exit.md) afterwards.
The return value of [exit](exit.md) indicates whether a timeout was triggered. Note that the call to
[timedOut](timed-out.md) is asynchronous, and may be called after [exit](exit.md).

### Constructors

| Name | Summary |
|---|---|
| (jvm) [&lt;init&gt;](-init-.md) | This timeout uses a background thread to take action exactly when the timeout occurs. Use this to implement timeouts where they aren't supported natively, such as to sockets that are blocked on writing.`AsyncTimeout()` |

### Functions

| Name | Summary |
|---|---|
| (jvm) [enter](enter.md) | `fun enter(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [exit](exit.md) | Returns true if the timeout occurred.`fun exit(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| (jvm) [newTimeoutException](new-timeout-exception.md) | Returns an [IOException](https://docs.oracle.com/javase/6/docs/api/java/io/IOException.html) to represent a timeout. By default this method returns [InterruptedIOException](https://docs.oracle.com/javase/6/docs/api/java/io/InterruptedIOException.html). If [cause](new-timeout-exception.md#okio.AsyncTimeout$newTimeoutException(java.io.IOException)/cause) is non-null it is set as the cause of the returned exception.`open fun newTimeoutException(cause: `[`IOException`](https://docs.oracle.com/javase/6/docs/api/java/io/IOException.html)`?): `[`IOException`](https://docs.oracle.com/javase/6/docs/api/java/io/IOException.html) |
| (jvm) [sink](sink.md) | Returns a new sink that delegates to [sink](sink.md#okio.AsyncTimeout$sink(okio.Sink)/sink), using this to implement timeouts. This works best if [timedOut](timed-out.md) is overridden to interrupt [sink](sink.md#okio.AsyncTimeout$sink(okio.Sink)/sink)'s current operation.`fun sink(sink: `[`Sink`](../-sink/index.md)`): `[`Sink`](../-sink/index.md) |
| (jvm) [source](source.md) | Returns a new source that delegates to [source](source.md#okio.AsyncTimeout$source(okio.Source)/source), using this to implement timeouts. This works best if [timedOut](timed-out.md) is overridden to interrupt [source](source.md#okio.AsyncTimeout$source(okio.Source)/source)'s current operation.`fun source(source: `[`Source`](../-source/index.md)`): `[`Source`](../-source/index.md) |
| (jvm) [timedOut](timed-out.md) | Invoked by the watchdog thread when the time between calls to [enter](enter.md) and [exit](exit.md) has exceeded the timeout.`open fun timedOut(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [withTimeout](with-timeout.md) | Surrounds [block](with-timeout.md#okio.AsyncTimeout$withTimeout(kotlin.Function0((okio.AsyncTimeout.withTimeout.T)))/block) with calls to [enter](enter.md) and [exit](exit.md), throwing an exception from [newTimeoutException](new-timeout-exception.md) if a timeout occurred.`fun <T> withTimeout(block: () -> T): T` |

### Inherited Functions

| Name | Summary |
|---|---|
| (jvm) [clearDeadline](../-timeout/clear-deadline.md) | Clears the deadline.`open fun clearDeadline(): `[`Timeout`](../-timeout/index.md) |
| (jvm) [clearTimeout](../-timeout/clear-timeout.md) | Clears the timeout. Operating system timeouts may still apply.`open fun clearTimeout(): `[`Timeout`](../-timeout/index.md) |
| (jvm) [deadline](../-timeout/deadline.md) | Set a deadline of now plus `duration` time.`fun deadline(duration: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, unit: `[`TimeUnit`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/TimeUnit.html)`): `[`Timeout`](../-timeout/index.md) |
| (jvm) [deadlineNanoTime](../-timeout/deadline-nano-time.md) | Returns the [nano time](https://docs.oracle.com/javase/6/docs/api/java/lang/System.html#nanoTime()) when the deadline will be reached.`open fun deadlineNanoTime(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Sets the [nano time](https://docs.oracle.com/javase/6/docs/api/java/lang/System.html#nanoTime()) when the deadline will be reached. All operations must complete before this time. Use a deadline to set a maximum bound on the time spent on a sequence of operations.`open fun deadlineNanoTime(deadlineNanoTime: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Timeout`](../-timeout/index.md) |
| (jvm) [hasDeadline](../-timeout/has-deadline.md) | Returns true if a deadline is enabled.`open fun hasDeadline(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| (jvm) [intersectWith](../-timeout/intersect-with.md) | Applies the minimum intersection between this timeout and `other`, run `block`, then finally rollback this timeout's values.`fun intersectWith(other: `[`Timeout`](../-timeout/index.md)`, block: () -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [throwIfReached](../-timeout/throw-if-reached.md) | Throws an [InterruptedIOException](https://docs.oracle.com/javase/6/docs/api/java/io/InterruptedIOException.html) if the deadline has been reached or if the current thread has been interrupted. This method doesn't detect timeouts; that should be implemented to asynchronously abort an in-progress operation.`open fun throwIfReached(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [timeout](../-timeout/timeout.md) | Wait at most `timeout` time before aborting an operation. Using a per-operation timeout means that as long as forward progress is being made, no sequence of operations will fail.`open fun timeout(timeout: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, unit: `[`TimeUnit`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/TimeUnit.html)`): `[`Timeout`](../-timeout/index.md) |
| (jvm) [timeoutNanos](../-timeout/timeout-nanos.md) | Returns the timeout in nanoseconds, or `0` for no timeout.`open fun timeoutNanos(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (jvm) [waitUntilNotified](../-timeout/wait-until-notified.md) | Waits on `monitor` until it is notified. Throws [InterruptedIOException](https://docs.oracle.com/javase/6/docs/api/java/io/InterruptedIOException.html) if either the thread is interrupted or if this timeout elapses before `monitor` is notified. The caller must be synchronized on `monitor`.`fun waitUntilNotified(monitor: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
