[okio](../../index.md) / [okio](../index.md) / [ForwardingTimeout](./index.md)

# ForwardingTimeout

(jvm) `open class ForwardingTimeout : `[`Timeout`](../-timeout/index.md)

A [Timeout](../-timeout/index.md#okio.Timeout) which forwards calls to another. Useful for subclassing.

### Constructors

| Name | Summary |
|---|---|
| (jvm) [&lt;init&gt;](-init-.md) | A [Timeout](../-timeout/index.md#okio.Timeout) which forwards calls to another. Useful for subclassing.`ForwardingTimeout(delegate: `[`Timeout`](../-timeout/index.md)`)` |

### Properties

| Name | Summary |
|---|---|
| (jvm) [delegate](delegate.md) | `var delegate: `[`Timeout`](../-timeout/index.md) |

### Functions

| Name | Summary |
|---|---|
| (jvm) [clearDeadline](clear-deadline.md) | Clears the deadline.`open fun clearDeadline(): `[`Timeout`](../-timeout/index.md) |
| (jvm) [clearTimeout](clear-timeout.md) | Clears the timeout. Operating system timeouts may still apply.`open fun clearTimeout(): `[`Timeout`](../-timeout/index.md) |
| (jvm) [deadlineNanoTime](deadline-nano-time.md) | Returns the [nano time](https://docs.oracle.com/javase/6/docs/api/java/lang/System.html#nanoTime()) when the deadline will be reached.`open fun deadlineNanoTime(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Sets the [nano time](https://docs.oracle.com/javase/6/docs/api/java/lang/System.html#nanoTime()) when the deadline will be reached. All operations must complete before this time. Use a deadline to set a maximum bound on the time spent on a sequence of operations.`open fun deadlineNanoTime(deadlineNanoTime: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Timeout`](../-timeout/index.md) |
| (jvm) [hasDeadline](has-deadline.md) | Returns true if a deadline is enabled.`open fun hasDeadline(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| (jvm) [setDelegate](set-delegate.md) | `fun setDelegate(delegate: `[`Timeout`](../-timeout/index.md)`): `[`ForwardingTimeout`](./index.md) |
| (jvm) [throwIfReached](throw-if-reached.md) | Throws an [InterruptedIOException](https://docs.oracle.com/javase/6/docs/api/java/io/InterruptedIOException.html) if the deadline has been reached or if the current thread has been interrupted. This method doesn't detect timeouts; that should be implemented to asynchronously abort an in-progress operation.`open fun throwIfReached(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [timeout](timeout.md) | Wait at most `timeout` time before aborting an operation. Using a per-operation timeout means that as long as forward progress is being made, no sequence of operations will fail.`open fun timeout(timeout: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, unit: `[`TimeUnit`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/TimeUnit.html)`): `[`Timeout`](../-timeout/index.md) |
| (jvm) [timeoutNanos](timeout-nanos.md) | Returns the timeout in nanoseconds, or `0` for no timeout.`open fun timeoutNanos(): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |

### Inherited Functions

| Name | Summary |
|---|---|
| (jvm) [deadline](../-timeout/deadline.md) | Set a deadline of now plus `duration` time.`fun deadline(duration: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, unit: `[`TimeUnit`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/TimeUnit.html)`): `[`Timeout`](../-timeout/index.md) |
| (jvm) [intersectWith](../-timeout/intersect-with.md) | Applies the minimum intersection between this timeout and `other`, run `block`, then finally rollback this timeout's values.`fun intersectWith(other: `[`Timeout`](../-timeout/index.md)`, block: () -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [waitUntilNotified](../-timeout/wait-until-notified.md) | Waits on `monitor` until it is notified. Throws [InterruptedIOException](https://docs.oracle.com/javase/6/docs/api/java/io/InterruptedIOException.html) if either the thread is interrupted or if this timeout elapses before `monitor` is notified. The caller must be synchronized on `monitor`.`fun waitUntilNotified(monitor: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
