[okio](../../index.md) / [okio](../index.md) / [InflaterSource](./index.md)

# InflaterSource

(jvm) `class InflaterSource : `[`Source`](../-source/index.md)

A source that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to decompress data read from
another source.

### Constructors

| Name | Summary |
|---|---|
| (jvm) [&lt;init&gt;](-init-.md) | `InflaterSource(source: `[`Source`](../-source/index.md)`, inflater: `[`Inflater`](https://docs.oracle.com/javase/6/docs/api/java/util/zip/Inflater.html)`)` |

### Functions

| Name | Summary |
|---|---|
| (jvm) [close](close.md) | `fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [read](read.md) | `fun read(sink: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (jvm) [readOrInflate](read-or-inflate.md) | Consume deflated bytes from the underlying source, and write any inflated bytes to [sink](read-or-inflate.md#okio.InflaterSource$readOrInflate(okio.Buffer, kotlin.Long)/sink). Returns the number of inflated bytes written to [sink](read-or-inflate.md#okio.InflaterSource$readOrInflate(okio.Buffer, kotlin.Long)/sink). This may return 0L, though it will always consume 1 or more bytes from the underlying source if it is not exhausted.`fun readOrInflate(sink: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (jvm) [refill](refill.md) | Refills the inflater with compressed data if it needs input. (And only if it needs input). Returns true if the inflater required input but the source was exhausted.`fun refill(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| (jvm) [timeout](timeout.md) | `fun timeout(): `[`Timeout`](../-timeout/index.md) |

### Extension Functions

| Name | Summary |
|---|---|
| (jvm) [gzip](../gzip.md) | Returns a [GzipSource](../-gzip-source/index.md) that gzip-decompresses this [Source](../-source/index.md#okio.Source) while reading.`fun `[`Source`](../-source/index.md)`.gzip(): `[`GzipSource`](../-gzip-source/index.md) |
| (jvm) [inflate](../inflate.md) | Returns an [InflaterSource](./index.md) that DEFLATE-decompresses this [Source](../-source/index.md#okio.Source) while reading.`fun `[`Source`](../-source/index.md)`.inflate(inflater: `[`Inflater`](https://docs.oracle.com/javase/6/docs/api/java/util/zip/Inflater.html)` = Inflater()): `[`InflaterSource`](./index.md) |
