[okio](../../index.md) / [okio](../index.md) / [BufferedSink](./index.md)

# BufferedSink

(js, jvm, native) `interface BufferedSink : `[`Sink`](../-sink/index.md)

A sink that keeps a buffer internally so that callers can do small writes without a performance
penalty.

### Properties

| Name | Summary |
|---|---|
| (js, jvm, native) [buffer](buffer.md) | This sink's internal buffer.`abstract val buffer: `[`Buffer`](../-buffer/index.md) |

### Functions

| Name | Summary |
|---|---|
| (jvm) [buffer](buffer.md) | Returns this sink's internal buffer.`abstract fun ~~buffer~~(): `[`Buffer`](../-buffer/index.md) |
| (js, jvm, native) [emit](emit.md) | Writes all buffered data to the underlying sink, if one exists. Like [flush](flush.md#okio.BufferedSink$flush()), but weaker. Call this before this buffered sink goes out of scope so that its data can reach its destination.`abstract fun emit(): `[`BufferedSink`](./index.md) |
| (js, jvm, native) [emitCompleteSegments](emit-complete-segments.md) | Writes complete segments to the underlying sink, if one exists. Like [flush](flush.md#okio.BufferedSink$flush()), but weaker. Use this to limit the memory held in the buffer to a single segment. Typically application code will not need to call this: it is only necessary when application code writes directly to this [sink's buffer](../buffer.md#okio$buffer(okio.Source)).`abstract fun emitCompleteSegments(): `[`BufferedSink`](./index.md) |
| (js, jvm) [flush](flush.md) | Writes all buffered data to the underlying sink, if one exists. Then that sink is recursively flushed which pushes data as far as possible towards its ultimate destination. Typically that destination is a network socket or file.`abstract fun flush(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (jvm) [outputStream](output-stream.md) | Returns an output stream that writes to this sink.`abstract fun outputStream(): `[`OutputStream`](https://docs.oracle.com/javase/6/docs/api/java/io/OutputStream.html) |
| (js, jvm, native) [write](write.md) | `abstract fun write(byteString: `[`ByteString`](../-byte-string/index.md)`): `[`BufferedSink`](./index.md)<br>`abstract fun write(byteString: `[`ByteString`](../-byte-string/index.md)`, offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](./index.md)<br>Like [OutputStream.write](#), this writes a complete byte array to this sink.`abstract fun write(source: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`): `[`BufferedSink`](./index.md)<br>Like [OutputStream.write](#), this writes `byteCount` bytes of `source`, starting at `offset`.`abstract fun write(source: `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`, offset: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, byteCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](./index.md)<br>Removes `byteCount` bytes from `source` and appends them to this sink.`abstract fun write(source: `[`Source`](../-source/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`BufferedSink`](./index.md) |
| (js, jvm, native) [writeAll](write-all.md) | Removes all bytes from `source` and appends them to this sink. Returns the number of bytes read which will be 0 if `source` is exhausted.`abstract fun writeAll(source: `[`Source`](../-source/index.md)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| (js, jvm, native) [writeByte](write-byte.md) | Writes a byte to this sink.`abstract fun writeByte(b: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](./index.md) |
| (js, jvm, native) [writeDecimalLong](write-decimal-long.md) | Writes a long to this sink in signed decimal form (i.e., as a string in base 10).`abstract fun writeDecimalLong(v: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`BufferedSink`](./index.md) |
| (js, jvm, native) [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md) | Writes a long to this sink in hexadecimal form (i.e., as a string in base 16).`abstract fun writeHexadecimalUnsignedLong(v: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`BufferedSink`](./index.md) |
| (js, jvm, native) [writeInt](write-int.md) | Writes a big-endian int to this sink using four bytes.`abstract fun writeInt(i: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](./index.md) |
| (js, jvm, native) [writeIntLe](write-int-le.md) | Writes a little-endian int to this sink using four bytes.`abstract fun writeIntLe(i: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](./index.md) |
| (js, jvm, native) [writeLong](write-long.md) | Writes a big-endian long to this sink using eight bytes.`abstract fun writeLong(v: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`BufferedSink`](./index.md) |
| (js, jvm, native) [writeLongLe](write-long-le.md) | Writes a little-endian long to this sink using eight bytes.`abstract fun writeLongLe(v: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`BufferedSink`](./index.md) |
| (js, jvm, native) [writeShort](write-short.md) | Writes a big-endian short to this sink using two bytes.`abstract fun writeShort(s: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](./index.md) |
| (js, jvm, native) [writeShortLe](write-short-le.md) | Writes a little-endian short to this sink using two bytes.`abstract fun writeShortLe(s: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](./index.md) |
| (jvm) [writeString](write-string.md) | `abstract fun writeString(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, charset: `[`Charset`](https://docs.oracle.com/javase/6/docs/api/java/nio/charset/Charset.html)`): `[`BufferedSink`](./index.md)<br>`abstract fun writeString(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, beginIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, endIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, charset: `[`Charset`](https://docs.oracle.com/javase/6/docs/api/java/nio/charset/Charset.html)`): `[`BufferedSink`](./index.md) |
| (js, jvm, native) [writeUtf8](write-utf8.md) | Encodes `string` in UTF-8 and writes it to this sink.`abstract fun writeUtf8(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`BufferedSink`](./index.md)<br>Encodes the characters at `beginIndex` up to `endIndex` from `string` in UTF-8 and writes it to this sink.`abstract fun writeUtf8(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, beginIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, endIndex: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](./index.md) |
| (js, jvm, native) [writeUtf8CodePoint](write-utf8-code-point.md) | Encodes `codePoint` in UTF-8 and writes it to this sink.`abstract fun writeUtf8CodePoint(codePoint: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`BufferedSink`](./index.md) |

### Extension Functions

| Name | Summary |
|---|---|
| (jvm) [deflate](../deflate.md) | Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](../-sink/index.md#okio.Sink) while writing.`fun `[`Sink`](../-sink/index.md)`.deflate(deflater: `[`Deflater`](https://docs.oracle.com/javase/6/docs/api/java/util/zip/Deflater.html)` = Deflater()): `[`DeflaterSink`](../-deflater-sink/index.md) |
| (jvm) [gzip](../gzip.md) | Returns a [GzipSink](../-gzip-sink/index.md) that gzip-compresses to this [Sink](../-sink/index.md#okio.Sink) while writing.`fun `[`Sink`](../-sink/index.md)`.gzip(): `[`GzipSink`](../-gzip-sink/index.md) |

### Inheritors

| Name | Summary |
|---|---|
| (js, jvm, native) [Buffer](../-buffer/index.md) | A collection of bytes in memory.`class Buffer : `[`BufferedSource`](../-buffered-source/index.md)`, `[`BufferedSink`](./index.md) |
