[okio](../../index.md) / [okio](../index.md) / [Sink](./index.md)

# Sink

(js, jvm, native) `interface Sink`(js)

Receives a stream of bytes. Use this interface to write data wherever it's needed: to the
network, storage, or a buffer in memory. Sinks may be layered to transform received data, such as
to compress, encrypt, throttle, or add protocol framing.

Most application code shouldn't operate on a sink directly, but rather on a [BufferedSink](../-buffered-sink/index.md#okio.BufferedSink) which
is both more efficient and more convenient. Use [buffer](../buffer.md#okio$buffer(okio.Source)) to wrap any sink with a buffer.

Sinks are easy to test: just use a [Buffer](../-buffer/index.md#okio.Buffer) in your tests, and read from it to confirm it
received the data that was expected.

### Comparison with OutputStream

This interface is functionally equivalent to [java.io.OutputStream](#).

`OutputStream` requires multiple layers when emitted data is heterogeneous: a `DataOutputStream`
for primitive values, a `BufferedOutputStream` for buffering, and `OutputStreamWriter` for
charset encoding. This library uses `BufferedSink` for all of the above.

Sink is also easier to layer: there is no [write()](#) method that is
awkward to implement efficiently.

### Interop with OutputStream

Use [sink](#) to adapt an `OutputStream` to a sink. Use [outputStream()](#)
to adapt a sink to an `OutputStream`.

(jvm)

Receives a stream of bytes. Use this interface to write data wherever it's needed: to the
network, storage, or a buffer in memory. Sinks may be layered to transform received data, such as
to compress, encrypt, throttle, or add protocol framing.

Most application code shouldn't operate on a sink directly, but rather on a [BufferedSink](../-buffered-sink/index.md#okio.BufferedSink) which
is both more efficient and more convenient. Use [buffer](../buffer.md#okio$buffer(okio.Source)) to wrap any sink with a buffer.

Sinks are easy to test: just use a [Buffer](../-buffer/index.md#okio.Buffer) in your tests, and read from it to confirm it
received the data that was expected.

### Comparison with OutputStream

This interface is functionally equivalent to [java.io.OutputStream](https://docs.oracle.com/javase/6/docs/api/java/io/OutputStream.html).

`OutputStream` requires multiple layers when emitted data is heterogeneous: a `DataOutputStream`
for primitive values, a `BufferedOutputStream` for buffering, and `OutputStreamWriter` for
charset encoding. This library uses `BufferedSink` for all of the above.

Sink is also easier to layer: there is no [write()](https://docs.oracle.com/javase/6/docs/api/java/io/OutputStream.html#write(int)) method that is
awkward to implement efficiently.

### Interop with OutputStream

Use [sink](../java.io.-output-stream/sink.md) to adapt an `OutputStream` to a sink. Use [outputStream()](../-buffered-sink/output-stream.md)
to adapt a sink to an `OutputStream`.

### Functions

| Name | Summary |
|---|---|
| (js, jvm, native) [close](close.md) | Pushes all buffered bytes to their final destination and releases the resources held by this sink. It is an error to write a closed sink. It is safe to close a sink more than once.`abstract fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (js, jvm, native) [flush](flush.md) | Pushes all buffered bytes to their final destination.`abstract fun flush(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| (js, jvm, native) [timeout](timeout.md) | Returns the timeout for this sink.`abstract fun timeout(): `[`Timeout`](../-timeout/index.md) |
| (js, jvm, native) [write](write.md) | Removes `byteCount` bytes from `source` and appends them to this.`abstract fun write(source: `[`Buffer`](../-buffer/index.md)`, byteCount: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Extension Functions

| Name | Summary |
|---|---|
| (jvm) [deflate](../deflate.md) | Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](index.md#okio.Sink) while writing.`fun `[`Sink`](./index.md)`.deflate(deflater: `[`Deflater`](https://docs.oracle.com/javase/6/docs/api/java/util/zip/Deflater.html)` = Deflater()): `[`DeflaterSink`](../-deflater-sink/index.md) |
| (jvm) [gzip](../gzip.md) | Returns a [GzipSink](../-gzip-sink/index.md) that gzip-compresses to this [Sink](index.md#okio.Sink) while writing.`fun `[`Sink`](./index.md)`.gzip(): `[`GzipSink`](../-gzip-sink/index.md) |

### Inheritors

| Name | Summary |
|---|---|
| (js, jvm, native) [BufferedSink](../-buffered-sink/index.md) | A sink that keeps a buffer internally so that callers can do small writes without a performance penalty.`interface BufferedSink : `[`Sink`](./index.md) |
| (jvm) [DeflaterSink](../-deflater-sink/index.md) | A sink that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to compress data written to another source.`class DeflaterSink : `[`Sink`](./index.md) |
| (jvm) [ForwardingSink](../-forwarding-sink/index.md) | A [Sink](index.md#okio.Sink) which forwards calls to another. Useful for subclassing.`abstract class ForwardingSink : `[`Sink`](./index.md) |
| (jvm) [GzipSink](../-gzip-sink/index.md) | A sink that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to compress written data to another sink.`class GzipSink : `[`Sink`](./index.md) |
