//[okio](../../index.md)/[okio](../index.md)/[HashingSource](index.md)



# HashingSource  
 [jvm] A source that computes a hash of the full stream of bytes it has supplied. To use, create an instance with your preferred hash algorithm. Exhaust the source by reading all of its bytes and then call [hash](index.md#okio/HashingSource/hash/#/PointingToDeclaration/) to compute the final hash value.In this example we use HashingSource with a [BufferedSource](../-buffered-source/index.md) to make reading from the source easier.HashingSource hashingSource = HashingSource.sha256(rawSource);  
BufferedSource bufferedSource = Okio.buffer(hashingSource);  
  
... // Read all of bufferedSource.  
  
ByteString hash = hashingSource.hash();  
  
class [HashingSource](index.md) : [ForwardingSource](../-forwarding-source/index.md)   


## Types  
  
|  Name|  Summary| 
|---|---|
| [Companion](-companion/index.md)| [jvm]  <br>Content  <br>object [Companion](-companion/index.md)  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| [close](../-forwarding-source/close.md)| [jvm]  <br>Content  <br>open override fun [close](../-forwarding-source/close.md)()  <br><br><br>
| [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)| [jvm]  <br>Content  <br>open operator override fun [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)| [jvm]  <br>Content  <br>open override fun [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| [read](read.md)| [jvm]  <br>Content  <br>open override fun [read](read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>
| [timeout](../-forwarding-source/timeout.md)| [jvm]  <br>Content  <br>open override fun [timeout](../-forwarding-source/timeout.md)(): [Timeout](../-timeout/index.md)  <br><br><br>
| [toString](../-forwarding-source/to-string.md)| [jvm]  <br>Content  <br>open override fun [toString](../-forwarding-source/to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| [delegate](index.md#okio/HashingSource/delegate/#/PointingToDeclaration/)|  [jvm] [Source](../-source/index.md) to which this instance is delegating.override val [delegate](index.md#okio/HashingSource/delegate/#/PointingToDeclaration/): [Source](../-source/index.md)   <br>
| [hash](index.md#okio/HashingSource/hash/#/PointingToDeclaration/)|  [jvm] Returns the hash of the bytes supplied thus far and resets the internal state of this source. This method is not idempotent. Each time this method is called its internal state is cleared. This starts a new hash with zero bytes supplied.val [hash](index.md#okio/HashingSource/hash/#/PointingToDeclaration/): [ByteString](../-byte-string/index.md)   <br>

