//[okio](../../index.md)/[okio](../index.md)/[Timeout](index.md)



# Timeout  
 [js, jvm, native] open class [Timeout](index.md)   


## Types  
  
|  Name|  Summary| 
|---|---|
| [Companion](-companion/index.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>object [Companion](-companion/index.md)  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| [clearDeadline](clear-deadline.md)| [jvm]  <br>Brief description  <br>Clears the deadline.  <br>Content  <br>open fun [clearDeadline](clear-deadline.md)(): [Timeout](index.md)  <br><br><br>
| [clearTimeout](clear-timeout.md)| [jvm]  <br>Brief description  <br>Clears the timeout. Operating system timeouts may still apply.  <br>Content  <br>open fun [clearTimeout](clear-timeout.md)(): [Timeout](index.md)  <br><br><br>
| [deadline](deadline.md)| [jvm]  <br>Brief description  <br>Set a deadline of now plus duration time.  <br>Content  <br>fun [deadline](deadline.md)(duration: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](index.md)  <br><br><br>
| [deadlineNanoTime](deadline-nano-time.md)| [jvm]  <br>Brief description  <br>Returns the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached.  <br>Content  <br>open fun [deadlineNanoTime](deadline-nano-time.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>[jvm]  <br>Brief description  <br>Sets the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached. All operations must complete before this time. Use a deadline to set a maximum bound on the time spent on a sequence of operations.  <br>Content  <br>open fun [deadlineNanoTime](deadline-nano-time.md)(deadlineNanoTime: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Timeout](index.md)  <br><br><br>
| [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open operator override fun [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [hasDeadline](has-deadline.md)| [jvm]  <br>Brief description  <br>Returns true if a deadline is enabled.  <br>Content  <br>open fun [hasDeadline](has-deadline.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| [intersectWith](intersect-with.md)| [jvm]  <br>Brief description  <br>Applies the minimum intersection between this timeout and other, run block, then finally rollback this timeout's values.  <br>Content  <br>inline fun [intersectWith](intersect-with.md)(other: [Timeout](index.md), block: () -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br><br><br>
| [throwIfReached](throw-if-reached.md)| [jvm]  <br>Brief description  <br>Throws an [InterruptedIOException](https://docs.oracle.com/javase/8/docs/api/java/io/InterruptedIOException.html) if the deadline has been reached or if the current thread has been interrupted. This method doesn't detect timeouts; that should be implemented to asynchronously abort an in-progress operation.  <br>Content  <br>open fun [throwIfReached](throw-if-reached.md)()  <br><br><br>
| [timeout](timeout.md)| [jvm]  <br>Brief description  <br>Wait at most timeout time before aborting an operation. Using a per-operation timeout means that as long as forward progress is being made, no sequence of operations will fail.If timeout == 0, operations will run indefinitely. (Operating system timeouts may still apply.)  <br>Content  <br>open fun [timeout](timeout.md)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](index.md)  <br><br><br>
| [timeoutNanos](timeout-nanos.md)| [jvm]  <br>Brief description  <br>Returns the timeout in nanoseconds, or 0 for no timeout.  <br>Content  <br>open fun [timeoutNanos](timeout-nanos.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>
| [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| [waitUntilNotified](wait-until-notified.md)| [jvm]  <br>Brief description  <br>Waits on monitor until it is notified. Throws [InterruptedIOException](https://docs.oracle.com/javase/8/docs/api/java/io/InterruptedIOException.html) if either the thread is interrupted or if this timeout elapses before monitor is notified. The caller must be synchronized on monitor.Here's a sample class that uses waitUntilNotified() to await a specific state. Note that the call is made within a loop to avoid unnecessary waiting and to mitigate spurious notifications.class Dice {  <br>  Random random = new Random();  <br>  int latestTotal;  <br>  <br>  public synchronized void roll() {  <br>    latestTotal = 2 + random.nextInt(6) + random.nextInt(6);  <br>    System.out.println("Rolled " + latestTotal);  <br>    notifyAll();  <br>  }  <br>  <br>  public void rollAtFixedRate(int period, TimeUnit timeUnit) {  <br>    Executors.newScheduledThreadPool(0).scheduleAtFixedRate(new Runnable() {  <br>      public void run() {  <br>        roll();  <br>      }  <br>    }, 0, period, timeUnit);  <br>  }  <br>  <br>  public synchronized void awaitTotal(Timeout timeout, int total)  <br>      throws InterruptedIOException {  <br>    while (latestTotal != total) {  <br>      timeout.waitUntilNotified(this);  <br>    }  <br>  }  <br>}  <br>Content  <br>fun [waitUntilNotified](wait-until-notified.md)(monitor: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br><br><br>


## Inheritors  
  
|  Name| 
|---|
| [AsyncTimeout](../-async-timeout/index.md)
| [ForwardingTimeout](../-forwarding-timeout/index.md)

