//[okio](../../index.md)/[okio](../index.md)/[Buffer](index.md)



# Buffer  
 [js, native] class [Buffer](index.md) : [BufferedSource](../-buffered-source/index.md), [BufferedSink](../-buffered-sink/index.md)   
 [jvm] class [Buffer](index.md) : [BufferedSource](../-buffered-source/index.md), [BufferedSink](../-buffered-sink/index.md), [Cloneable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-cloneable/index.html), [ByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/ByteChannel.html)   


## Types  
  
|  Name|  Summary| 
|---|---|
| [UnsafeCursor](-unsafe-cursor/index.md)| [jvm]  <br>Brief description  <br>A handle to the underlying data in a buffer. This handle is unsafe because it does not enforce its own invariants. Instead, it assumes a careful user who has studied Okio's implementation details and their consequences.Buffer Internals ----------------Most code should use Buffer as a black box: a class that holds 0 or more bytes of data with efficient APIs to append data to the end and to consume data from the front. Usually this is also the most efficient way to use buffers because it allows Okio to employ several optimizations, including:<ul><li>Buffers use a shared pool of memory that is not zero-filled before use.</li><li>A buffer's capacity can change without copying its contents.</li><li>Memory ownership can be reassigned from one buffer to another.</li><li>Multiple buffers can share the same underlying memory.</li><li>Common operations like UTF-8 encoding and decimal decoding     do not require intermediate objects to be allocated.</li></ul>These optimizations all leverage the way Okio stores data internally. Okio Buffers are implemented using a doubly-linked list of segments. Each segment is a contiguous range within a 8 KiB ByteArray. Each segment has two indexes, start, the offset of the first byte of the array containing application data, and end, the offset of the first byte beyond start whose data is undefined.New buffers are empty and have no segments:val buffer = Buffer()We append 7 bytes of data to the end of our empty buffer. Internally, the buffer allocates a segment and writes its new data there. The lone segment has an 8 KiB byte array but only 7 bytes of data:buffer.writeUtf8("sealion")  <br>  <br>// [ 's', 'e', 'a', 'l', 'i', 'o', 'n', '?', '?', '?', ...]  <br>//    ^                                  ^  <br>// start = 0                          end = 7When we read 4 bytes of data from the buffer, it finds its first segment and returns that data to us. As bytes are read the data is consumed. The segment tracks this by adjusting its internal indices.buffer.readUtf8(4) // "seal"  <br>  <br>// [ 's', 'e', 'a', 'l', 'i', 'o', 'n', '?', '?', '?', ...]  <br>//                        ^              ^  <br>//                     start = 4      end = 7As we write data into a buffer we fill up its internal segments. When a write doesn't fit into a buffer's last segment, additional segments are allocated and appended to the linked list of segments. Each segment has its own start and end indexes tracking where the user's data begins and ends.val xoxo = new Buffer()  <br>xoxo.writeUtf8("xo".repeat(5_000))  <br>  <br>// [ 'x', 'o', 'x', 'o', 'x', 'o', 'x', 'o', ..., 'x', 'o', 'x', 'o']  <br>//    ^                                                               ^  <br>// start = 0                                                      end = 8192  <br>//  <br>// [ 'x', 'o', 'x', 'o', ..., 'x', 'o', 'x', 'o', '?', '?', '?', ...]  <br>//    ^                                            ^  <br>// start = 0                                   end = 1808The start index is always **inclusive** and the end index is always **exclusive**. The data preceding the start index is undefined, and the data at and following the end index is undefined.After the last byte of a segment has been read, that segment may be returned to an internal segment pool. In addition to reducing the need to do garbage collection, segment pooling also saves the JVM from needing to zero-fill byte arrays. Okio doesn't need to zero-fill its arrays because it always writes memory before it reads it. But if you look at a segment in a debugger you may see its effects. In this example, one of the "xoxo" segments above is reused in an unrelated buffer:val abc = new Buffer()  <br>abc.writeUtf8("abc")  <br>  <br>// [ 'a', 'b', 'c', 'o', 'x', 'o', 'x', 'o', ...]  <br>//    ^              ^  <br>// start = 0     end = 3There is an optimization in Buffer.clone() and other methods that allows two segments to share the same underlying byte array. Clones can't write to the shared byte array; instead they allocate a new (private) segment early.val nana = new Buffer()  <br>nana.writeUtf8("na".repeat(2_500))  <br>nana.readUtf8(2) // "na"  <br>  <br>// [ 'n', 'a', 'n', 'a', ..., 'n', 'a', 'n', 'a', '?', '?', '?', ...]  <br>//              ^                                  ^  <br>//           start = 2                         end = 5000  <br>  <br>nana2 = nana.clone()  <br>nana2.writeUtf8("batman")  <br>  <br>// [ 'n', 'a', 'n', 'a', ..., 'n', 'a', 'n', 'a', '?', '?', '?', ...]  <br>//              ^                                  ^  <br>//           start = 2                         end = 5000  <br>//  <br>// [ 'b', 'a', 't', 'm', 'a', 'n', '?', '?', '?', ...]  <br>//    ^                             ^  <br>//  start = 0                    end = 6Segments are not shared when the shared region is small (ie. less than 1 KiB). This is intended to prevent fragmentation in sharing-heavy use cases.Unsafe Cursor API -----------------This class exposes privileged access to the internal byte arrays of a buffer. A cursor either references the data of a single segment, it is before the first segment (offset == -1), or it is after the last segment (offset == buffer.size).Call [UnsafeCursor.seek](-unsafe-cursor/seek.md) to move the cursor to the segment that contains a specified offset. After seeking, [UnsafeCursor.data](-unsafe-cursor/index.md#okio/Buffer.UnsafeCursor/data/#/PointingToDeclaration/) references the segment's internal byte array, [UnsafeCursor.start](-unsafe-cursor/index.md#okio/Buffer.UnsafeCursor/start/#/PointingToDeclaration/) is the segment's start and [UnsafeCursor.end](-unsafe-cursor/index.md#okio/Buffer.UnsafeCursor/end/#/PointingToDeclaration/) is its end.Call [UnsafeCursor.next](-unsafe-cursor/next.md) to advance the cursor to the next segment. This returns -1 if there are no further segments in the buffer.Use [Buffer.readUnsafe](read-unsafe.md) to create a cursor to read buffer data and [Buffer.readAndWriteUnsafe](read-and-write-unsafe.md) to create a cursor to read and write buffer data. In either case, always call [UnsafeCursor.close](-unsafe-cursor/close.md) when done with a cursor. This is convenient with Kotlin's [use](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.io/index.html) extension function. In this example we read all of the bytes in a buffer into a byte array:val bufferBytes = ByteArray(buffer.size.toInt())  <br>  <br>buffer.readUnsafe().use { cursor ->  <br>  while (cursor.next() != -1) {  <br>    System.arraycopy(cursor.data, cursor.start,  <br>        bufferBytes, cursor.offset.toInt(), cursor.end - cursor.start);  <br>  }  <br>}Change the capacity of a buffer with [resizeBuffer](-unsafe-cursor/resize-buffer.md). This is only permitted for read+write cursors. The buffer's size always changes from the end: shrinking it removes bytes from the end; growing it adds capacity to the end.Warnings --------Most application developers should avoid this API. Those that must use this API should respect these warnings. This class has public, non-final fields because that is convenient for low-level I/O frameworks. Never assign values to these fields; instead use the cursor API to adjust these.**data** You are on the honor system to never write the buffer in read-only mode. Read-only mode may be more efficient than read+write mode because it does not need to make private copies of shared segments.**[start..end)** Other data in the byte array is undefined! It may contain private or sensitive data from other parts of your process.**Always fill the new capacity when you grow a buffer.** New capacity is not zero-filled and may contain data from other parts of your process. Avoid leaking this information by always writing something to the newly-allocated capacity. Do not assume that new capacity will be filled with 0; it will not be.**Do not access a buffer while is being accessed by a cursor.** Even simple read-only operations like [Buffer.clone](clone.md) are unsafe because they mark segments as shared.**Do not hard-code the segment size in your application.** It is possible that segment sizes will change with advances in hardware. Future versions of Okio may even have heterogeneous segment sizes.These warnings are intended to help you to use this API safely. It's here for developers that need absolutely the most throughput. Since that's you, here's one final performance tip. You can reuse instances of this class if you like. Use the overloads of [Buffer.readUnsafe](read-unsafe.md) and [Buffer.readAndWriteUnsafe](read-and-write-unsafe.md) that take a cursor and close it after use.  <br>Content  <br>class [UnsafeCursor](-unsafe-cursor/index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html)  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| [buffer](buffer.md)| [jvm]  <br>Brief description  <br>Returns this source's internal buffer.  <br>Content  <br>open override fun [buffer](buffer.md)(): [Buffer](index.md)  <br><br><br>
| [clear](clear.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>fun [clear](clear.md)()  <br><br><br>
| [clone](clone.md)| [jvm]  <br>Brief description  <br>Returns a deep copy of this buffer.  <br>Content  <br>open override fun [clone](clone.md)(): [Buffer](index.md)  <br><br><br>
| [close](close.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [close](close.md)()  <br><br><br>
| [completeSegmentByteCount](complete-segment-byte-count.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>fun [completeSegmentByteCount](complete-segment-byte-count.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>
| [copy](copy.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>fun [copy](copy.md)(): [Buffer](index.md)  <br><br><br>
| [copyTo](copy-to.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>fun [copyTo](copy-to.md)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br>[js, jvm, native]  <br>fun [copyTo](copy-to.md)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br><br><br>[jvm]  <br>Brief description  <br>Copy byteCount bytes from this, starting at offset, to out.  <br>Content  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>fun [copyTo](copy-to.md)(out: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br><br><br>
| [emit](emit.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [emit](emit.md)(): [Buffer](index.md)  <br><br><br>
| [emitCompleteSegments](emit-complete-segments.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [emitCompleteSegments](emit-complete-segments.md)(): [Buffer](index.md)  <br><br><br>
| [equals](equals.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [exhausted](exhausted.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [exhausted](exhausted.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [flush](flush.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [flush](flush.md)()  <br><br><br>
| [get](get.md)| [js, jvm, native]  <br>Content  <br>[js, native]  <br>operator fun [get](get.md)(pos: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)  <br>[jvm]  <br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "getByte")  <br>  <br>operator fun [get](get.md)(pos: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)  <br><br><br>
| [hashCode](hash-code.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [hashCode](hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| [hmacSha1](hmac-sha1.md)| [jvm]  <br>Brief description  <br>Returns the 160-bit SHA-1 HMAC of this buffer.  <br>Content  <br>fun [hmacSha1](hmac-sha1.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)  <br><br><br>
| [hmacSha256](hmac-sha256.md)| [jvm]  <br>Brief description  <br>Returns the 256-bit SHA-256 HMAC of this buffer.  <br>Content  <br>fun [hmacSha256](hmac-sha256.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)  <br><br><br>
| [hmacSha512](hmac-sha512.md)| [jvm]  <br>Brief description  <br>Returns the 512-bit SHA-512 HMAC of this buffer.  <br>Content  <br>fun [hmacSha512](hmac-sha512.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)  <br><br><br>
| [indexOf](index-of.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>[js, native]  <br>open override fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>[js, jvm, native]  <br>open override fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>[js, native]  <br>open override fun [indexOf](index-of.md)(bytes: [<ERROR CLASS>]()): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>[js, native]  <br>open override fun [indexOf](index-of.md)(bytes: [<ERROR CLASS>](), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>[jvm]  <br>open override fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>[jvm]  <br>open override fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>[jvm]  <br>Brief description  <br>Returns the index of b in this at or beyond fromIndex, or -1 if this buffer does not contain b in that range.  <br>Content  <br>open override fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>
| [indexOfElement](index-of-element.md)| [js, native, jvm]  <br>Content  <br>[js, native]  <br>open override fun [indexOfElement](index-of-element.md)(targetBytes: [<ERROR CLASS>]()): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>[js, native]  <br>open override fun [indexOfElement](index-of-element.md)(targetBytes: [<ERROR CLASS>](), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>[jvm]  <br>open override fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>[jvm]  <br>open override fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>
| [inputStream](input-stream.md)| [jvm]  <br>Brief description  <br>Returns an input stream that reads from this source.  <br>Content  <br>open override fun [inputStream](input-stream.md)(): [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)  <br><br><br>
| [isOpen](is-open.md)| [jvm]  <br>Content  <br>open override fun [isOpen](is-open.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [md5](md5.md)| [jvm]  <br>Brief description  <br>Returns the 128-bit MD5 hash of this buffer.  <br>Content  <br>fun [md5](md5.md)(): [ByteString](../-byte-string/index.md)  <br><br><br>
| [outputStream](output-stream.md)| [jvm]  <br>Brief description  <br>Returns an output stream that writes to this sink.  <br>Content  <br>open override fun [outputStream](output-stream.md)(): [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)  <br><br><br>
| [peek](peek.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [peek](peek.md)(): [BufferedSource](../-buffered-source/index.md)  <br><br><br>
| [rangeEquals](range-equals.md)| [js, native, jvm]  <br>Content  <br>[js, native]  <br>open override fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [<ERROR CLASS>]()): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>[js, native]  <br>open override fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [<ERROR CLASS>](), bytesOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>[jvm]  <br>open override fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>[jvm]  <br>open override fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md), bytesOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [read](read.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>[js, jvm, native]  <br>open override fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>[js, jvm, native]  <br>open override fun [read](read.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>[jvm]  <br>open override fun [read](read.md)(sink: [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| [readAll](read-all.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [readAll](read-all.md)(sink: [Sink](../-sink/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>
| [readAndWriteUnsafe](read-and-write-unsafe.md)| [jvm]  <br>Content  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>fun [readAndWriteUnsafe](read-and-write-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md)): [Buffer.UnsafeCursor](-unsafe-cursor/index.md)  <br><br><br>
| [readByte](read-byte.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [readByte](read-byte.md)(): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)  <br><br><br>
| [readByteArray](read-byte-array.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [readByteArray](read-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)  <br>[js, jvm, native]  <br>open override fun [readByteArray](read-byte-array.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)  <br><br><br>
| [readByteString](read-byte-string.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [readByteString](read-byte-string.md)(): [<ERROR CLASS>]()  <br>[js, jvm, native]  <br>open override fun [readByteString](read-byte-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [<ERROR CLASS>]()  <br><br><br>
| [readDecimalLong](read-decimal-long.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [readDecimalLong](read-decimal-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>
| [readFrom](read-from.md)| [jvm]  <br>Brief description  <br>Read and exhaust bytes from input into this.  <br>Content  <br>fun [readFrom](read-from.md)(input: [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)): [Buffer](index.md)  <br><br><br>[jvm]  <br>Brief description  <br>Read byteCount bytes from input into this.  <br>Content  <br>fun [readFrom](read-from.md)(input: [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br><br><br>
| [readFully](read-fully.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [readFully](read-fully.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>[js, jvm, native]  <br>open override fun [readFully](read-fully.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html))  <br><br><br>
| [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>
| [readInt](read-int.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [readInt](read-int.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| [readIntLe](read-int-le.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [readIntLe](read-int-le.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| [readLong](read-long.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [readLong](read-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>
| [readLongLe](read-long-le.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [readLongLe](read-long-le.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>
| [readShort](read-short.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [readShort](read-short.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)  <br><br><br>
| [readShortLe](read-short-le.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [readShortLe](read-short-le.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)  <br><br><br>
| [readString](read-string.md)| [jvm]  <br>Brief description  <br>Removes all bytes from this, decodes them as charset, and returns the string.  <br>Content  <br>open override fun [readString](read-string.md)(charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>[jvm]  <br>Brief description  <br>Removes byteCount bytes from this, decodes them as charset, and returns the string.  <br>Content  <br>open override fun [readString](read-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| [readUnsafe](read-unsafe.md)| [jvm]  <br>Content  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>fun [readUnsafe](read-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md)): [Buffer.UnsafeCursor](-unsafe-cursor/index.md)  <br><br><br>
| [readUtf8](read-utf8.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [readUtf8](read-utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>[js, jvm, native]  <br>open override fun [readUtf8](read-utf8.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| [readUtf8CodePoint](read-utf8-code-point.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [readUtf8CodePoint](read-utf8-code-point.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| [readUtf8Line](read-utf8-line.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [readUtf8Line](read-utf8-line.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?  <br><br><br>
| [readUtf8LineStrict](read-utf8-line-strict.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [readUtf8LineStrict](read-utf8-line-strict.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>[js, jvm, native]  <br>open override fun [readUtf8LineStrict](read-utf8-line-strict.md)(limit: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| [request](request.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [request](request.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [require](require.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [require](require.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br><br><br>
| [select](select.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [select](select.md)(options: [<ERROR CLASS>]()): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| [sha1](sha1.md)| [jvm]  <br>Brief description  <br>Returns the 160-bit SHA-1 hash of this buffer.  <br>Content  <br>fun [sha1](sha1.md)(): [ByteString](../-byte-string/index.md)  <br><br><br>
| [sha256](sha256.md)| [jvm]  <br>Brief description  <br>Returns the 256-bit SHA-256 hash of this buffer.  <br>Content  <br>fun [sha256](sha256.md)(): [ByteString](../-byte-string/index.md)  <br><br><br>
| [sha512](sha512.md)| [jvm]  <br>Brief description  <br>Returns the 512-bit SHA-512 hash of this buffer.  <br>Content  <br>fun [sha512](sha512.md)(): [ByteString](../-byte-string/index.md)  <br><br><br>
| [skip](skip.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [skip](skip.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br><br><br>
| [snapshot](snapshot.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>fun [snapshot](snapshot.md)(): [<ERROR CLASS>]()  <br>[js, jvm, native]  <br>fun [snapshot](snapshot.md)(byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [<ERROR CLASS>]()  <br><br><br>
| [timeout](timeout.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)  <br><br><br>
| [toString](to-string.md)| [js, jvm, native]  <br>Brief description  <br>Returns a human-readable string that describes the contents of this buffer. Typically this is a string like [text=Hello] or [hex=0000ffff].  <br>Content  <br>[js, jvm, native]  <br>open override fun [toString](to-string.md)(): [<ERROR CLASS>]()  <br><br><br>
| [write](write.md)| [js, native, jvm]  <br>Content  <br>[js, native]  <br>open override fun [write](write.md)(byteString: [<ERROR CLASS>]()): [Buffer](index.md)  <br>[js, native]  <br>open override fun [write](write.md)(byteString: [<ERROR CLASS>](), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [<ERROR CLASS>]()  <br>[js, jvm, native]  <br>open override fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Buffer](index.md)  <br>[js, jvm, native]  <br>open override fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>[js, jvm, native]  <br>open override fun [write](write.md)(source: [Source](../-source/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br>[js, jvm, native]  <br>open override fun [write](write.md)(source: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>[jvm]  <br>open override fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md)): [Buffer](index.md)  <br>[jvm]  <br>open override fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [<ERROR CLASS>]()  <br>[jvm]  <br>open override fun [write](write.md)(source: [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| [writeAll](write-all.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [writeAll](write-all.md)(source: [Source](../-source/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>
| [writeByte](write-byte.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [writeByte](write-byte.md)(b: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br><br><br>
| [writeDecimalLong](write-decimal-long.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [writeDecimalLong](write-decimal-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br><br><br>
| [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br><br><br>
| [writeInt](write-int.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [writeInt](write-int.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br><br><br>
| [writeIntLe](write-int-le.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [writeIntLe](write-int-le.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br><br><br>
| [writeLong](write-long.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [writeLong](write-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br><br><br>
| [writeLongLe](write-long-le.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [writeLongLe](write-long-le.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br><br><br>
| [writeShort](write-short.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [writeShort](write-short.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br><br><br>
| [writeShortLe](write-short-le.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [writeShortLe](write-short-le.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br><br><br>
| [writeString](write-string.md)| [jvm]  <br>Content  <br>open override fun [writeString](write-string.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [Buffer](index.md)  <br>open override fun [writeString](write-string.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [Buffer](index.md)  <br><br><br>
| [writeTo](write-to.md)| [jvm]  <br>Brief description  <br>Write byteCount bytes from this to out.  <br>Content  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>fun [writeTo](write-to.md)(out: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br><br><br>
| [writeUtf8](write-utf8.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](index.md)  <br>[js, jvm, native]  <br>open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br><br><br>
| [writeUtf8CodePoint](write-utf8-code-point.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [writeUtf8CodePoint](write-utf8-code-point.md)(codePoint: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| [buffer](buffer.md)|  [js, jvm, native] open override val [buffer](buffer.md): [Buffer](index.md)   <br>
| [size](index.md#okio/Buffer/size/#/PointingToDeclaration/)|  [js, jvm, native] var [size](index.md#okio/Buffer/size/#/PointingToDeclaration/): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)   <br>

