//[okio](../../index.md)/[okio](../index.md)/[ByteString](index.md)



# ByteString  
 [jvm] open class [ByteString](index.md) : [Serializable](https://docs.oracle.com/javase/8/docs/api/java/io/Serializable.html), [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)   


## Types  
  
|  Name|  Summary| 
|---|---|
| [Companion](-companion/index.md)| [jvm]  <br>Content  <br>object [Companion](-companion/index.md)  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| [asByteBuffer](as-byte-buffer.md)| [jvm]  <br>Brief description  <br>Returns a ByteBuffer view of the bytes in this ByteString.  <br>Content  <br>open fun [asByteBuffer](as-byte-buffer.md)(): [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)  <br><br><br>
| [base64](base64.md)| [jvm]  <br>Content  <br>open fun [base64](base64.md)(): [<ERROR CLASS>]()  <br><br><br>
| [base64Url](base64-url.md)| [jvm]  <br>Content  <br>open fun [base64Url](base64-url.md)(): [<ERROR CLASS>]()  <br><br><br>
| [compareTo](compare-to.md)| [jvm]  <br>Content  <br>open operator override fun [compareTo](compare-to.md)(other: [ByteString](index.md)): [<ERROR CLASS>]()  <br><br><br>
| [endsWith](ends-with.md)| [jvm]  <br>Content  <br>fun [endsWith](ends-with.md)(suffix: [ByteString](index.md)): [<ERROR CLASS>]()  <br>fun [endsWith](ends-with.md)(suffix: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [<ERROR CLASS>]()  <br><br><br>
| [equals](equals.md)| [jvm]  <br>Content  <br>open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [<ERROR CLASS>]()  <br><br><br>
| [get](get.md)| [jvm]  <br>Content  <br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "getByte")  <br>  <br>operator fun [get](get.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)  <br><br><br>
| [hashCode](hash-code.md)| [jvm]  <br>Content  <br>open override fun [hashCode](hash-code.md)(): [<ERROR CLASS>]()  <br><br><br>
| [hex](hex.md)| [jvm]  <br>Content  <br>open fun [hex](hex.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| [hmacSha1](hmac-sha1.md)| [jvm]  <br>Brief description  <br>Returns the 160-bit SHA-1 HMAC of this byte string.  <br>Content  <br>open fun [hmacSha1](hmac-sha1.md)(key: [ByteString](index.md)): [ByteString](index.md)  <br><br><br>
| [hmacSha256](hmac-sha256.md)| [jvm]  <br>Brief description  <br>Returns the 256-bit SHA-256 HMAC of this byte string.  <br>Content  <br>open fun [hmacSha256](hmac-sha256.md)(key: [ByteString](index.md)): [ByteString](index.md)  <br><br><br>
| [hmacSha512](hmac-sha512.md)| [jvm]  <br>Brief description  <br>Returns the 512-bit SHA-512 HMAC of this byte string.  <br>Content  <br>open fun [hmacSha512](hmac-sha512.md)(key: [ByteString](index.md)): [ByteString](index.md)  <br><br><br>
| [indexOf](index-of.md)| [jvm]  <br>Content  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>fun [indexOf](index-of.md)(other: [ByteString](index.md), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [<ERROR CLASS>]()  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>open fun [indexOf](index-of.md)(other: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [<ERROR CLASS>]()  <br><br><br>
| [lastIndexOf](last-index-of.md)| [jvm]  <br>Content  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>fun [lastIndexOf](last-index-of.md)(other: [ByteString](index.md), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [<ERROR CLASS>]()  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>open fun [lastIndexOf](last-index-of.md)(other: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [<ERROR CLASS>]()  <br><br><br>
| [md5](md5.md)| [jvm]  <br>Content  <br>fun [md5](md5.md)(): [<ERROR CLASS>]()  <br><br><br>
| [rangeEquals](range-equals.md)| [jvm]  <br>Content  <br>open fun [rangeEquals](range-equals.md)(offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), other: [ByteString](index.md), otherOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>open fun [rangeEquals](range-equals.md)(offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), other: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), otherOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [sha1](sha1.md)| [jvm]  <br>Content  <br>fun [sha1](sha1.md)(): [<ERROR CLASS>]()  <br><br><br>
| [sha256](sha256.md)| [jvm]  <br>Content  <br>fun [sha256](sha256.md)(): [<ERROR CLASS>]()  <br><br><br>
| [sha512](sha512.md)| [jvm]  <br>Content  <br>fun [sha512](sha512.md)(): [<ERROR CLASS>]()  <br><br><br>
| [startsWith](starts-with.md)| [jvm]  <br>Content  <br>fun [startsWith](starts-with.md)(prefix: [ByteString](index.md)): [<ERROR CLASS>]()  <br>fun [startsWith](starts-with.md)(prefix: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [<ERROR CLASS>]()  <br><br><br>
| [string](string.md)| [jvm]  <br>Brief description  <br>Constructs a new String by decoding the bytes using charset.  <br>Content  <br>open fun [string](string.md)(charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| [substring](substring.md)| [jvm]  <br>Content  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>open fun [substring](substring.md)(beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [ByteString](index.md)  <br><br><br>
| [toAsciiLowercase](to-ascii-lowercase.md)| [jvm]  <br>Content  <br>open fun [toAsciiLowercase](to-ascii-lowercase.md)(): [ByteString](index.md)  <br><br><br>
| [toAsciiUppercase](to-ascii-uppercase.md)| [jvm]  <br>Content  <br>open fun [toAsciiUppercase](to-ascii-uppercase.md)(): [ByteString](index.md)  <br><br><br>
| [toByteArray](to-byte-array.md)| [jvm]  <br>Content  <br>open fun [toByteArray](to-byte-array.md)(): [<ERROR CLASS>]()  <br><br><br>
| [toString](to-string.md)| [jvm]  <br>Content  <br>open override fun [toString](to-string.md)(): [<ERROR CLASS>]()  <br><br><br>
| [utf8](utf8.md)| [jvm]  <br>Content  <br>open fun [utf8](utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| [write](write.md)| [jvm]  <br>Brief description  <br>Writes the contents of this byte string to out.  <br>Content  <br>open fun [write](write.md)(out: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html))  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| [size](index.md#okio/ByteString/size/#/PointingToDeclaration/)|  [jvm] val [size](index.md#okio/ByteString/size/#/PointingToDeclaration/): [<ERROR CLASS>]()   <br>

